/************************************************************************
** Bitmap loading/Saving & displaying functions by RodneyMcConnell 2/9/00
************************************************************************/

#include "bmp.h"

BITMAPFILEHEADER BMPHeader;
BITMAPINFOHEADER BMPInfo;
RGBQUAD Palette;

int loadrestofBMP(char *BMPFile);//return -1 error
int AccessBMP(char *BMPFile);
int loadrestofBMP(char *BMPFile);
int displaybmp();
int saveBMP(BYTE type,char *filename);
BYTE *unpack_2_mem(BYTE *memptr,BYTE scr_head);
int repack_2_mem(BYTE *memptr, unsigned st_ptr,BYTE restorepal);

//Set the header sets the header for a 256colour bitmap ONLY
void set_the_header(int maxX,int maxY){
            BMPHeader.bfType=0x4D42;
            BMPHeader.bfSize=(maxX*maxY)+54+(256*4);//1078;
            BMPHeader.bfReserved1=0;
            BMPHeader.bfReserved2=0;
            BMPHeader.bfOffBits=54+(256*4);//1078;
                    BMPInfo.biSize=40;
            BMPInfo.biWidth=maxX;
            BMPInfo.biHeight=maxY;
                    BMPInfo.biPlanes=1;
                    BMPInfo.biBitCount=8;//256 colour
                    BMPInfo.biCompression=0;
             BMPInfo.biSizeImage=(maxX*maxY);
                    BMPInfo.biXPelsPerMeter=0; BMPInfo.biYPelsPerMeter=0;
                    BMPInfo.biClrUsed=0; BMPInfo.biClrImportant=0;
return; }



/************************************************************************
** Loads a BMP file
************************************************************************/
int loadbmp(char *filename){
      int x,rt=-1,tt;

       x  = AccessBMP(filename);
        //       if(BMPInfo.biSizeImage>320 && BMPInfo.biWidth>320 &&
        //               BMPInfo.biWidth!=BMPInfo.biSizeImage/BMPInfo.biHeight)
        //                       BMPInfo.biWidth=BMPInfo.biSizeImage/BMPInfo.biHeight;
       tt=1;//pixels per bit 
       if (BMPInfo.biBitCount==4)tt=2;//pixels per bit  16 colour
       if (BMPInfo.biBitCount==1)tt=8;//pixels per bit  monochrome

       if(BMPInfo.biSizeImage>0 && BMPInfo.biWidth!=(BMPInfo.biSizeImage*tt)/BMPInfo.biHeight)
                BMPInfo.biWidth=(BMPInfo.biSizeImage*tt)/BMPInfo.biHeight;
       switch(x){
          case BMP_OK: rt=0; loadrestofBMP(filename); break;
          case BMP_FileError: laerror=BMP_FileError; break;
//          case BMP_WrongVideo: error(1,"Supports 16 & 256 Colour only..."); break;
          case BMP_WrongVideo: laerror=BMP_TrueColour; break;
          case BMP_Compression: laerror=BMP_Compression; break;
          default: laerror=BMP_Unknown;
            }
return rt;}

/*************************************************************************
** Reads the BMPfile header, and palette....
*************************************************************************/
int AccessBMP(char *BMPFile){
        int cnt,tt,errorcode=BMP_OK;
        FILE *Fn;

        Fn = fopen(BMPFile,"rb");// Open up BMP image file
        if(Fn==NULL) return BMP_FileError;
        fread(&BMPHeader.bfType,sizeof(WORD),1,Fn);
        fread(&BMPHeader.bfSize,sizeof(unsigned long),1,Fn);
        fread(&BMPHeader.bfReserved1,sizeof(WORD),1,Fn);
        fread(&BMPHeader.bfReserved2,sizeof(WORD),1,Fn);
        fread(&BMPHeader.bfOffBits,sizeof(unsigned long),1,Fn);

        fread(&BMPInfo,sizeof(BMPInfo),1,Fn);//==0)errorcode=BMP_FileError;
        // Error: only 256 or 16-color BMPs can be processed
         if (BMPInfo.biBitCount!=1 && BMPInfo.biBitCount!=8 && BMPInfo.biBitCount!=4) errorcode=BMP_WrongVideo;
         //1=="Monochrome" 4=16colours, 8=256 colours, else "24-Bit RGB"
         // Error: image was compressed 
        if (BMPInfo.biCompression != 0) errorcode=BMP_Compression;

        //get the palette while we're here
        tt=256;
        if (BMPInfo.biBitCount==1)tt=2;//monochrome
        if (BMPInfo.biBitCount==4)tt=16;//16 colour
        for(cnt=0; cnt<tt; cnt++){
              fread(&Palette,sizeof(Palette),1,Fn);
              cur_pal[cnt*3]=Palette.rgbRed/4;
              cur_pal[(cnt*3)+1]=Palette.rgbGreen/4;
              cur_pal[(cnt*3)+2]=Palette.rgbBlue/4;
        	    		}
        fclose(Fn);
return (errorcode); }

/*************************************************************************
** Reads the rest of the bitmap
*************************************************************************/
int loadrestofBMP(char *BMPFile){
        FILE *Fn;\
        LONG length;
        
        Fn = fopen(BMPFile,"rb");               // Open BMP file
        // Jump to image data in 
        fseek(Fn,BMPHeader.bfOffBits,SEEK_SET); // BMP file
        //allocate enough memory
        if (BMPInfo.biBitCount==1) length=(BMPInfo.biWidth*BMPInfo.biHeight)/8;
        else if (BMPInfo.biBitCount==4) length=(BMPInfo.biWidth*BMPInfo.biHeight)/2;
        else length=BMPInfo.biWidth*BMPInfo.biHeight;
        if(BMPimage!=NULL){free(BMPimage);bmp_malfree--; }
        BMPimage = (BYTE *)malloc(length+1);
        if(BMPimage==NULL){ fclose(Fn);
                         laerror=BMP_Memory;
                         return -1; }
        bmp_malfree++;
        fread(BMPimage,length,1,Fn);
      fclose(Fn);
return 0; }


/*************************************************************************
** Display the BMPimage
*************************************************************************/
/*int displaybmp(){
        unsigned int rx, x, y, maxx, maxy,cntr;
        unsigned char Color;

        if(BMPimage==NULL)return -1;
        set_videomode();
        set_palette();
        x = 320; y = 200; //max of the screen display
        maxx = MIN(x,BMPInfo.biWidth);
        maxy = MIN(y,BMPInfo.biHeight);

        y = maxy-1;
       // Note: BMP's are stored in bottom-up fashion!!!
        do{
          for (rx=x=0; x < maxx; x++,rx++){
                         if (BMPInfo.biBitCount==1){//monochrome, 1bit per pixel
                                for(cntr=0;cntr<8;cntr++){
                                        Color=bin_in(BMPimage[rx+(y*(BMPInfo.biWidth/8))],cntr);//get byte
                                        put_la_pixel(x,maxy-y,Color);
                                        if(cntr<7)x++;
                                                                }
                                               }
                         else if (BMPInfo.biBitCount==4){//16 colour, 4bits per pixel
                                Color=BMPimage[rx+(y*(BMPInfo.biWidth/2))];
                                put_la_pixel(x++,maxy-y,(unsigned char)(Color>>4));
                                put_la_pixel(x,maxy-y,(unsigned char)(Color&0xf));
                        			}
                         else{//8bits per pixel 256colour
                          Color=BMPimage[rx+(y*BMPInfo.biWidth)];
                          put_la_pixel( x,  maxy-y, Color);
                          }
                }
         } while (y-- > 0);
        getch();
    	shut_down_gfx();
return 0; }*/


/*************************************************************************
** Saves the bitmap
*************************************************************************/
int saveBMP(BYTE type, char *filename){
      int cnt,tt;
      FILE *Fn;

      Fn = fopen(filename,"wb");               // create BMP file
      if(Fn==NULL)return -1;
   if(type==1){//bmp
//Header1
      fwrite(&BMPHeader.bfType,sizeof(WORD),1,Fn);
      fwrite(&BMPHeader.bfSize,sizeof(LONG),1,Fn);
      fwrite(&BMPHeader.bfReserved1,sizeof(WORD),1,Fn);
      fwrite(&BMPHeader.bfReserved2,sizeof(WORD),1,Fn);
      fwrite(&BMPHeader.bfOffBits,sizeof(unsigned long),1,Fn);
//Header2
      fwrite(&BMPInfo,sizeof(BMPInfo),1,Fn);
//Palette
    tt=256;
    if(BMPInfo.biBitCount==1)tt=2;
    else if(BMPInfo.biBitCount==4)tt=16;
    for(cnt=0; cnt<tt; cnt++){
                Palette.rgbBlue=cur_pal[(cnt*3)+2]*4;
                Palette.rgbGreen=cur_pal[(cnt*3)+1]*4;
                Palette.rgbRed=cur_pal[cnt*3]*4;
                Palette.rgbReserved=0;//Is not used and must be set to zero.
                fwrite(&Palette,sizeof(Palette),1,Fn);
        	    		}
    fseek(Fn,BMPHeader.bfOffBits,SEEK_SET); // BMP file
    }//type 1 bmp
    else if(type==2){//bin header
      fwrite(&BMPInfo.biWidth,sizeof(WORD),1,Fn);
      fwrite(&BMPInfo.biHeight,sizeof(WORD),1,Fn);
      fwrite(&BMPInfo.biBitCount,sizeof(BYTE),1,Fn);
                }
//Image
    if (BMPInfo.biBitCount==1)//1 colour, 1bit per pixel
                fwrite(BMPimage,((BMPInfo.biWidth/8)*BMPInfo.biHeight),1,Fn);
    else if (BMPInfo.biBitCount==4)//16 colour, 4bits per pixel
                fwrite(BMPimage,((BMPInfo.biWidth/2)*BMPInfo.biHeight),1,Fn);
    else fwrite(BMPimage,(BMPInfo.biWidth*BMPInfo.biHeight),1,Fn);
    fclose(Fn);
return 0; }

/*************************************************************************
** Unpack's the bitmap to mem format
*************************************************************************/
BYTE *unpack_2_mem(BYTE *memptr,BYTE scr_head){
  unsigned int rx, x, y, maxx, maxy,cntr;
  unsigned char Color;
  unsigned long ptr;
  int pluspal=0;

 if(BMPimage==NULL)return memptr;
 if(memptr!=NULL){free(memptr);bmp_malfree--; }
 if(scr_head==1)pluspal=768;
 memptr = (BYTE *)malloc((BMPInfo.biWidth*BMPInfo.biHeight)+6+pluspal);
 if(memptr==NULL)return memptr;
 bmp_malfree++;

//image (remember these stored bottom up!!!! so need to invert)
        ptr=4;//(BMPInfo.biWidth*BMPInfo.biHeight)+4;
        if(scr_head==1)ptr=5;

        maxx = BMPInfo.biWidth;
        maxy = BMPInfo.biHeight;
        y = maxy-1;
        do{
          for (rx=x=0; x < maxx; x++,rx++){
                         if (BMPInfo.biBitCount==1){//monochrome, 1bit per pixel
                                for(cntr=0;cntr<8;cntr++){
                                        Color=bin_in(BMPimage[rx+(y*(BMPInfo.biWidth/8))],cntr);//get byte
                                        memptr[ptr+x]=Color;
                                        if(cntr<7)x++;
                                                  }
                                   }
                         else if (BMPInfo.biBitCount==4){//16 colour, 4bits per pixel
                                Color=BMPimage[rx+(y*(BMPInfo.biWidth/2))];
                                memptr[ptr+(x++)]=(unsigned char)(Color>>4);
                                memptr[x+ptr]=(unsigned char)(Color&0xf);
                        			}
                         else{//8bits per pixel 256colour
                          Color=BMPimage[rx+(y*BMPInfo.biWidth)];
                          memptr[ptr+x]=Color;
                          }
                }
          ptr+=maxx; if(ptr>(BMPInfo.biWidth*BMPInfo.biHeight)+4)break;
         } while (y-- > 0);
      //header 
        memptr[0+scr_head]=LOWBYTE(BMPInfo.biWidth);
        memptr[1+scr_head]=HIGHBYTE(BMPInfo.biWidth);

        memptr[2+scr_head]=LOWBYTE(BMPInfo.biHeight);
        memptr[3+scr_head]=HIGHBYTE(BMPInfo.biHeight);
        if(scr_head==1){ memptr[0]=SCREEN_IDNUM;
                        ptr=5+(BMPInfo.biWidth*BMPInfo.biHeight);
                        for(x=0;x<768;x++)memptr[x+ptr]=cur_pal[x];
                                }
        else for(x=0;x<768;x++)our_pal[x]=cur_pal[x];
//printf("\n>>>x: %d,%d  y: %d,%d \n", memptr[0], memptr[1], memptr[2],memptr[3]);
return memptr; }

/*************************************************************************
** Repack's the mem to bitmap format
** Assumes the BMPinfo header is correct for the memptr
** and st_ptr holds the start of the actual image
*************************************************************************/
int repack_2_mem(BYTE *memptr, unsigned st_ptr,BYTE restorepal){
  unsigned int rx, x, y,oy,maxx, maxy,cntr;
  unsigned char Color;
  unsigned long image_size;
 // unsigned long ptr;
 
 if(memptr==NULL)return 1;
 if(BMPimage!=NULL){free(BMPimage);bmp_malfree--;}

 if(BMPInfo.biBitCount==1)image_size=(BMPInfo.biWidth/8)*BMPInfo.biHeight;//mono
 else if (BMPInfo.biBitCount==4)image_size=(BMPInfo.biWidth/2)*BMPInfo.biHeight;//16 col
 else image_size=BMPInfo.biWidth*BMPInfo.biHeight;
 BMPimage = (BYTE *)malloc(image_size+5);
 if(BMPimage==NULL)return -1;
 bmp_malfree++;

 //image (remember these need to be stored bottom up!!!! so need to invert)

  maxx = BMPInfo.biWidth;
  maxy = BMPInfo.biHeight;


  for(oy=0,y=maxy-1; oy<maxy; oy++,y--)
     for (rx=x=0; rx < maxx; x++,rx++){
                   if (BMPInfo.biBitCount==1){//monochrome, 1bit per pixel
                                g_bin_num=0;
                                for(cntr=0;cntr<8;cntr++)
                                        setbin(memptr[st_ptr+rx+cntr+(y*maxx)],cntr);
                                if(image_size>x+(oy*(maxx/8)))
                                    BMPimage[x+(oy*(maxx/8))]=g_bin_num;
                                rx+=7;//it gets added another elsewhere
                                   }
                     else if (BMPInfo.biBitCount==4){//16 colour, 4bits per pixel
                                Color=memptr[st_ptr+rx+(y*maxx)] << 4;
                                rx++;
                                Color+=memptr[st_ptr+rx+(y*maxx)];
                                if(image_size>x+(oy*(maxx/2)))
                                          BMPimage[x+(oy*(maxx/2))]=Color;
                                                }
                     else{//8bits per pixel 256colour
                                  Color=memptr[st_ptr+rx+(y*maxx)];
                                  BMPimage[x+(oy*maxx)]=Color;
                                  }
         }
 if(restorepal==1){
           cntr=st_ptr+(BMPInfo.biWidth*BMPInfo.biHeight);
           for(x=0; x<768;x++) cur_pal[x]=memptr[x+cntr];
                }
 else  for(x=0; x<768;x++) cur_pal[x]=our_pal[x];
return 0; }


