// Affine Texture Mapper, for 256 color linear
// memory 64x64 pixel texture mapping of 3 vertex polys.

/*
#include <conio.h>
#include <stdlib.h>
#include <malloc.h>
#include <memory.h>
#include <string.h>
#include <stdarg.h>
#include <stdio.h> 
#include <math.h>
#include "d:\ssprogs\artie\defines.h"
#include "d:\ssprogs\artie\xlib.h"

#define SCREEN_WIDTH 320
#define SCREEN_HEIGHT 200

unsigned char ScreenPtr[320*200];
unsigned char img_ptr[64*64];
unsigned char pal_ptr[768];
int LoadBin(char *fname,int wh,int siz){
 FILE *hnd;
 unsigned char *ptr;
 int a;
 if(wh==0)ptr=img_ptr; else ptr=pal_ptr;
 hnd=fopen(fname,"rb"); if(hnd==NULL)return -1;
 for(a=0;a<siz;a++) ptr[a]=fgetc(hnd); 
 fclose(hnd);
return 0; }*/



#define FIXP16_SHIFT     16
#define FIXP16_MAG       65536
#define FIXP16_DP_MASK   0x0000ffff
#define FIXP16_WP_MASK   0xffff0000
#define FIXP16_ROUND_UP  0x00008000

#define TRI_TYPE_NONE           0
#define TRI_TYPE_FLAT_TOP       1 
#define TRI_TYPE_FLAT_BOTTOM	2
#define TRI_TYPE_FLAT_MASK      3
#define TRI_TYPE_GENERAL        4
#define INTERP_LHS              0
#define INTERP_RHS              1
#define MAX_VERTICES_PER_POLY   6

#define SIGN(x) ((x) > 0 ? (1) : (-1))
#define SWAP(a,b,temp) {temp = a; a=b; b=temp;}

// basic types
//typedef unsigned short USHORT;
//typedef unsigned short WORD;
//typedef unsigned char  UCHAR;
//typedef unsigned char  BYTE;

/*typedef struct VERTEX3D{
        float x,y,z;
        float u,v,i;
                }VERTEX3D;*/

typedef struct  VERTEXI3D{
        int x,y,z;
        int u,v,i;
                } VERTEXI3D;

typedef struct FACE3D{
        unsigned char    *texture;   // pointer to the texture information
        struct VERTEXI3D tlist[3];                      // triangle vertex list int int form
}FACE3D;

// the viewport to clip to, can be smaller than the screen
int poly_clip_min_x, poly_clip_max_x, poly_clip_min_y,poly_clip_max_y;


// this function draws a textured triangle
void Draw_Textured_Triangle(int msk_col,void *vface,          // ptr to face
//                            unsigned char *dest_buffer,   // pointer to video buffer
                            int mem_pitch,unsigned char *scr){       // bytes per line, 320, 640 etc.
 FACE3D * face; // working face
 int v0=0,v1=1, v2=2, temp=0, tri_type = TRI_TYPE_NONE,  irestart = INTERP_LHS;
 int dx,dy,dyl,dyr,      // general deltas
     du,dv,
     xi,yi,              // the current interpolated x,y
     ui,vi,              // the current interpolated u,v
     xstart,xend,ystart,yrestart,yend,xl,
     dxdyl,xr,dxdyr,dudyl,ul,dvdyl,vl,dudyr,
     ur,dvdyr,vr;

 int x0,y0,tu0,tv0,    // cached vertices
     x1,y1,tu1,tv1,
     x2,y2,tu2,tv2;

 unsigned char wot;

 unsigned char *screen_ptr  = NULL,
               *textmap     = NULL;

 unsigned char *dest_buffer=scr;

/* if(cur_screen==0) dest_buffer=vdu_scr+4;
 else{ dest_buffer=mem_bank[cur_screen-1]+5;
       if(dest_buffer==NULL)return;
       if(dest_buffer[0]!=SCREEN_IDNUM)return;//incase user has change the bank
                }*/
 if(dest_buffer==NULL)return;


 face = (FACE3D *)vface;// convert void ptr to face
 textmap = face->texture;// extract texture map

 // first trivial clipping rejection tests 
 if (((face->tlist[0].y < poly_clip_min_y)  && 
	 (face->tlist[1].y < poly_clip_min_y)  &&
	 (face->tlist[2].y < poly_clip_min_y)) ||

	((face->tlist[0].y > poly_clip_max_y)  && 
	 (face->tlist[1].y > poly_clip_max_y)  &&
	 (face->tlist[2].y > poly_clip_max_y)) ||

	((face->tlist[0].x < poly_clip_min_x)  && 
	 (face->tlist[1].x < poly_clip_min_x)  &&
	 (face->tlist[2].x < poly_clip_min_x)) ||

	((face->tlist[0].x > poly_clip_max_x)  && 
	 (face->tlist[1].x > poly_clip_max_x)  &&
	 (face->tlist[2].x > poly_clip_max_x)))
   return;

   // degenerate triangle
   if ( ((face->tlist[0].x==face->tlist[1].x) && (face->tlist[1].x==face->tlist[2].x)) ||
	 ((face->tlist[0].y==face->tlist[1].y) && (face->tlist[1].y==face->tlist[2].y)))
   return;

        // sort vertices
        if (face->tlist[v1].y < face->tlist[v0].y) SWAP(v0,v1,temp); 

        if (face->tlist[v2].y < face->tlist[v0].y) SWAP(v0,v2,temp);

        if (face->tlist[v2].y < face->tlist[v1].y) SWAP(v1,v2,temp);

        // now test for trivial flat sided cases
        if (face->tlist[v0].y==face->tlist[v1].y){ 
                tri_type = TRI_TYPE_FLAT_TOP; // set triangle type
                // sort vertices left to right
                if (face->tlist[v1].x < face->tlist[v0].x) SWAP(v0,v1,temp);
        }
        else if (face->tlist[v1].y==face->tlist[v2].y){// now test for trivial flat sided cases
                tri_type = TRI_TYPE_FLAT_BOTTOM;  // set triangle type
                // sort vertices left to right
                if (face->tlist[v2].x < face->tlist[v1].x) SWAP(v1,v2,temp);
                }
        else tri_type = TRI_TYPE_GENERAL;// must be a general triangle

        // extract vertices for processing, now that we have order
        x0  = face->tlist[v0].x; y0  = face->tlist[v0].y;
        tu0 = face->tlist[v0].u; tv0 = face->tlist[v0].v;

        x1  = face->tlist[v1].x; y1  = face->tlist[v1].y;
        tu1 = face->tlist[v1].u; tv1 = face->tlist[v1].v;

        x2  = face->tlist[v2].x; y2  = face->tlist[v2].y;
        tu2 = face->tlist[v2].u; tv2 = face->tlist[v2].v;

        // set interpolation restart value
        yrestart = y1;

        // what kind of triangle
        if (tri_type & TRI_TYPE_FLAT_MASK){
            if (tri_type == TRI_TYPE_FLAT_TOP){
                // compute all deltas
                dy = (y2 - y0);
                dxdyl = ((x2 - x0)   << FIXP16_SHIFT)/dy;
                dudyl = ((tu2 - tu0) << FIXP16_SHIFT)/dy;  
                dvdyl = ((tv2 - tv0) << FIXP16_SHIFT)/dy;    

                dxdyr = ((x2 - x1)   << FIXP16_SHIFT)/dy;
                dudyr = ((tu2 - tu1) << FIXP16_SHIFT)/dy;  
                dvdyr = ((tv2 - tv1) << FIXP16_SHIFT)/dy;   

                // test for y clipping
                if (y0 < poly_clip_min_y){// compute overclip
                        dy = (poly_clip_min_y - y0);
                        // computer new LHS starting values
                        xl = dxdyl*dy + (x0  << FIXP16_SHIFT);
                        ul = dudyl*dy + (tu0 << FIXP16_SHIFT);
                        vl = dvdyl*dy + (tv0 << FIXP16_SHIFT);
                        // compute new RHS starting values
                        xr = dxdyr*dy + (x1  << FIXP16_SHIFT);
                        ur = dudyr*dy + (tu1 << FIXP16_SHIFT);
                        vr = dvdyr*dy + (tv1 << FIXP16_SHIFT);
                        // compute new starting y
                        ystart = poly_clip_min_y;
                        }
                else{ // no clipping
                        // set starting values
                        xl = (x0 << FIXP16_SHIFT);
                        xr = (x1 << FIXP16_SHIFT);
                        ul = (tu0 << FIXP16_SHIFT);
                        vl = (tv0 << FIXP16_SHIFT);
                        ur = (tu1 << FIXP16_SHIFT);
                        vr = (tv1 << FIXP16_SHIFT);
                        // set starting y
                        ystart = y0;
                }
           }
        else{ // must be flat bottom
                // compute all deltas
                dy = (y1 - y0);
                dxdyl = ((x1 - x0)   << FIXP16_SHIFT)/dy;
                dudyl = ((tu1 - tu0) << FIXP16_SHIFT)/dy;  
                dvdyl = ((tv1 - tv0) << FIXP16_SHIFT)/dy;    
                dxdyr = ((x2 - x0)   << FIXP16_SHIFT)/dy;
                dudyr = ((tu2 - tu0) << FIXP16_SHIFT)/dy;  
                dvdyr = ((tv2 - tv0) << FIXP16_SHIFT)/dy;   
                // test for y clipping
                if (y0 < poly_clip_min_y) {
                        // compute overclip
                        dy = (poly_clip_min_y - y0);
                        // computer new LHS starting values
                        xl = dxdyl*dy + (x0  << FIXP16_SHIFT);
                        ul = dudyl*dy + (tu0 << FIXP16_SHIFT);
                        vl = dvdyl*dy + (tv0 << FIXP16_SHIFT);
        		// compute new RHS starting values
                        xr = dxdyr*dy + (x0  << FIXP16_SHIFT);
                        ur = dudyr*dy + (tu0 << FIXP16_SHIFT);
                        vr = dvdyr*dy + (tv0 << FIXP16_SHIFT);
                        // compute new starting y
                        ystart = poly_clip_min_y;
                        }
        else {  // no clipping
		// set starting values
		xl = (x0 << FIXP16_SHIFT);
		xr = (x0 << FIXP16_SHIFT);
		ul = (tu0 << FIXP16_SHIFT);
		vl = (tv0 << FIXP16_SHIFT);
		ur = (tu0 << FIXP16_SHIFT);
		vr = (tv0 << FIXP16_SHIFT);
		// set starting y
		ystart = y0;
		} // end else	
        }
	// test for bottom clip, always
        if ((yend = y2) > poly_clip_max_y) yend = poly_clip_max_y;
       // test for horizontal clipping
	if ((x0 < poly_clip_min_x) || (x0 > poly_clip_max_x) ||
		(x1 < poly_clip_min_x) || (x1 > poly_clip_max_x) ||
		(x2 < poly_clip_min_x) || (x2 > poly_clip_max_x))
	{
    // clip version

	// point screen ptr to starting line
	screen_ptr = dest_buffer + (ystart * mem_pitch);

        for (yi = ystart; yi<=yend; yi++){
		// compute span endpoints
		xstart = ((xl + FIXP16_ROUND_UP) >> FIXP16_SHIFT);
		xend   = ((xr + FIXP16_ROUND_UP) >> FIXP16_SHIFT);
		// compute starting points for u,v interpolants
		ui = ul + FIXP16_ROUND_UP;
		vi = vl + FIXP16_ROUND_UP;
                // compute u,v interpolants
                if ((dx = (xend - xstart))>0){
			du = (ur - ul)/dx;
			dv = (vr - vl)/dx;
                        }
                else {  du = (ur - ul);
			dv = (vr - vl);
                        }

		// test for x clipping, LHS
                if (xstart < poly_clip_min_x){
			// compute x overlap
			dx = poly_clip_min_x - xstart;

			// slide interpolants over
			ui+=dx*du;
			vi+=dx*dv;
			
			// reset vars
			xstart = poly_clip_min_x;
			} // end if
		
		// test for x clipping RHS
                if (xend > poly_clip_max_x)xend = poly_clip_max_x;

		// draw span
                for (xi=xstart; xi<=xend; xi++){
			// write textel
                        wot=textmap[(ui >> FIXP16_SHIFT) +
                                                ((vi >> FIXP16_SHIFT) << 6)];
                        if(msk_col!=wot)screen_ptr[xi]=wot;

			// interpolate u,v
			ui+=du;
			vi+=dv;
			} // end for xi
		// interpolate u,v,x along right and left edge
                xl+=dxdyl;  ul+=dudyl;
		vl+=dvdyl;
                xr+=dxdyr; ur+=dudyr;
		vr+=dvdyr;
		// advance screen ptr
		screen_ptr+=mem_pitch;
                }
        }
        else { // non-clip version
	// point screen ptr to starting line
	screen_ptr = dest_buffer + (ystart * mem_pitch);

        for (yi = ystart; yi<=yend; yi++){
		// compute span endpoints
		xstart = ((xl + FIXP16_ROUND_UP) >> FIXP16_SHIFT);
		xend   = ((xr + FIXP16_ROUND_UP) >> FIXP16_SHIFT);
		
		// compute starting points for u,v interpolants
		ui = ul + FIXP16_ROUND_UP;
		vi = vl + FIXP16_ROUND_UP;
	
		// compute u,v interpolants
                if ((dx = (xend - xstart))>0){
			du = (ur - ul)/dx;
			dv = (vr - vl)/dx;
			} // end if
                else{
			du = (ur - ul);
			dv = (vr - vl);
			} // end else
		// draw span
                for (xi=xstart; xi<=xend; xi++){
			// write textel
                        wot = textmap[(ui >> FIXP16_SHIFT) +
                                ((vi >> FIXP16_SHIFT) << 6)];
                        if(msk_col!=wot)screen_ptr[xi]=wot;
			// interpolate u,v
			ui+=du;
			vi+=dv;
			} // end for xi

		// interpolate u,v,x along right and left edge
                xl+=dxdyl; ul+=dudyl;
		vl+=dvdyl;
                xr+=dxdyr; ur+=dudyr;
		vr+=dvdyr;
		// advance screen ptr
		screen_ptr+=mem_pitch;
                }
        } 
    }
    else if (tri_type==TRI_TYPE_GENERAL){
	// first test for bottom clip, always
        if ((yend = y2) > poly_clip_max_y) yend = poly_clip_max_y;

	// pre-test y clipping status
        if (y1 < poly_clip_min_y){
		// compute all deltas
		// LHS
		dyl = (y2 - y1);
		dxdyl = ((x2  - x1)  << FIXP16_SHIFT)/dyl;
		dudyl = ((tu2 - tu1) << FIXP16_SHIFT)/dyl;  
		dvdyl = ((tv2 - tv1) << FIXP16_SHIFT)/dyl;    
		// RHS
                dyr = (y2 - y0);
		dxdyr = ((x2  - x0)  << FIXP16_SHIFT)/dyr;
		dudyr = ((tu2 - tu0) << FIXP16_SHIFT)/dyr;  
		dvdyr = ((tv2 - tv0) << FIXP16_SHIFT)/dyr;   
                // compute overclip
		dyr = (poly_clip_min_y - y0);
		dyl = (poly_clip_min_y - y1);
		// computer new LHS starting values
		xl = dxdyl*dyl + (x1  << FIXP16_SHIFT);
		ul = dudyl*dyl + (tu1 << FIXP16_SHIFT);
		vl = dvdyl*dyl + (tv1 << FIXP16_SHIFT);
		// compute new RHS starting values
		xr = dxdyr*dyr + (x0  << FIXP16_SHIFT);
		ur = dudyr*dyr + (tu0 << FIXP16_SHIFT);
		vr = dvdyr*dyr + (tv0 << FIXP16_SHIFT);
		// compute new starting y
		ystart = poly_clip_min_y;
		// test if we need swap to keep rendering left to right
                if (dxdyr > dxdyl){
			SWAP(dxdyl,dxdyr,temp);
			SWAP(dudyl,dudyr,temp);
			SWAP(dvdyl,dvdyr,temp);
			SWAP(xl,xr,temp);
			SWAP(ul,ur,temp);
			SWAP(vl,vr,temp);
			SWAP(x1,x2,temp);
			SWAP(y1,y2,temp);
			SWAP(tu1,tu2,temp);
			SWAP(tv1,tv2,temp);
                        // set interpolation restart
			irestart = INTERP_RHS;
			} // end if
		} // end if
        else if (y0 < poly_clip_min_y){
		// compute all deltas
		// LHS
		dyl = (y1 - y0);
		dxdyl = ((x1  - x0)  << FIXP16_SHIFT)/dyl;
		dudyl = ((tu1 - tu0) << FIXP16_SHIFT)/dyl;  
		dvdyl = ((tv1 - tv0) << FIXP16_SHIFT)/dyl;    
		// RHS
		dyr = (y2 - y0);	
		dxdyr = ((x2  - x0)  << FIXP16_SHIFT)/dyr;
		dudyr = ((tu2 - tu0) << FIXP16_SHIFT)/dyr;  
		dvdyr = ((tv2 - tv0) << FIXP16_SHIFT)/dyr;   
		// compute overclip
		dy = (poly_clip_min_y - y0);
		// computer new LHS starting values
		xl = dxdyl*dy + (x0  << FIXP16_SHIFT);
		ul = dudyl*dy + (tu0 << FIXP16_SHIFT);
		vl = dvdyl*dy + (tv0 << FIXP16_SHIFT);
		// compute new RHS starting values
		xr = dxdyr*dy + (x0  << FIXP16_SHIFT);
		ur = dudyr*dy + (tu0 << FIXP16_SHIFT);
		vr = dvdyr*dy + (tv0 << FIXP16_SHIFT);
		// compute new starting y
		ystart = poly_clip_min_y;
		// test if we need swap to keep rendering left to right
                if (dxdyr < dxdyl){
			SWAP(dxdyl,dxdyr,temp);
			SWAP(dudyl,dudyr,temp);
			SWAP(dvdyl,dvdyr,temp);
			SWAP(xl,xr,temp);
			SWAP(ul,ur,temp);
			SWAP(vl,vr,temp);
			SWAP(x1,x2,temp);
			SWAP(y1,y2,temp);
			SWAP(tu1,tu2,temp);
			SWAP(tv1,tv2,temp);
                        // set interpolation restart
			irestart = INTERP_RHS;
			} // end if
		} // end if
        else {
		// no initial y clipping
		// compute all deltas
		// LHS
		dyl = (y1 - y0);
		dxdyl = ((x1  - x0)  << FIXP16_SHIFT)/dyl;
		dudyl = ((tu1 - tu0) << FIXP16_SHIFT)/dyl;  
		dvdyl = ((tv1 - tv0) << FIXP16_SHIFT)/dyl;    
		// RHS
		dyr = (y2 - y0);	
		dxdyr = ((x2 - x0)   << FIXP16_SHIFT)/dyr;
		dudyr = ((tu2 - tu0) << FIXP16_SHIFT)/dyr;  
		dvdyr = ((tv2 - tv0) << FIXP16_SHIFT)/dyr;   		
		// no clipping y
		// set starting values
		xl = (x0 << FIXP16_SHIFT);
		xr = (x0 << FIXP16_SHIFT);
		ul = (tu0 << FIXP16_SHIFT);
		vl = (tv0 << FIXP16_SHIFT);
		ur = (tu0 << FIXP16_SHIFT);
		vr = (tv0 << FIXP16_SHIFT);
		// set starting y
		ystart = y0;
		// test if we need swap to keep rendering left to right
                if (dxdyr < dxdyl){
			SWAP(dxdyl,dxdyr,temp);
			SWAP(dudyl,dudyr,temp);
			SWAP(dvdyl,dvdyr,temp);
			SWAP(xl,xr,temp);
			SWAP(ul,ur,temp);
			SWAP(vl,vr,temp);
			SWAP(x1,x2,temp);
			SWAP(y1,y2,temp);
			SWAP(tu1,tu2,temp);
			SWAP(tv1,tv2,temp);
			// set interpolation restart
			irestart = INTERP_RHS;
			} // end if
		} // end else
    // test for horizontal clipping
	if ((x0 < poly_clip_min_x) || (x0 > poly_clip_max_x) ||
		(x1 < poly_clip_min_x) || (x1 > poly_clip_max_x) ||
		(x2 < poly_clip_min_x) || (x2 > poly_clip_max_x))
                {    // clip version
        // x clipping 
	// point screen ptr to starting line
	screen_ptr = dest_buffer + (ystart * mem_pitch);
        for (yi = ystart; yi<=yend; yi++){
		// compute span endpoints
		xstart = ((xl + FIXP16_ROUND_UP) >> FIXP16_SHIFT);
		xend   = ((xr + FIXP16_ROUND_UP) >> FIXP16_SHIFT);
		// compute starting points for u,v interpolants
		ui = ul + FIXP16_ROUND_UP;
		vi = vl + FIXP16_ROUND_UP;
		// compute u,v interpolants
                if ((dx = (xend - xstart))>0){
			du = (ur - ul)/dx;
			dv = (vr - vl)/dx;
			} // end if
                else {
			du = (ur - ul);
			dv = (vr - vl);
			} // end else
		// test for x clipping, LHS
                if (xstart < poly_clip_min_x){
			// compute x overlap
			dx = poly_clip_min_x - xstart;
			// slide interpolants over
			ui+=dx*du;
			vi+=dx*dv;
			// set x to left clip edge
			xstart = poly_clip_min_x;
			} // end if
		// test for x clipping RHS
                if (xend > poly_clip_max_x)xend = poly_clip_max_x;
		// draw span
                for (xi=xstart; xi<=xend; xi++){
			// write textel
                    wot = textmap[(ui >> FIXP16_SHIFT) + ((vi >> FIXP16_SHIFT) << 6)];
                    if(msk_col!=wot)screen_ptr[xi]=wot;
			// interpolate u,v
			ui+=du;
			vi+=dv;
			} // end for xi
		// interpolate u,v,x along right and left edge
                xl+=dxdyl; ul+=dudyl;
		vl+=dvdyl;
                xr+=dxdyr; ur+=dudyr;
		vr+=dvdyr;
		// advance screen ptr
		screen_ptr+=mem_pitch;
		// test for yi hitting second region, if so change interpolant
                if (yi==yrestart){
		// test interpolation side change flag
                        if (irestart == INTERP_LHS){
			// LHS
			dyl = (y2 - y1);	
			dxdyl = ((x2 - x1)   << FIXP16_SHIFT)/dyl;
			dudyl = ((tu2 - tu1) << FIXP16_SHIFT)/dyl;  
			dvdyl = ((tv2 - tv1) << FIXP16_SHIFT)/dyl;   		
			// set starting values
			xl = (x1  << FIXP16_SHIFT);
			ul = (tu1 << FIXP16_SHIFT);
			vl = (tv1 << FIXP16_SHIFT);
			// interpolate down on LHS to even up
			xl+=dxdyl;
			ul+=dudyl;
			vl+=dvdyl;
			} // end if
                     else{
			// RHS
			dyr = (y1 - y2);	
			dxdyr = ((x1 - x2)   << FIXP16_SHIFT)/dyr;
			dudyr = ((tu1 - tu2) << FIXP16_SHIFT)/dyr;  
			dvdyr = ((tv1 - tv2) << FIXP16_SHIFT)/dyr;   		
			// set starting values
			xr = (x2  << FIXP16_SHIFT);
			ur = (tu2 << FIXP16_SHIFT);
			vr = (tv2 << FIXP16_SHIFT);
			// interpolate down on RHS to even up
			xr+=dxdyr;
			ur+=dudyr;
			vr+=dvdyr;
                        } // end else
                 } // end if
             } // end for y
	} // end if
        else {
         // no x clipping
         // point screen ptr to starting line
         screen_ptr = dest_buffer + (ystart * mem_pitch);
         for (yi = ystart; yi<=yend; yi++){
		// compute span endpoints
		xstart = ((xl + FIXP16_ROUND_UP) >> FIXP16_SHIFT);
		xend   = ((xr + FIXP16_ROUND_UP) >> FIXP16_SHIFT);
		// compute starting points for u,v interpolants
		ui = ul + FIXP16_ROUND_UP;
		vi = vl + FIXP16_ROUND_UP;
		// compute u,v interpolants
                if ((dx = (xend - xstart))>0){
			du = (ur - ul)/dx;
			dv = (vr - vl)/dx;
			} // end if
                else {
			du = (ur - ul);
			dv = (vr - vl);
			} // end else
		// draw span
                for (xi=xstart; xi<=xend; xi++){
			// write textel
                    wot = textmap[(ui >> FIXP16_SHIFT) + ((vi >> FIXP16_SHIFT) << 6)];
                    if(msk_col!=wot)screen_ptr[xi]=wot;
			// interpolate u,v
			ui+=du;
			vi+=dv;
			} // end for xi
		// interpolate u,v,x along right and left edge
                xl+=dxdyl; ul+=dudyl;
		vl+=dvdyl;
                xr+=dxdyr; ur+=dudyr;
		vr+=dvdyr;
		// advance screen ptr
		screen_ptr+=mem_pitch;
		// test for yi hitting second region, if so change interpolant
                if (yi==yrestart){
			// test interpolation side change flag
                        if (irestart == INTERP_LHS){
			// LHS
                        dyl = (y2 - y1); 
			dxdyl = ((x2 - x1)   << FIXP16_SHIFT)/dyl;
			dudyl = ((tu2 - tu1) << FIXP16_SHIFT)/dyl;  
			dvdyl = ((tv2 - tv1) << FIXP16_SHIFT)/dyl;   		
			// set starting values
			xl = (x1  << FIXP16_SHIFT);
			ul = (tu1 << FIXP16_SHIFT);
			vl = (tv1 << FIXP16_SHIFT);
			// interpolate down on LHS to even up
			xl+=dxdyl;
			ul+=dudyl;
			vl+=dvdyl;
			} // end if
                   else {
			// RHS
			dyr = (y1 - y2);	
			dxdyr = ((x1 - x2)   << FIXP16_SHIFT)/dyr;
			dudyr = ((tu1 - tu2) << FIXP16_SHIFT)/dyr;  
			dvdyr = ((tv1 - tv2) << FIXP16_SHIFT)/dyr;   		
			// set starting values
			xr = (x2  << FIXP16_SHIFT);
			ur = (tu2 << FIXP16_SHIFT);
			vr = (tv2 << FIXP16_SHIFT);
			// interpolate down on RHS to even up
			xr+=dxdyr;
			ur+=dudyr;
			vr+=dvdyr;
			} // end else
                  } // end if
             } // end for y
	} // end else	
      } // end if
} // end Draw_Textured_Triangle


/*void main(){
  int x,y;
  FACE3D face; // the triangle object

    if(LoadBin("image.bin",0,64*64)) exit (-1);
    if(LoadBin("image.pal",1,768))exit (-1);


 if(x_set_mode(X_320X200)==FALSE){
                  printf("Could not initilise graphics mode.\n"); exit(-1);
                          }

 x_set_palette(pal_ptr);
 memset(ScreenPtr,0,320*200);

  poly_clip_min_x = 0;
  poly_clip_max_x = SCREEN_WIDTH-1;
  poly_clip_min_y = 0;
  poly_clip_max_y = SCREEN_HEIGHT-1;




        face.tlist[0].x = rand()%SCREEN_WIDTH;
        face.tlist[0].y = rand()%SCREEN_HEIGHT;
        face.tlist[0].u = 0;
        face.tlist[0].v = 0;

        face.tlist[1].x = rand()%SCREEN_WIDTH;
        face.tlist[1].y = rand()%SCREEN_HEIGHT;
        face.tlist[1].u = 0;
        face.tlist[1].v = 63;

        face.tlist[2].x = rand()%SCREEN_WIDTH;
        face.tlist[2].y = rand()%SCREEN_HEIGHT;
        face.tlist[2].u = 63;
        face.tlist[2].v = 63;


         face.texture = img_ptr;
         Draw_Textured_Triangle((void *)&face, ScreenPtr, SCREEN_WIDTH);

 for(y=1;y<200;y++)
   for(x=0;x<320;x++)
     x_put_pixel(x,y,Page0_Offs,ScreenPtr[x+(y*320)]);


 getch();

//        face.tlist[0].u = 63;
        face.tlist[0].v = 10;

         face.texture = img_ptr;
         Draw_Textured_Triangle((void *)&face, ScreenPtr, SCREEN_WIDTH);

 for(y=1;y<200;y++)
   for(x=0;x<320;x++)
     x_put_pixel(x,y,Page0_Offs,ScreenPtr[x+(y*320)]);



  getch();
  x_set_text_mode();
return; }
*/


#include "obj_3d.h"

