#define DEG360		2048		// equals to 360 degrees
#define DEG360_2	11		// DEG360 log2
#define DEG180		1024		// 180 degrees
#define DEG90		512		// 90 degrees

typedef unsigned char   BYTE;
typedef unsigned short  WORD;
typedef unsigned long   DWORD;
typedef long int        LONG;
typedef short int       SHORT;
typedef long int        FIXED;


#include "d:\ssprogs\artie\defines.h"
#include "d:\ssprogs\artie\xlib.h"

#define ER_GENERAL	-1			// Just an error
#define ER_MEMORY	-2			// Not enough memory
#define ER_CACHE0	-3			// Zero cache alloc
#define ER_FOPEN	-4			// Can't open file
#define ER_FORMAT	-5			// Bad format
#define ER_FIND		-6			// Couldn't find something
#define ER_RES		-7			// Out of resources
#define ER_WRONGANIM    -8          //wrong anim type


#define COL_WALL 0
#define COL_OBJECT 1

#define MAX_SHADES   32
#define MAX_TABLES   32              // Max number of tables

#define MAX_OBJECTS 100
#define MAX_ANIMSEQ 20
#define MAX_ANIM_FRAMES 10

#define _ANIM 0
#define _MOVEWALL 1
#define _FLOOR 2
#define _OBJECTTURN 3
#define _OBJECTMOVE 4
#define _OBJECTANIM 5
#define _OBJECTSEEK 6
#define _OBJECTWATCHER 7

#define _A_ONCE 0
#define _A_RETURN 1
#define _A_LOOP 2
#define _A_REPEAT 3


extern char had_fatal_error;
extern int fatal_type;
extern char fatal_error_str[100];


void Td_move_forward(int objectnum,int stepsize);
int Td_getheight(int objectnum);
void Td_setheight(int objectnum,int h);
void Td_turn(int objectnum,int stepsize);
void Td_sidestep(int objectnum,int stepsize);
void Td_setfall(int objectnum,char canfall);
void Td_moveup(int objectnum,int stepsize);
void Td_setviewdir(int x,int y);
int Td_getviewdirx();
int Td_getviewdiry();
void Td_setscreensize(int x,int y,int x2,int y2);
int Td_do_we_see(int wh);
int Td_object_seen(int o1,int o2,int fv,int dist);
void Td_loadmap(char *fname);
int Td_setshade(int shade);
int Td_getlight();
void Td_setlight(int light);
void Td_clear_collision(int objectnum,char wh);
int Td_test_coll(int objectnum,char wh);
int Td_get_coll(int objectnum,char wh);
void Td_setgravity(int grav);
int Td_getfloorheight(int objectnum);
int Td_getceilheight(int objectnum);
int Td_getareatype(int objectnum);//(For light,Gravity etc?)
char *Td_getfloortex(int objectnum);
char *Td_getceiltex(int objectnum);
int Td_getobjectx(int objectnum);
int Td_getobjecty(int objectnum);
int Td_getobjecth(int objectnum);
int Td_getobjectangle(int objectnum);
void td_remove_auto_feature(int wallno,int type);
void Td_erase_textures();
void Td_settexture(int wallno,int whbit,char *picname);//  whbit= 0 top,1=mid 2=bot 3=floor,4=ceil
void Td_setwall(int wallno,int x,int y,int x2,int y2,int tx,int ty);
int Td_getwallx1(int wallno);
int Td_getwally1(int wallno);
int Td_getwallx2(int wallno);
int Td_getwally2(int wallno);
char *Td_gettexture(int wallno,int whbit);
int Td_getdist(int wh,int wh2);
void Td_setstairheight(int wh);
void Td_makepalette(int howmany,int shades);
int Td_maketable(int wh,int r,int g,int b);//,int bk);
int Td_setbackfade(int wh,int bk);
void Td_savepalette(char *fname);

int add_auto_feature(int wall,int type,int step,int first,int howfar,int lop,int whbit,int wdelay);
int make_anim(int a,int type);
int addto_anim_seq(int a,int p,int e);

void FatalError(int type,char *str);
int make_mem();
void  WTD_Init(void);
void  WTD_Config(int,int);
void load_texture(char *fname, char *actname);
//void LoadPalette(char *filename);
void LoadPalette(long,unsigned char *,unsigned char *);

void td_object(int wh,int x,int y,int h,int angle,int objectaction,char *objectname,int obj3d);
void td_update();
void release_mem();

extern int td_memcntr;

void td_set_object(int wh,int height,int radius,char *typestr);

int Td_getmaxtable();
int td_getmaxwall();
int td_getanimtype(int animnum);

int find_pic(char *str);
int find_tex(char *str);

void td_object_off(int wh);

void Td_setfloorheight(int areanum,int height,int wh);
void Td_setceilheight(int areanum,int height,int wh);
int Td_getmaxregn();

void td_close_debug();

int td_get_pal_length();
void td_memcpy_palette(unsigned char *dest,unsigned char *ourpal);//dest must already be alloced

int Td_getarea(int objectnum);

int td_has_auto_feature(int wallno,int type);

int td_get_point(int wh,int w);


