[BITS 32]

[GLOBAL _DrawFSpan]

[SECTION .text]
%include "wtd.inc"
FLOOP_LEN    equ 32
FLOOP_SIZE   equ 19

;****************************************************************************
; Draws a horizontal floor span
;				EAX (EBP+8)
;	void DrawFSpan(struct HLine *pHLine)
;****************************************************************************
_DrawFSpan:
        push ebp			; preserve caller's stack frame
        mov ebp,esp			; point to our stack frame
	pushad				; put all registers to stack

	mov ebx, [ebp+8]		; pointer to HLine structure

	movzx eax, word [ebx+Count]	; EAX=pixels_to_draw
	mov [LoopCount], eax		; LoopCount=EAX
	and eax, FLOOP_LEN-1		; EAX=pixels_to_draw%LOOP_LEN
	mov esi, FLoopOffset		; Address of the offset table
	mov eax, [esi+eax*4]		; EAX=relative offset of the cell
	add eax, .FLoopStart		; EAX=absolute address of start cell
	push eax

	mov cl, [ebx+Width2]		; get log 2 of tex width
	movzx eax, word [ebx+LeftCol] ; put cur col to eax
	mov ebp, [ebx+Delta]		; get delta's
	mul ebp				; make cur coords
	mov edx, [ebx+Coord]		; get start coords
	add edx, eax;			; edx contains full coords
	mov esi, [ebx+RawPtr]		; Tex pointer
	mov edi, [ebx+PixPtr]		; Buffer pointer
	mov ebx, [ebx+PalPtr]		; Pal buffer pointer

	ret				; Jump to the start loop cell

.FLoopStart:				; Start of unrolled loop
	xor eax, eax
	shld eax, edx, cl
	shld ax, dx, cl
	mov bl, [esi+eax]
	mov bl, [ebx]
	mov [edi], bl
	inc edi
	add edx, ebp
        
	xor eax, eax
	shld eax, edx, cl
	shld ax, dx, cl
	mov bl, [esi+eax]
	mov bl, [ebx]
	mov [edi], bl
	inc edi
	add edx, ebp
        
	xor eax, eax
	shld eax, edx, cl
	shld ax, dx, cl
	mov bl, [esi+eax]
	mov bl, [ebx]
	mov [edi], bl
	inc edi
	add edx, ebp
        
	xor eax, eax
	shld eax, edx, cl
	shld ax, dx, cl
	mov bl, [esi+eax]
	mov bl, [ebx]
	mov [edi], bl
	inc edi
	add edx, ebp
        
	xor eax, eax
	shld eax, edx, cl
	shld ax, dx, cl
	mov bl, [esi+eax]
	mov bl, [ebx]
	mov [edi], bl
	inc edi
	add edx, ebp
        
	xor eax, eax
	shld eax, edx, cl
	shld ax, dx, cl
	mov bl, [esi+eax]
	mov bl, [ebx]
	mov [edi], bl
	inc edi
	add edx, ebp
        
	xor eax, eax
	shld eax, edx, cl
	shld ax, dx, cl
	mov bl, [esi+eax]
	mov bl, [ebx]
	mov [edi], bl
	inc edi
	add edx, ebp
        
	xor eax, eax
	shld eax, edx, cl
	shld ax, dx, cl
	mov bl, [esi+eax]
	mov bl, [ebx]
	mov [edi], bl
	inc edi
	add edx, ebp
        
	xor eax, eax
	shld eax, edx, cl
	shld ax, dx, cl
	mov bl, [esi+eax]
	mov bl, [ebx]
	mov [edi], bl
	inc edi
	add edx, ebp
        
	xor eax, eax
	shld eax, edx, cl
	shld ax, dx, cl
	mov bl, [esi+eax]
	mov bl, [ebx]
	mov [edi], bl
	inc edi
	add edx, ebp
        
	xor eax, eax
	shld eax, edx, cl
	shld ax, dx, cl
	mov bl, [esi+eax]
	mov bl, [ebx]
	mov [edi], bl
	inc edi
	add edx, ebp
        
	xor eax, eax
	shld eax, edx, cl
	shld ax, dx, cl
	mov bl, [esi+eax]
	mov bl, [ebx]
	mov [edi], bl
	inc edi
	add edx, ebp
        
	xor eax, eax
	shld eax, edx, cl
	shld ax, dx, cl
	mov bl, [esi+eax]
	mov bl, [ebx]
	mov [edi], bl
	inc edi
	add edx, ebp
        
	xor eax, eax
	shld eax, edx, cl
	shld ax, dx, cl
	mov bl, [esi+eax]
	mov bl, [ebx]
	mov [edi], bl
	inc edi
	add edx, ebp
        
	xor eax, eax
	shld eax, edx, cl
	shld ax, dx, cl
	mov bl, [esi+eax]
	mov bl, [ebx]
	mov [edi], bl
	inc edi
	add edx, ebp
        
	xor eax, eax
	shld eax, edx, cl
	shld ax, dx, cl
	mov bl, [esi+eax]
	mov bl, [ebx]
	mov [edi], bl
	inc edi
	add edx, ebp
        
	xor eax, eax
	shld eax, edx, cl
	shld ax, dx, cl
	mov bl, [esi+eax]
	mov bl, [ebx]
	mov [edi], bl
	inc edi
	add edx, ebp
        
	xor eax, eax
	shld eax, edx, cl
	shld ax, dx, cl
	mov bl, [esi+eax]
	mov bl, [ebx]
	mov [edi], bl
	inc edi
	add edx, ebp
        
	xor eax, eax
	shld eax, edx, cl
	shld ax, dx, cl
	mov bl, [esi+eax]
	mov bl, [ebx]
	mov [edi], bl
	inc edi
	add edx, ebp
        
	xor eax, eax
	shld eax, edx, cl
	shld ax, dx, cl
	mov bl, [esi+eax]
	mov bl, [ebx]
	mov [edi], bl
	inc edi
	add edx, ebp
        
	xor eax, eax
	shld eax, edx, cl
	shld ax, dx, cl
	mov bl, [esi+eax]
	mov bl, [ebx]
	mov [edi], bl
	inc edi
	add edx, ebp
        
	xor eax, eax
	shld eax, edx, cl
	shld ax, dx, cl
	mov bl, [esi+eax]
	mov bl, [ebx]
	mov [edi], bl
	inc edi
	add edx, ebp
        
	xor eax, eax
	shld eax, edx, cl
	shld ax, dx, cl
	mov bl, [esi+eax]
	mov bl, [ebx]
	mov [edi], bl
	inc edi
	add edx, ebp
        
	xor eax, eax
	shld eax, edx, cl
	shld ax, dx, cl
	mov bl, [esi+eax]
	mov bl, [ebx]
	mov [edi], bl
	inc edi
	add edx, ebp
        
	xor eax, eax
	shld eax, edx, cl
	shld ax, dx, cl
	mov bl, [esi+eax]
	mov bl, [ebx]
	mov [edi], bl
	inc edi
	add edx, ebp
        
	xor eax, eax
	shld eax, edx, cl
	shld ax, dx, cl
	mov bl, [esi+eax]
	mov bl, [ebx]
	mov [edi], bl
	inc edi
	add edx, ebp
        
	xor eax, eax
	shld eax, edx, cl
	shld ax, dx, cl
	mov bl, [esi+eax]
	mov bl, [ebx]
	mov [edi], bl
	inc edi
	add edx, ebp
        
	xor eax, eax
	shld eax, edx, cl
	shld ax, dx, cl
	mov bl, [esi+eax]
	mov bl, [ebx]
	mov [edi], bl
	inc edi
	add edx, ebp
        
	xor eax, eax
	shld eax, edx, cl
	shld ax, dx, cl
	mov bl, [esi+eax]
	mov bl, [ebx]
	mov [edi], bl
	inc edi
	add edx, ebp
        
	xor eax, eax
	shld eax, edx, cl
	shld ax, dx, cl
	mov bl, [esi+eax]
	mov bl, [ebx]
	mov [edi], bl
	inc edi
	add edx, ebp
        
	xor eax, eax
	shld eax, edx, cl
	shld ax, dx, cl
	mov bl, [esi+eax]
	mov bl, [ebx]
	mov [edi], bl
	inc edi
	add edx, ebp
        
	xor eax, eax
	shld eax, edx, cl
	shld ax, dx, cl
	mov bl, [esi+eax]
	mov bl, [ebx]
	mov [edi], bl
	inc edi
	add edx, ebp

	sub dword [LoopCount], FLOOP_LEN
	jnae .FLoopEnd
	jmp .FLoopStart
.FLoopEnd:
	popad				; restore all registers
	mov esp, ebp
        pop ebp				; restore caller's stack frame
        ret				; return 

[SECTION .data]

LoopCount:	dd 0

FLoopOffset:
    dd 0260h,024Dh,023Ah,0227h,0214h,0201h,01EEh,01DBh
    dd 01C8h,01B5h,01A2h,018Fh,017Ch,0169h,0156h,0143h
    dd 0130h,011Dh,010Ah,00F7h,00E4h,00D1h,00BEh,00ABh
    dd 0098h,0085h,0072h,005Fh,004Ch,0039h,0026h,0013h
