#ifndef _INTERNAL_H_
#define _INTERNAL_H_

#include "wtd.h"

//===========
// Constants
//===========
/********************   60 degrees   **************************************/
//#define VIEW_ANGLE	341			// FOV (60 deg)
//#define F_FLOOR_CONST	DOUBLE_FIX(1.1547)	// 1/Cos(30) (floor drawing)
//#define F_VIEW_CONST	DOUBLE_FIX(1.7321)	// 1/(Tan(30))

/********************   72 degrees   **************************************/
#define VIEW_ANGLE	410			// FOV (72 deg)
#define F_FLOOR_CONST	DOUBLE_FIX(1.2361)	// 1/Cos(36) (floor drawing)
#define F_VIEW_CONST	DOUBLE_FIX(1.3764)	// 1/(Tan(36))

/********************   90 degrees   **************************************/
//#define VIEW_ANGLE	512			// FOV (90 deg)
//#define F_FLOOR_CONST	DOUBLE_FIX(1.4142)	// 1/Cos(45) (floor drawing)
//#define F_VIEW_CONST	DOUBLE_FIX(1.0000)	// 1/(Tan(45))



#define F_MIN_DIST	INT_FIX(8)		// Default clipping distance
#define MAX_VDRAWS	1000			// Number of VDraws to alloc
#define MAX_MLINES	320*6			// Number of MLines to alloc
#define MAX_LEVELS	64			// Number of levels
//#define FPSTABLE_SIZE   1024                    // Size of FPS table
//#define FPSTABLE_NUM    20                      // Number of FPS tables
#define TEX_EMPTY	-1			// All PICs are empty
#define TEX_OLD		-2			// Leftover from prev zone


//=======================
// Attributes for VDraws
//=======================
#define VD_OBJECT	0x10000000		// VDraw is an object
#define VD_COMPLEX	0x20000000		// Complex wall
#define VD_WALLBACK	0x40000000		// Wall is turned


//========================
// Nice and useful macros
//========================
#define TexCheck(ptc)   {if ((ptc)->pTex) { \
                        if ((ptc)->pTex->Stamp==TEX_EMPTY) TexLoad(ptc);\
                        (ptc)->pTex->Stamp=TotalFrames;}}


//=======================
// Internal data structs
//=======================
struct VLine {
	SHORT Top, Bot;
};
struct FLine {
	BYTE  *RawPtr, *PalPtr, *PixPtr;
	DWORD  Coord, Delta;
	SHORT  LeftCol, Count, Width2;
        struct Area *pArea;
};
struct WLine {
	BYTE  *RawPtr, *PalPtr, *PixPtr;
	FIXED  Coord, Delta;
	SHORT  BufWidth, Count, Mask;
	BYTE   IsTrans, IsTile;
};
struct VDraw {
	DWORD  Type;
	void  *ptr;
	struct VDraw  *Prev, *Next;
	SHORT LeftCol,RightCol;
	FIXED LD,RD,dLD,dRD;
	FIXED XStart,XLen;
	FIXED px1,px2;
};
struct Level {
        struct Area *Start;
        struct Area *From;
	struct VLine *Clip;
	int ClipCount;
	FIXED MinDist;
};
struct RTEffect {
	struct Effect *Eff;
	void *data;
};

extern struct Wall    **WallPtrs;	// Wall ptr pool
extern struct RTEffect *RTE;		// Real-time effects (EFF_FRAME)
extern struct View     *CurView;	// Current view (during rendering)
extern struct VDraw    *VDraws;		// VDraws
extern struct WLine    *MLines;		// MLines (for masked/trans data)
extern struct FLine    *FLines;		// FLines (for floor buffering)
extern struct VLine    *VLines;		// VLines (for clipping)
extern struct Level     Levels[MAX_LEVELS]; // Levels (for 3d regions)
extern struct Level    *CurLevel;	// Current level during rendering
extern struct VDraw     LeftVDraw,RightVDraw;
extern FIXED           SinTable[], CosTable[], ITanTable[];//, *FPSTable;
extern BYTE            *Reject;

extern LONG CurStamp;
extern FIXED ViewX,ViewY,ViewCos,ViewSin;
extern int NumWallPtrs, NumRTE, NumVDraws, NumMLines, NumLevels;
extern int PickVX, PickVY, PickVFlag;


void DrawView(struct View *);		// Draw view into buffer

void ScanLevel(struct Level *);		// Scan level's data
void ScanArea(struct Area *);       // Scan region data

void UpdateFloor(SHORT,SHORT,SHORT,struct VLine *,struct PicInfo *,struct Area *);
void UpdateAboveHole(SHORT,SHORT,SHORT,struct VLine *,struct PicInfo *,struct Area *);
void UpdateBelowHole(SHORT,SHORT,SHORT,struct VLine *,struct PicInfo *,struct Area *);
void UpdateBack(SHORT,SHORT,SHORT,struct VLine *,struct PicInfo *,struct Area *);

void DrawSimpleWall(struct VDraw *);	// Render simple wall
void DrawComplexWall(struct VDraw *);	// Render cplx wall
void DrawObject(struct VDraw *);	// Render object
void DrawBackCol(int,int,int);		// Draw back vcol
void DrawMasked(void);			// Draw all masked stuff

void DrawFSpan(struct FLine *);		// Draw hor tex line
void DrawWSpan(struct WLine *);		// Draw ver tex line
void DrawMaskWSpan(struct WLine *);	// Draw masked ver tex line (wall)
void DrawTransWSpan(struct WLine *);	// Draw translucent ver tex line (wall)
void DrawOSpan(struct WLine *);		// Draw ver tex line (obj)
void DrawMaskOSpan(struct WLine *);	// Draw masked ver tex line (obj)
void DrawTransOSpan(struct WLine *);	// Draw translucent ver tex line (obj)


void InsertVDraw(struct VDraw *);	// Insert VDraw to the list
struct VDraw *FindVDraw(void);		// Get VDraw to render
struct VDraw *RemoveVDraw(struct VDraw *);// Remove VDraw from list

//void SetFPS(int);                       // Sets FPS value (param - ticks)

void InitMemory(void);
void ShutMemory(void);
void ClearCache(LONG);

//void LoadMath(void);
void LoadPalette(LONG,BYTE *,BYTE *);
void InitReject(BYTE *);

void TexLoad(struct TexCon *);
struct PicInfo *GetPic(char *);
void LoadPic(struct PicInfo *);

void UpdateLevel(void);
void ClearLevel(void);
void MoveWall(struct Wall *, FIXED, FIXED, FIXED, FIXED);
void MovePoint(struct Point *, FIXED, FIXED);

void InitEffects(void);
void SetupEffects(DWORD);
void AddRTEffect(struct Effect *, void *);
void DelRTEffect(void *);

#endif
