#include "internal.h"


int our_log_two(int Width);

// debug info
//extern int CountWalls, CountAreas, CountPoints;


void ScanWall(struct Wall *, struct Area *);
void ScanObject(struct Object *);
void TransformPoint(struct Point *);


void ScanArea(struct Area *pArea)
{
	struct Wall *pWall, **ptr;
	struct Object *pObject;
	int i;

// Check if Area has been already rendered for this frame/view/level
        if (pArea->Stamp>=CurStamp) return;
// Check if CurLevel is drawn from this Area
        if (CurLevel->From==pArea) return;
/*****************/
//CountAreas++;   // DEBUG
/*****************/
// Set Area stamp
        pArea->Stamp=CurStamp;
// Go thru all walls for this Area
        ptr=pArea->WallPtrs;
        for(i=0;i<pArea->NumWallPtrs;i++,ptr++) {
		pWall=*ptr;
	// Check if wall has been already rendered
		if (pWall->Stamp<CurStamp) {
			pWall->Stamp=CurStamp;
                        ScanWall(pWall,pArea);
/***************/
//CountWalls++;   // DEBUG
/***************/
		}
	}
// Go thru all Objects on the Area's list
        pObject=pArea->First;
	while(pObject) {
                ScanObject(pObject);
		pObject=pObject->Next;
	}
// If we have a 'below' or 'above' Area render its sprites
        if (pArea->Below) {
                pObject=pArea->Below->First;
		while(pObject) {
			ScanObject(pObject);
			pObject=pObject->Next;
		}
	}
        if (pArea->Above) {
                pObject=pArea->Above->First;
		while(pObject) {
			ScanObject(pObject);
			pObject=pObject->Next;
		}
	}
}

void ScanWall(struct Wall *pWall, struct Area *pArea) 
{
        struct Area *ToScan=NULL;
	struct Point  *pp1, *pp2;
	struct VDraw  *pVDraw;
	struct Object *po;
	FIXED MinDist,t,t1,t2,dx;

	po=CurView->pObject;
	MinDist=CurLevel->MinDist;

// Prepare Points
	t=CurStamp&0xFFFFFFF0;
	pp1=pWall->p1;
	if (pp1->Stamp<t) {
		pp1->Stamp=t;
		TransformPoint(pp1);
	}
	pp2=pWall->p2;
	if (pp2->Stamp<t) {
		pp2->Stamp=t;
		TransformPoint(pp2);
	}

// Allocate and init VDraw
	pVDraw=&VDraws[NumVDraws];
	pVDraw->Type=pWall->Type;
	pVDraw->ptr=(void *)pWall;

// Wall is to the left
	if (pp1->ld>0&&pp2->ld>0) return;
// Wall is to the right
	if (pp1->rd<0&&pp2->rd<0) return;
// Both points are too close or behind
	if (pp1->nx<MinDist&&pp2->nx<MinDist) {
	// Special case if we stand on a wall
		if (pWall->Back&&(pp1->nx>0||pp2->nx>0)) {
                        if (pWall->Front==pArea)
				ToScan=pWall->Back;
			else
				ToScan=pWall->Front;
		}
		goto END_WALLSCAN;
	}

	t1=pp1->a-pp2->a;	// Angle from p1 to p2 clockwise
	if (t1<0) t1+=F_DEG360;
	t2=-t1+F_DEG360;	// From p2 to p1 clockwise

	if (t1>t2) {		// Turn or return
		if (pWall->Back) {
			pVDraw->Type|=VD_WALLBACK;
			pp1=pWall->p2;
			pp2=pWall->p1;
			if (t1-t2<16) {
                                if (pArea==pWall->Front)
					ToScan=pWall->Back;
				else
					ToScan=pWall->Front;
			}
		}
		else
			goto END_WALLSCAN;
	}
	else {
		if (t2-t1<INT_FIX(16)) {
                        if (pArea==pWall->Front) {
				ToScan=pWall->Back;
			}
			else {
				ToScan=pWall->Front;
			}
		}
	}


// Check failing conditions for 'left' point
	if (pp1->nx>0) {
		if (pp1->rd<0) goto END_WALLSCAN;
	}
	else {
		if (pp1->ld<0) goto END_WALLSCAN;
	}
// Check failing conditions for 'right' point
	if (pp2->nx>0) {
		if (pp2->ld>0) goto END_WALLSCAN;
	}
	else {
		if (pp2->rd>0) goto END_WALLSCAN;
	}

	dx=pp2->nx-pp1->nx;
// Calculate LD, RD, LeftCol and RightCol & check some failing conditions
	t1=(pp1->rd-pp1->ny)<<1;	// Width of view cone at px1
	pVDraw->dLD=FixDiv(t1,INT_FIX(CurView->Width));
	t1=(pp2->rd-pp2->ny)<<1;	// Width of view cone at px2
	pVDraw->dRD=FixDiv(t1,INT_FIX(CurView->Width));


	pVDraw->px1=pp1->nx;		// Left proj distance
	pVDraw->px2=pp2->nx;		// Right proj distance

	if (pp1->ld>=0) {	// Point #1 is above the left line
// Adjust proj dist for point #1
		pVDraw->px1=pp1->nx+FixMul(FixDiv(pp1->ld,pp1->ld-pp2->ld),dx);
// Adjust LD for future PicX calcs
		pVDraw->LD=pp1->ld;
// Set RD for PicX calcs
		pVDraw->RD=pp2->ld;
// Wall starts at first scr column
		pVDraw->LeftCol=0;
	}
	else {			// Point #1 is in view
		if (pVDraw->dLD==0) {
                        if (pWall->Front==pArea)
				ToScan=pWall->Back;
			else
				ToScan=pWall->Front;
			goto END_WALLSCAN;
		}
// Calculate LeftCol
		t=FIX_INT(FixDiv(-pp1->ld,pVDraw->dLD));
		pVDraw->LeftCol=t;
		t=INT_FIX(t);
// Adjust RD for PicX calcs
		pVDraw->RD=pp2->ld+FixMul(t,pVDraw->dRD);
// Make a correction for LD (pp1->ld<0)
		pVDraw->LD=pp1->ld+FixMul(t,pVDraw->dLD);
	}

// Is the left proj dist too close?
	if (pVDraw->px1<F_MIN_DIST) {
// Small hack. If the new projection distance is too close but
// not behind, set it to MinDist. Texmapping gets very chunky
// at close range anyway.
		if (pVDraw->px1>=0) {
			pVDraw->px1=F_MIN_DIST;
		}
		else
			goto END_WALLSCAN;
	}

	if (pp2->rd<=0) {	// Point #2 is below the right line
// Wall ends at ViewWidth
		pVDraw->RightCol=CurView->Width;
// Adjust proj dist for point #2
		pVDraw->px2=pp1->nx+FixMul(FixDiv(pp1->rd,pp1->rd-pp2->rd),dx);
	}
	else {			// Point #2 is in view
		if (pVDraw->dRD==0) {
                        if (pWall->Front==pArea)
				ToScan=pWall->Back;
			else
				ToScan=pWall->Front;
			goto END_WALLSCAN;
		}
// Calculate RightCol
		t=FixDiv(-pp2->ld,pVDraw->dRD);
		pVDraw->RightCol=FIX_INT(t);
	}

// Is the right proj dist too close?
	if (pVDraw->px2<F_MIN_DIST) {
// The same hack as with px1. BUT if px1 has been hacked,
// the wall is not visible.
		if (pVDraw->px1>F_MIN_DIST) {	// px1 not hacked
			if (pVDraw->px2>=0) {
				pVDraw->px2=F_MIN_DIST;
			}
			else 
				goto END_WALLSCAN;
		}
		else {				// px1 hacked
			if (pVDraw->px2>=0) {
                                if (pWall->Front==pArea)
					ToScan=pWall->Back;
				else
					ToScan=pWall->Front;
			}
			goto END_WALLSCAN;
		}
	}

// Check if the wall has zero width on screen
	if (pVDraw->LeftCol>=pVDraw->RightCol)
		goto END_WALLSCAN;

// Z (X) stuff
	pVDraw->XStart=pp1->nx;
	pVDraw->XLen=pp2->nx-pp1->nx;
// VDraw type
	if (pWall->Back)
		pVDraw->Type|=VD_COMPLEX;

// Insert into drawing list
	NumVDraws++;
	if (NumVDraws<MAX_VDRAWS)
		InsertVDraw(pVDraw);
	else
		NumVDraws--;

END_WALLSCAN:
	if (ToScan)
                ScanArea(ToScan);
}


void ScanObject(struct Object *pObject)
{
	struct VDraw     *pVDraw;
	struct Point     *pp1;
	struct TexCon    *ptc;
	struct Texture   *tex;
        FIXED t,t1,t2,ott;

        SHORT our_SideSize,our_SideSize2,our_num2;

// Check for NULL texture
	if (pObject->TC.pTex==NULL) return;

// Prepare Point
	t=CurStamp&0xFFFFFFF0;
	pp1=pObject->pp;
	if (pp1->Stamp<t) {
		pp1->Stamp=t;
		TransformPoint(pp1);
	}
// Check if point is too close or behind view
	if (pp1->nx<CurLevel->MinDist) return;

// Allocate VDraw
	pVDraw=&VDraws[NumVDraws];

	ptc=&pObject->TC;
	tex=ptc->pTex;

// Find side. For 16 sides - one side is 128 units
	t=-CurView->pObject->Angle-CurView->HAngle;
	t+=pObject->Angle+DEG180-FIX_INT(pp1->a);
        if(tex->obj3d){
//                pt->SideSize=DEG360;
//                pt->SideSize2=DEG360_2;
//                //pt->SideSize=DEG360>>pt->NumSides2;
//                //pt->SideSize2=DEG360_2-pt->NumSides2;

                our_num2=our_log_two(62);//360);

                our_SideSize=DEG360>>our_num2;
                our_SideSize2=DEG360_2-our_num2;

                ott=(t+(our_SideSize>>1))>>our_SideSize2;

                ott&=62-1;//360-1;
                pObject->our_relative_angle=ott;
                }
        else{
                t=(t+(tex->SideSize>>1))>>tex->SideSize2;
                t&=tex->NumSides-1;

                pObject->our_relative_angle=ptc->pCell->Start+t;//the int version of
            }

     pObject->relative_angle=t;
//    pObject->our_relative_angle=ptc->pCell->Start+t;//the int version of

// Find PIC
        if(tex->obj3d){
                ptc->pPic=tex->PicPtrs[0];
                ptc->IsMirror=tex->Mirrors[0];
                        }
        else{
                ptc->pPic=tex->PicPtrs[ptc->pCell->Start+t];
                ptc->IsMirror=tex->Mirrors[ptc->pCell->Start+t];
                        }
//return;
// Find object size
        if (ptc->IsMirror) {                    // Is image mirrored
                t2=INT_FIX(ptc->pPic->InsY);            // right part
                t1=INT_FIX(ptc->pPic->Height-ptc->pPic->InsY);// left
        }
        else {
		t1=INT_FIX(ptc->pPic->InsY);		// left part
		t2=INT_FIX(ptc->pPic->Height-ptc->pPic->InsY); // right
        }
//CRASHED
// Clipping stuff
	if (pp1->ld-t2>=0) return;	// Higher than left line
	if (pp1->rd+t1<=0) return;	// Lower than right line

	t=(pp1->rd-pp1->ny)<<1;		// Width of view cone at nx
	pVDraw->dLD=FixDiv(t,INT_FIX(CurView->Width)); // dHor
	pVDraw->LD=0;

	if (pp1->ld+t1>=0) {		// Left side is above left line
	// Object starts at the first scr_line
		pVDraw->LeftCol=0;
	// Adjust LD for proper picture
		pVDraw->LD=pp1->ld+t1;
	}
	else {				// Left side is in view
	// Calculate start column
		pVDraw->LeftCol=FIX_INT(FixDiv(-(pp1->ld+t1),pVDraw->dLD));
	}

	if (pp1->rd-t2<=0) {		// Right side is below right line
	// Object ends at the last column
		pVDraw->RightCol=CurView->Width;
	}
	else {
	// Calculate end column
		pVDraw->RightCol=FIX_INT(FixDiv(-(pp1->ld-t2),pVDraw->dLD));
	}

// Additional failing conditions
	if (pVDraw->LeftCol>=pVDraw->RightCol) return;
	if (pVDraw->LeftCol>=CurView->Width) return;
	if (pVDraw->RightCol<=0) return;

// Make projection distance (consider overlay objects)
	t=pp1->nx;
	if (pObject->Type&O_INFRONT) t-=16;
	else if (pObject->Type&O_BEHIND) t+=16;
// Setup VDraw
	pVDraw->ptr=(void *)pObject;
	pVDraw->Type=VD_OBJECT|pObject->Type;
	pVDraw->px1=pVDraw->px2=t;
	pVDraw->XStart=t;
	pVDraw->XLen=0;

// Insert into drawing list
	NumVDraws++;
        if (NumVDraws<MAX_VDRAWS) InsertVDraw(pVDraw);
        else NumVDraws--;
}

void TransformPoint(struct Point *p)
{
	FIXED tx, ty;
/*****************/
//CountPoints++;    // DEBUG
/*****************/
	tx=p->x-ViewX;
	ty=p->y-ViewY;
	p->nx=FixMul(tx,ViewCos)-FixMul(ty,ViewSin);
	p->ny=FixMul(tx,ViewSin)+FixMul(ty,ViewCos);
	ty=FixMul(CurView->ConstHSlope,p->nx);
	p->ld=p->ny-ty;
	p->rd=p->ny+ty;
	p->a=FixITan(p->nx,p->ny);
}

void InsertVDraw(struct VDraw *pVDraw)
{
	struct VDraw *pvd;

	pvd=&LeftVDraw;
	while(pvd->LeftCol<pVDraw->LeftCol) pvd=pvd->Next;
	// Insert before
	pvd->Prev->Next=pVDraw;
	pVDraw->Prev=pvd->Prev;
	pVDraw->Next=pvd;
	pvd->Prev=pVDraw;
}

// Returns pointer to the next structure in the list
struct VDraw *RemoveVDraw(struct VDraw *pVDraw)
{
	struct VDraw *pvd;

	pvd=pVDraw->Next;
	pvd->Prev=pVDraw->Prev;
	pVDraw->Prev->Next=pvd;
	return(pvd);
}

