#include "internal.h"


static struct Object *ObjPtrs[RES_NUM];
static int NumObjPtrs;

void DoObjectUpdate(struct Object *);	// In OBJECT.C

void UpdateLevel(void){
	struct RTEffect *rt;
	struct Object   *pObject;
	struct View     *pView;
	FIXED t1,vc,vs;
	int i;
        // Number of objects to update
	NumObjPtrs=0;

        // Update all Real-Time Effects
	rt=&RTE[0];
        for(i=0;i<NumRTE;i++,rt++) rt->Eff->func(rt->data,EFF_FRAME,0);

        // Update the objects
        for(i=NumObjPtrs-1;i>=0;i--) DoObjectUpdate(ObjPtrs[i]);

        // Update Views
	for(i=0;i<Views.Number;i++) {
		pView=(struct View *)Views.ptr[i];
		pObject=pView->pObject;
		t1=-pObject->Angle-pView->HAngle-(VIEW_ANGLE>>1);
		pView->tc1=FixCos(t1);
		pView->ts1=FixSin(t1);
		t1+=VIEW_ANGLE;
		vc=FixCos(t1);
		vs=FixSin(t1);
		t1=INT_FIX(pView->Width);
		pView->tc2=FixDiv(vc-pView->tc1,t1);
		pView->ts2=FixDiv(vs-pView->ts1,t1);
		pView->H=pObject->RH+pView->ObjHeight;
	}
return; }

void TexUpdate(struct TexCon *ptc){
	if (ptc->pTex==NULL) return;
        if (!ptc->pCell) { TexAction(ptc,0); return; }
        /*if (ptc->Delay<=0) {
		ptc->pCell=ptc->pCell->Next;
		ptc->Delay+=ptc->pCell->Delay;
		ptc->pPic=ptc->pTex->PicPtrs[ptc->pCell->Start];
		ptc->IsMirror=ptc->pTex->Mirrors[ptc->pCell->Start];
        }
        ptc->Delay-=Engine.TimeUnit;*/
return; }

void TexAction(struct TexCon *ptc, int act){
	if (ptc->pTex==NULL) return;
	ptc->pCell=ptc->pTex->AEntry[act];
        //ptc->Delay=ptc->pCell->Delay;
        //ptc->Delay-=Engine.TimeUnit;
	ptc->pPic=ptc->pTex->PicPtrs[ptc->pCell->Start];
        ptc->IsMirror=ptc->pTex->Mirrors[ptc->pCell->Start];
return; }

void UpdateObject(struct Object *po){
	if (NumObjPtrs<RES_NUM-1) {
		ObjPtrs[NumObjPtrs]=po;
		NumObjPtrs++;
                }
return; }


/*void StructStart(struct Point *pp, int mode){
	struct Point *p;
	struct Path  *path;
	int t;

	p=pp;
	do {
                if (!p->path){ FatalError(ER_GENERAL);//,NULL);
                                        return; }
		p->Type|=P_PMOVE;
		path=p->path;
                // Restore original coords
		t=mod(p->Coord);
		p->x-=INT_FIX(path->ax[t]);
		p->y-=INT_FIX(path->ay[t]);

		p->Count=path->Delay;
                if (mode==PATH_START) p->Coord=0;
		else if (mode==PATH_END||p->Coord>=path->NumCoords-1)
			p->Coord=-(path->NumCoords-1);

                // Set new coords
		t=mod(p->Coord);
		p->x+=INT_FIX(path->ax[t]);
		p->y+=INT_FIX(path->ay[t]);

		p=p->link;
	} while(p!=NULL&&p!=pp);
return; }

void StructStop(struct Point *pp){
	struct Point *p;
	p=pp;
        do { p->Type&=~P_PMOVE; p=p->link; } while(p!=NULL&&p!=pp);
return; }

int StructUpdate(struct Point *pp){
	struct Point *p;
	struct Path *path;
	int t, status;

	status=0;
	p=pp;
	do {
                if (!p->path){ FatalError(ER_GENERAL);//,NULL);
                                return 0; }

		path=p->path;
		if ((p->Type&P_PMOVE)!=0) {
			p->Count-=Engine.TimeUnit;
			if (p->Count<=0) {
			// Restore original coords
				t=mod(p->Coord);
				p->x-=INT_FIX(path->ax[t]);
				p->y-=INT_FIX(path->ay[t]);

				p->Count=path->Delay;
				p->Coord++;
				if (p->Coord>=path->NumCoords-1) {
					p->Type^=P_PMOVE;
					status=PATH_END;
				}
				else if (p->Coord==0) {
					p->Type^=P_PMOVE;
					status=PATH_START;
				}

			// Set new coords
				t=mod(p->Coord);
				p->x+=INT_FIX(path->ax[t]);
				p->y+=INT_FIX(path->ay[t]);
			}
		}

		p=p->link;
	} while(p!=NULL&&p!=pp);

	return(status);
}*/


void MoveWall(struct Wall *pWall, FIXED dist, FIXED c, FIXED s, FIXED pos)
//        pWall - wall to move
//        dist  - distance to move
//        c,s   - direction of movement (cos, sin)
//        pos   - position on the wall where force is applied
{
	struct Point *p;
        // Freely moving wall
	if (pWall->p1->path==NULL) {
		MovePoint(pWall->p1,FixMul(dist,c),FixMul(dist,s));
		return;
                }
        // Choose which point the movement will be applied to
        if (pos>(pWall->Length>>1)) p=pWall->p2;
        else p=pWall->p1;
	MovePoint(p,c,s);
return; }

void MovePoint(struct Point *pp, FIXED dx, FIXED dy){
	struct Point *p;
//        struct Path  *path;
//        int Coord, Next=0;
//        FIXED tx, ty, Dot;

	p=pp;
//        path=p->path;
        // Point will move along path. Find Coord for all points in the structure.
/*        if (path) {
        // Find how the coord should be changed. This is done by calculating dot 
        // product between desired direction and the direction to the next coord 
        // in the path. If the dot product is negative the process is repeated 
        // for the prev coord. If the product is zero, no movement takes place.

                // Current coord
		Coord=p->Coord;
		Dot=0;
                // Find next Coord to compare
		if (Coord!=path->NumCoords-1) {
			Next=Coord+1;
			tx=INT_FIX(path->ax[mod(Next)]-path->ax[mod(Coord)]);
			ty=INT_FIX(path->ay[mod(Next)]-path->ay[mod(Coord)]);
			if (FixMod(tx)+FixMod(ty)>INT_FIX(8))
				Dot=FixMul(tx,dx)+FixMul(ty,dy);
		}

                // Find prev Coord to compare (only if prev Dot was non-positive)
		if (Dot<=0&&Coord!=0&&Coord!=-path->NumCoords+1) {
			Next=Coord-1;
			tx=INT_FIX(path->ax[mod(Next)]-path->ax[mod(Coord)]);
			ty=INT_FIX(path->ay[mod(Next)]-path->ay[mod(Coord)]);
			if (FixMod(tx)+FixMod(ty)>INT_FIX(8))
				Dot=FixMul(tx,dx)+FixMul(ty,dy);
		}

                // Do movement only if Dot is positive
		if (Dot>0) {
			p->x-=INT_FIX(p->path->ax[mod(p->Coord)]);
			p->y-=INT_FIX(p->path->ay[mod(p->Coord)]);
			p->Coord=Next;
			p->x+=INT_FIX(p->path->ax[mod(p->Coord)]);
			p->y+=INT_FIX(p->path->ay[mod(p->Coord)]);
			while(p->link!=NULL&&p->link!=pp) {
				p=p->link;
				p->x-=INT_FIX(p->path->ax[mod(p->Coord)]);
				p->y-=INT_FIX(p->path->ay[mod(p->Coord)]);
				p->Coord=Next;
				p->x+=INT_FIX(p->path->ax[mod(p->Coord)]);
				p->y+=INT_FIX(p->path->ay[mod(p->Coord)]);
			}
		}
	}
        // No path defined. Free moving structure
        else {*/
		while(TRUE) {
                        if ((p->Type&P_XMOVE)!=0||p->link==NULL)p->x+=dx;
                        if ((p->Type&P_YMOVE)!=0||p->link==NULL)p->y+=dy;
                        if (p->link==NULL||p->link==pp) break;
			p=p->link;
		}
//        }
return; }

