// ADD_STEP==0  -  Means go to the color color exactly
// ADD_STEP==NumShades - Go half way to the end color

//#include "pals\actual.h"

extern BYTE our_pal[];

#define ADD_STEP		16
#define MAX_SHADES              32

int StartColor, EndColor;
double Pals[MAX_SHADES][256][3];

void CreatePals(double DestRed,double DestGreen,double DestBlue){
	double R, G, B, dr, dg, db;
	int i, n;
	for(i=0;i<256;i++) {
                R=Pals[0][i][0]; G=Pals[0][i][1]; B=Pals[0][i][2];
                dr=(DestRed-R)/(double)(Pal.PH.NumShades+ADD_STEP);
                dg=(DestGreen-G)/(double)(Pal.PH.NumShades+ADD_STEP);
                db=(DestBlue-B)/(double)(Pal.PH.NumShades+ADD_STEP);
		R+=dr;G+=dg;B+=db;
                for(n=1;n<Pal.PH.NumShades;n++) {
                        Pals[n][i][0]=R; Pals[n][i][1]=G; Pals[n][i][2]=B;
			R+=dr;G+=dg;B+=db;
		}
	}
return; }

unsigned char FindIndex(double r, double g, double b){
	double R, G, B, dist, t;
	int i, index=0;

	dist=256.0*256.0*256.0;
	for(i=StartColor;i<=EndColor;i++) {
                R=Pals[0][i][0]-r; G=Pals[0][i][1]-g;  B=Pals[0][i][2]-b;
		t=R*R+G*G+B*B;
                if (t<dist) { index=i;dist=t; }
	}
return((unsigned char)index); }

void CreateTable(BYTE *ptr){
	int i, n;
        for(n=0;n<Pal.PH.NumShades;n++) {
		for(i=0;i<256;i++) {
                        ptr[n*256+i]=FindIndex(Pals[n][i][0],
				Pals[n][i][1],Pals[n][i][2]);
                                }
                }
return; }

void MakePalette(int n_tab,int n_shad,int s_col,int e_col){
      LONG size;
      int i;


        StartColor=s_col;
        EndColor=e_col;
        if (Pal.MemTables) { MemFree(Pal.MemTables,"MakePal:PalMemTable");
                             Pal.MemTables=NULL; }

        strcpy(Pal.PH.IDStr,PAL_ID);
        Pal.PH.NumTables=n_tab;
        Pal.PH.NumShades=n_shad;

        memcpy(Pal.VGAPal,our_pal,768);//copy vga pal

	for(i=0;i<256;i++) {
		Pals[0][i][0]=(double)Pal.VGAPal[i*3+0];
		Pals[0][i][1]=(double)Pal.VGAPal[i*3+1];
		Pals[0][i][2]=(double)Pal.VGAPal[i*3+2];
	}
         for(i=0;i<32;i++) Pal.BackFade[i]=0;

         size=256*Pal.PH.NumShades*Pal.PH.NumTables+256*256;
         Pal.MemTables=CacheAlloc(size+256,"MakePal:PalMemTable");
         Pal.Tables[0]=(BYTE *)(((DWORD)Pal.MemTables+255)&0xFFFFFF00);
        size=256*Pal.PH.NumShades;
        for(i=1;i<Pal.PH.NumTables;i++)
                        Pal.Tables[i]=Pal.Tables[i-1]+size;

        for(i=0;i<Pal.PH.NumTables;i++){
                        CreatePals(0,0,0);//r,g,b
                        Pal.BackFade[i]=0;//back
                        CreateTable(Pal.Tables[i]);
                                }
return; }



