#include "wtd.h"

extern void O_Player(void *,DWORD,DWORD);

extern void W_AbsLight(void *,DWORD,DWORD);
extern void W_RelLight(void *,DWORD,DWORD);
extern void R_AbsLight(void *,DWORD,DWORD);
extern void R_RelLight(void *,DWORD,DWORD);
extern void R_WAbsLight(void *,DWORD,DWORD);
extern void R_WRelLight(void *,DWORD,DWORD);
extern void R_CeilTexView(void *,DWORD,DWORD);

extern void V_Default(void *,DWORD,DWORD);
extern void V_Rotate(void *,DWORD,DWORD);
extern void V_Inside(void *,DWORD,DWORD);
extern void V_Stereo(void *,DWORD,DWORD);


// View effects
// Here all the effects have to be registered.
void InitEffects(void){
        RegisterEffect("OPLAY",O_Player,EFF_FRAME);

	RegisterEffect("WALI",W_AbsLight,0);
	RegisterEffect("WRLI",W_RelLight,0);
	RegisterEffect("RALI",R_AbsLight,0);
	RegisterEffect("RRLI",R_RelLight,0);
	RegisterEffect("RWALI",R_WAbsLight,0);
	RegisterEffect("RWRLI",R_WRelLight,0);
        RegisterEffect("RCTXV",R_CeilTexView,0);

        RegisterEffect("VDEF",V_Default,EFF_POST);
	RegisterEffect("VROT",V_Rotate,EFF_POST);
	RegisterEffect("VINS",V_Inside,EFF_FRAME|EFF_POST);
	RegisterEffect("VSTEREO",V_Stereo,EFF_FRAME|EFF_POST);
return; }




//****** eff_w *******
// Sets absolute light level for a wall
//        P - Absolute light level.
void W_AbsLight(void *ptr, DWORD type, DWORD param){
	struct Wall *pWall;
	pWall=(struct Wall *)ptr;
	switch(type) {
		case EFF_INIT:
			pWall->Type|=T_ABSLIGHT;
			pWall->Fade=pWall->Var.P;
			break;
	}
return; }

// Sets relative light level for a wall
//        P - Relative light level.
void W_RelLight(void *ptr, DWORD type, DWORD param){
	struct Wall *pWall;
	pWall=(struct Wall *)ptr;
	switch(type) {
		case EFF_INIT:
			pWall->Type&=~T_ABSLIGHT;
			pWall->Fade=pWall->Var.P;
			break;
	}
return; }

// Puts contents of a View on the MidTex on the Wall. The MidTex has to
// be assigned 1 frame texture of the same size as the View.
//        P - View to use.
void W_MidTexView(void *ptr, DWORD type, DWORD param){
	static struct PicInfo pic;
	struct Wall *pWall;
	struct View *v;
	pWall=(struct Wall *)ptr;
	switch(type) {
		case EFF_INIT:
                        // Pointer of the view to substitute
			v=(struct View *)Views.ptr[pWall->Var.P];
			if (v->ScrX==-1||v->ScrY==-1) {
                                // Prepare PIC substitution
				pic.Width=v->Width;
				pic.Height=v->Height;
				pic.InsX=pic.InsY=0;
                                if (pic.Width<=64)pic.Width2=6;
                                else if (pic.Width<=128)pic.Width2=7;
                                else pic.Width2=8;
				pic.Raw=v->Buffer;
				pWall->MidTC.pPic=&pic;
			}
			break;
	}
return; }

// Default view effect.
//        No vars are used.
void V_Default(void *ptr,DWORD type,DWORD param){
	struct View *pView;
	struct Object *pObject;

	pView=(struct View *)ptr;
	pObject=pView->pObject;
	switch(type) {
                // A zone just have been loaded to memory (no init param).
		case EFF_INIT:
			pView->ObjHeight=FixMul(pObject->Height,
                                                        DOUBLE_FIX(0.8));
			break;
               // The zone was erased from memory. All the resources have been cleared
                case EFF_CLEAR:        break;
// Effect is called one time per frame AFTER rendering!
		case EFF_POST:
			pView->ObjHeight=FixMul(pObject->Height,
                                        DOUBLE_FIX(0.8));//-FixMod(0));//t2));
	}
return; }

// Rotates view buffer which HAS to be square (SLOW!!!)
//        No params
void V_Rotate(void *ptr,DWORD type,DWORD param) {
	struct View *pView;
	register int i,j;
	register BYTE t, *ptr1, *ptr2;

	if (type!=EFF_POST) return;
	pView=(struct View *)ptr;
	for(j=1;j<pView->Width;j++) {
		ptr1=pView->BufScan[j];
		ptr2=pView->Buffer+j;
		for(i=j;i>0;i--) {
			t=*ptr1;
			*ptr1=*ptr2;
			*ptr2=t;
			ptr1++;
			ptr2+=pView->Width;
		}
	}
return; }

// The biggest hack ever :)  This effect makes a view to be displayed inside
// another one (given by P). The pixels get drawn twice. To avoid that you 
// can try to play with StartClip of the first view. ScrX and ScrY of the
// "inside" view are relative to the "outside" view. The outside view number
// MUST be less than the inside's.
//        P - we are inside this view
//        A - stored value of ScrX of the outside view
// Internal VPE variable! Do not use unless you know what you are doing.
extern struct View *CurView;
void V_Inside(void *ptr,DWORD type,DWORD param) {
	struct View *pView, *out;
	BYTE *buf_ptr;

	pView=(struct View *)ptr;
	out=(struct View *)Views.ptr[pView->Var.P];
	switch(type) {
		case EFF_INIT:
                        // Find ptr for the inside buffer
			buf_ptr=out->BufScan[pView->ScrY]+pView->ScrX;
                        // Setup inside view
			SetViewSize(pView,pView->Width,pView->Height,buf_ptr,out->Width);
                        // Store ScrX of the outside view
			pView->Var.A=out->ScrX;
			break;
		case EFF_FRAME:
                        // This event is sent before ANY rendering takes place.
                        // Here we disable blitting for the outside view.
			out->ScrX=-1;
			break;
		case EFF_POST:
		// And now the tricky part. The outside view has been rendered
		// but no blitted. The inside view has also been rendered on 
		// top of the outside view. BUT if we allow blit for inside
		// view we get just inside view on screen.
		// Instead, we make VPE believe that it works with the outside
		// view. We use internal variable CurView for this purpose.
		// Usually you should not do this ;)
			out->ScrX=pView->Var.A;
			CurView=out; 
			break;
	}
return; }

// The position of the "stereo" view is adjusted relative to the view's object.
//        P - eye distance (<0 - left;  >0 - right)
void V_Stereo(void *ptr, DWORD type, DWORD param){
	struct View *view;
	struct Object *po, *fol;
        struct Area *reg;
	FIXED t,c,s;
	switch(type) {
		case EFF_FRAME:
			view=(struct View *)ptr;
		// Sync. views
			view->ObjHeight=ActView->ObjHeight;
			view->Vis=ActView->Vis;
			view->Table=ActView->Table;
			view->HAngle=ActView->HAngle;
			view->VAngle=ActView->VAngle;
			view->Horizon=ActView->Horizon;
		// Sync. objects
			po=view->pObject;
			fol=ActView->pObject;
			po->Angle=fol->Angle;
			c=FixCos(po->Angle+view->HAngle);
			s=FixSin(po->Angle+view->HAngle);
			t=INT_FIX(view->Var.P);
			po->pp->x=fol->pp->x-FixMul(s,t);
			po->pp->y=fol->pp->y+FixMul(c,t);
                        if (po->pArea!=fol->pArea) {
                                reg=FindArea(po->pp->x,po->pp->y,po->H,0);
                                if (reg==fol->pArea) {
                                        ClearObjArea(po);
                                        SetObjArea(po,reg);
				}
			}
			po->H=fol->H;
			po->RH=fol->RH;
			break;
	}
return; }

// Sets absolute light level for Area
//        P - light level.
void R_AbsLight(void *ptr, DWORD type, DWORD param){
        struct Area *pArea;
        pArea=(struct Area *)ptr;

	switch(type) {
		case EFF_INIT:
                        pArea->Fade=pArea->Var.P;
                        pArea->Type|=T_ABSLIGHT;
			break;
	}
return; }

// Sets relative light level for Area
//        P - light level.
void R_RelLight(void *ptr, DWORD type, DWORD param){
        struct Area *pArea;

        pArea=(struct Area *)ptr;

	switch(type) {
		case EFF_INIT:
                        pArea->Fade=pArea->Var.P;
                        pArea->Type&=~T_ABSLIGHT;
			break;
	}
return; }

// Sets absolute light level for Area and all connecting walls
//        P - light level.
void R_WAbsLight(void *ptr, DWORD type, DWORD param){
        struct Area *pArea;
	struct Wall *w;
	int n;
        pArea=(struct Area *)ptr;
	switch(type) {
		case EFF_INIT:
                        pArea->Fade=pArea->Var.P;
                        pArea->Type|=T_ABSLIGHT;
			n=0;
                        while((w=ReAdjWall(pArea,&n))) {
                                w->Fade=pArea->Fade;
				w->Type|=T_ABSLIGHT;
			}
			break;
	}
return; }

// Sets relative light level for Area and all connecting walls
//        P - light level.
void R_WRelLight(void *ptr, DWORD type, DWORD param){
        struct Area *pArea;
	struct Wall *w;
	int n;
        pArea=(struct Area *)ptr;
	switch(type) {
		case EFF_INIT:
                        pArea->Fade=pArea->Var.P;
                        pArea->Type&=~T_ABSLIGHT;
			n=0;
                        while((w=ReAdjWall(pArea,&n))) {
                                w->Fade=pArea->Fade;
				w->Type&=~T_ABSLIGHT;
			}
			break;
	}
return; }

// Puts contents of a View on the CeilTex on the Area. The Reg has to
// be assigned 1 frame texture of the same size as the View.
//        P - View to use.

void R_CeilTexView(void *ptr, DWORD type, DWORD param){
	static struct PicInfo pic;
        struct Area *pArea;
	struct View *v;

        pArea=(struct Area *)ptr;
	switch(type) {
		case EFF_INIT:
		// Pointer of the view to substitute
                        v=(struct View *)Views.ptr[pArea->Var.P];
			if (v->ScrX==-1||v->ScrY==-1) {
		// Prepare PIC substitution
				pic.Width=v->Width;
				pic.Height=v->Height;
				pic.InsX=pic.InsY=0;
				if (pic.Width<=64)
					pic.Width2=6;
				else if (pic.Width<=128)
					pic.Width2=7;
				else
					pic.Width2=8;
				pic.Raw=v->Buffer;
                                pArea->CeilTC.pPic=&pic;
			}
			break;
	}
return; }

void O_Player(void *ptr, DWORD type, DWORD param){
        struct Object *po;
	po=(struct Object *)ptr;
	switch(type) {
		case EFF_INIT:
			po->Var.A=po->Var.B=po->Var.D=0;
			break;
		case EFF_FRAME:
			UpdateObject(po);
			break;
                }
return; }
