#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "boxes.h"
#include "zone.h"
#include "doom.h"

#define MAX_SIZE	2048

#define min(a,b)	((a)<(b)?(a):(b))
#define max(a,b)	((a)>(b)?(a):(b))


struct Vertex  Ver[MAX_SIZE];
struct LineDef Line[MAX_SIZE];
struct SideDef Side[MAX_SIZE];
struct Sector  Sec[MAX_SIZE];
char Tex[MAX_SIZE][10];

int MinX=10000, MaxX=-10000, MinY=10000, MaxY=-10000;
int NumVer, NumLine, NumSide, NumSec, NumTex;

void ReadDoom(void);
void MakeZone(char *);

int  MakeXCoord(int);
int  MakeYCoord(int);
int  MakeFloor(int);
void MakeTex(char *, char *);
void TexList(char *);

void main(int argc, char *argv[])
{
	printf("\nDOOM to ZON converter.\n");
	if (argc!=2) {
		printf("\nUSAGE:  DM_ZON zone.zon\n");
		printf("Builds VPE zone (%s) file from Doom data.\n",ZONE_ID);
		exit(1);
	}
	printf("Read DOOM data...\n");
	ReadDoom();
	printf("Points: %d, Regions: %d, Walls: %d\n",NumVer,NumSec,NumLine);
	printf("X: (%d) - (%d), Y: (%d) - (%d)\n",MinX,MaxX,MinY,MaxY);
	printf("Building ZON...\n");
	MakeZone(argv[1]);
	TexList("TEX_LIST");
}

void MakeZone(char *name)
{
	struct ZF_Header   header;
	struct ZF_Point    point;
	struct ZF_Path     path;
	struct ZF_Region   region;
	struct ZF_Wall     wall;
	struct ZF_Object   object;
	struct ZF_View     view;
	struct ZF_General  gen;
	int i,j,t1,t2;
	FILE *fp;

	fp=fopen(name,"wb");
	if (fp==NULL) {
		printf("Could not open zone file!\n");
		exit(1);
	}


// Prepare and write new header
	strcpy(header.IDStr,ZONE_ID);
	header.NumPaths=0;
	header.NumPoints=NumVer;
	header.NumRegions=NumSec;
	header.NumWalls=NumLine;
	header.NumObjects=0;
	header.NumViews=0;
	fwrite(&header,sizeof(struct ZF_Header),1,fp);

// Do Points
	for(i=0;i<header.NumPoints;i++) {
		point.Type=0;
		point.x=MakeXCoord(Ver[i].X);
		point.y=MakeYCoord(Ver[i].Y);
		fwrite(&point,sizeof(struct ZF_Point),1,fp);
	}

// Do Regions
	for(i=0;i<header.NumRegions;i++) {
		region.Type=0;
		region.FloorH=MakeFloor(Sec[i].FloorH);
		region.CeilH=MakeFloor(Sec[i].CeilH);
		MakeTex(region.FloorTex,Sec[i].FloorTex);
		MakeTex(region.CeilTex,Sec[i].CeilTex);
		strcpy(region.Eff,"NO_NAME");
		region.EffParam=0;
		region.Below=-1;
		region.Above=-1;
		if (Sec[i].Tag==0) region.Tag=-1;
		else region.Tag=Sec[i].Tag;
		fwrite(&region,sizeof(struct ZF_Region),1,fp);
	}

// Do Walls
	for(i=0;i<header.NumWalls;i++) {
		wall.p1=Line[i].Vertex1;
		wall.p2=Line[i].Vertex2;
		t1=Line[i].SideDef1;
		t2=Line[i].SideDef2;

		MakeTex(wall.TopTex,Side[t1].TopTex);
		MakeTex(wall.MidTex,Side[t1].MidTex);
		MakeTex(wall.BotTex,Side[t1].BotTex);
	// One-sided wall
		if (t2<0) {
			wall.Front=Side[t1].Sector1;
			wall.Back=-1;
			wall.Type=W_SOLID;
		}
	// Two-sided wall
		else {
			wall.Front=Side[t1].Sector1;
			wall.Back=Side[t2].Sector1;
			wall.Type=W_MASK;
		}

		strcpy(wall.Eff,"NO_NAME");
		wall.EffParam=0;
		wall.TexX=Side[t1].TexX;
		wall.TexY=Side[t1].TexY;
		wall.Mass=0;
		if (Line[i].Tag==0)
			wall.Tag=-1;
		else
			wall.Tag=Line[i].Tag;
		fwrite(&wall,sizeof(struct ZF_Wall),1,fp);
	}

	strcpy(gen.Title,"Doom zone");
	strcpy(gen.Palette,"PALETTE");
	strcpy(gen.ScrTex,"NO_NAME");
	strcpy(gen.BackTex,"BACK2");
	strcpy(gen.BackEff,"NO_NAME");
	gen.BackAngle=120;
	gen.ActView=-1;
	gen.Force.x=200;
	gen.Force.y=200;
	gen.Force.z=400;
	gen.Force.t=100;
	fwrite(&gen,sizeof(struct ZF_General),1,fp);

	fclose(fp);
}



void ReadDoom(void){
	FILE *fp;

	fp=fopen("VERTEXES","rb");
	if (fp==NULL) {
		printf("Could not open VERTEXES!\n");
		exit(1);
	}
	NumVer=0;
	while(1) {
		fread(&Ver[NumVer],sizeof(struct Vertex),1,fp);
		if (feof(fp)) break;

		MinX=min(Ver[NumVer].X,MinX);
		MaxX=max(Ver[NumVer].X,MaxX);
		MinY=min(Ver[NumVer].Y,MinY);
		MaxY=max(Ver[NumVer].Y,MaxY);

		NumVer++;
		if (NumVer>=MAX_SIZE) {
			printf("Too many VERTEXES!\n");
			exit(2);
		}
	}
	fclose(fp);

	fp=fopen("LINEDEFS","rb");
	if (fp==NULL) {
		printf("Could not open LINEDEFS!\n");
		exit(1);
	}
	NumLine=0;
	while(1) {
		fread(&Line[NumLine],sizeof(struct LineDef),1,fp);
		if (feof(fp)) break;
		NumLine++;
		if (NumLine>=MAX_SIZE) {
			printf("Too many LINEDEFS!\n");
			exit(2);
		}
	}
	fclose(fp);

	fp=fopen("SIDEDEFS","rb");
	if (fp==NULL) {
		printf("Could not open SIDEDEFS!\n");
		exit(1);
	}
	NumSide=0;
	while(1) {
		fread(&Side[NumSide],sizeof(struct SideDef),1,fp);
		if (feof(fp)) break;
		NumSide++;
		if (NumSide>=MAX_SIZE) {
			printf("Too many SIDEDEFS!\n");
			exit(2);
		}
	}
	fclose(fp);

	fp=fopen("SECTORS","rb");
	if (fp==NULL) {
		printf("Could not open SECTORS!\n");
		exit(1);
	}
	NumSec=0;
	while(1) {
		fread(&Sec[NumSec],sizeof(struct Sector),1,fp);
		if (feof(fp)) break;
		NumSec++;
		if (NumSec>=MAX_SIZE) {
			printf("Too many SECTORS!\n");
			exit(2);
		}
	}
	fclose(fp);
}

int MakeXCoord(int old){
	int new;
	new=(old-MinX)<<1;
return(new); }

int MakeYCoord(int old){
	int new;
	new=(old-MinY)<<1;
return(new); }

int MakeFloor(int old){
	int new;
	new=old<<1;
return(new); }

void MakeTex(char *new, char *old){
	int i;
	char buf[16]={0,0,0,0,0,0,0,0, 0,0,0,0,0,0,0,0};

	strncpy(buf,old,8);
	strupr(buf);
        if (strcmp(buf,"-")==0)strcpy(buf,"NO_NAME");
        else if (strcmp(buf,"F_SKY1")==0) strcpy(buf,"NO_NAME");
        else {  for(i=0;i<NumTex;i++)if (strcmp(Tex[i],buf)==0) break;
		if (i==NumTex) {
			strcpy(Tex[NumTex],buf);
                        if (NumTex<MAX_SIZE-1) NumTex++;
                        }
	}
	strcpy(new,buf);
return; }

void TexList(char *name){
	int i;
	FILE *fp;

	fp=fopen(name,"wt");
	if (fp==NULL) {
		printf("Could not save TEX_LIST!\n");
		exit(1);
                }
        for(i=0;i<NumTex;i++) fprintf(fp,"%s\n",Tex[i]);
	fclose(fp);
return; }
