/*
 display Vpe zon
 By Rd
*/

#include <stdio.h>

#define MAXS 1000



char id[4];
char title[25];
int numpaths, numpoints,numregions, numwalls, numobjects, numviews;

//points
long p_x[MAXS],p_y[MAXS];
short p_link[MAXS];
//regions
long region_type[MAXS];
short region_floorh[MAXS];
short region_ceilh[MAXS];
short region_below[MAXS];
short region_above[MAXS];
char region_floor_tex[MAXS][10];
char region_ceil_tex[MAXS][10];
char emptystr[10];
//walls
long wall_type[MAXS];
short wall_p1[MAXS];
short wall_p2[MAXS];
short wall_r_front[MAXS];
short wall_r_back[MAXS];
char wall_top_tex[MAXS][10];
char wall_mid_tex[MAXS][10];
char wall_bot_tex[MAXS][10];
short wall_texx[MAXS];
short wall_texy[MAXS];

void read_zone(FILE *hnd);
void display_zone(){
 int a;
 printf("%s %s\n",id,title);
 printf("numpaths %d\nnumpoints %d\nnumregions %d\n",numpaths, numpoints,numregions);
 printf("numwalls %d\nnumobjects %d\nnumviews %d\n",numwalls, numobjects, numviews);
 printf("Points\n");
 for(a=0;a<numpoints;a++){
        printf("Point %d: x %ld : y %ld : link %d\n",a,p_x[a],p_y[a],p_link[a]);
                }
 printf("Regions\n");
 for(a=0;a<numregions;a++){
    printf("Region %d: Type %ld : ",a,region_type[a]);
    printf("FloorH %d : CeilH %d : ", region_floorh[a], region_ceilh[a]);
    printf("RegionB %d : RegionA %d : ", region_below[a], region_above[a]);
    printf("FloorT %s : CeilT %s\n", region_floor_tex[a], region_ceil_tex[a]);
  }
 printf("Walls\n");
 for(a=0;a<numwalls;a++){
    printf("Wall %d: Type %ld : ",a,wall_type[a]);
    printf("p1 %d : p2 %d : ",wall_p1[a],wall_p2[a]);
    printf("regionF %d : regionB %d : ",wall_r_front[a],wall_r_back[a]);
    printf("topTex %s : MidTex %s : BotTex %s : ",wall_top_tex[a],wall_mid_tex[a],wall_bot_tex[a]);
    printf("texX %d : TexY %d\n",wall_texx[a],wall_texy[a]);
  }

return; }

void main(int argc,char **argv){
 FILE *hnd;

 if(argc<2){printf("Usage: Zondis File.zon\n"); exit(-1); }
 hnd=fopen(argv[1],"rb");
 if(hnd==NULL){printf("Cannot open %s\n",argv[1]); exit(-1); }

 read_zone(hnd);
 display_zone();

 fclose(hnd);
return; }


#define PATH_LEN        32              // Number of path steps for a point


void read_str(FILE *hnd,char *str){
 int b;
    for(b=0;b<9;b++)str[b]=fgetc(hnd);
return; }
long  dword_read(FILE *hnd){
 long num=0;
 num=fgetc(hnd)+(0x100*fgetc(hnd))+(0x10000*fgetc(hnd))+(0x1000000*fgetc(hnd));
return num; }
short intword_read(FILE *hnd){
 short num=0;
 num=fgetc(hnd)+(0x100*fgetc(hnd));
return num; }


//reads a .ZON file (from vpe)
void read_zone(FILE *hnd){
 int a,b;

       for(a=0;a<4;a++) id[a]=fgetc(hnd);
       numpaths=intword_read(hnd);
       numpoints=intword_read(hnd);
       numregions=intword_read(hnd);
       numwalls=intword_read(hnd);
       numobjects=intword_read(hnd);
       numviews=intword_read(hnd);

       if(numpaths==0) goto SKIP_PATHS;
           for(a=0;a<numpaths;a++){//read and loose
              intword_read(hnd);
              intword_read(hnd);
              for(b=0;b<PATH_LEN;b++)intword_read(hnd);
              for(b=0;b<PATH_LEN;b++)intword_read(hnd);
              }
       SKIP_PATHS:

       if(numpoints==0) goto SKIP_POINTS;
        for(a=0;a<numpoints;a++){
           dword_read(hnd);//type
           p_x[a]=dword_read(hnd);
           p_y[a]=dword_read(hnd);
           intword_read(hnd);//path
           p_link[a]=intword_read(hnd);
        }
       SKIP_POINTS:

       if(numregions==0) goto SKIP_REGIONS;
        for(a=0;a<numregions;a++){
           region_type[a]=dword_read(hnd);
           region_floorh[a]=intword_read(hnd);
           region_ceilh[a]=intword_read(hnd);
           region_below[a]=intword_read(hnd);
           region_above[a]=intword_read(hnd);
           read_str(hnd,region_floor_tex[a]);
           read_str(hnd,region_ceil_tex[a]);
           read_str(hnd,emptystr);//eff$
           intword_read(hnd);//eff_parm
           intword_read(hnd);//tag
           }
       SKIP_REGIONS:

       if(numwalls==0) goto SKIP_WALLS;
        for(a=0;a<numwalls;a++){
           wall_type[a]=dword_read(hnd);
           wall_p1[a]=intword_read(hnd);
           wall_p2[a]=intword_read(hnd);
           wall_r_front[a]=intword_read(hnd);
           wall_r_back[a]=intword_read(hnd);
           read_str(hnd,wall_top_tex[a]);
           read_str(hnd,wall_mid_tex[a]);
           read_str(hnd,wall_bot_tex[a]);
           read_str(hnd,emptystr);//EFF$
           intword_read(hnd);//EFF_PARM=
           wall_texx[a]=intword_read(hnd);
           wall_texy[a]=intword_read(hnd);
           intword_read(hnd);//mass
           intword_read(hnd);//tag
          }
       SKIP_WALLS:


       if(numobjects==0) goto SKIP_OBJECTS;
        for(a=0;a<numobjects;a++){
           dword_read(hnd); //type
           intword_read(hnd);//P
           intword_read(hnd);//ANGLE
           intword_read(hnd);//H=
           intword_read(hnd);//RADIUS=
           intword_read(hnd);//HEIGHT=
           intword_read(hnd);//MASS=
           read_str(hnd,emptystr);//READ_STR$//TEX$
           read_str(hnd,emptystr);//EFF$
           intword_read(hnd);//EFF_PARM
              intword_read(hnd);//mspeed x
              intword_read(hnd);//mspeed y
              intword_read(hnd);//mspeed z
              intword_read(hnd);//mspeed t
              intword_read(hnd);//acc x
              intword_read(hnd);//acc y
              intword_read(hnd);//acc z
              intword_read(hnd);//acc t
              intword_read(hnd);//teg
        }
       SKIP_OBJECTS:

       if(numviews==0) goto SKIP_VIEWS;
        for(a=0;a<numviews;a++){        
              intword_read(hnd);//         OBJ=INTWORD_READ
              intword_read(hnd);//         VIS=INTWORD_READ
              intword_read(hnd);//         SCRX=INTWORD_READ
              intword_read(hnd);//         SCRY=INTWORD_READ
              intword_read(hnd);//         WIDTH=INTWORD_READ
              intword_read(hnd);//         HEIGHT=INTWORD_READ
              intword_read(hnd);//         HANGLE=INTWORD_READ
              intword_read(hnd);//         VANGLE=INTWORD_READ
              read_str(hnd,emptystr);//eff$
              intword_read(hnd);//         EFFPARM=INTWORD_READ
        }
       SKIP_VIEWS:

       //title
       for(b=0;b<24;b++)title[b]=fgetc(hnd);
return; }











