/*
 * Filter to extract comments from a 'C' source file
 *
 * Compile command: cc comext -fop
 */
#include <stdio.h>

int readch()
{
	int c;

	if((c = getc(stdin)) == EOF)
		exit(0);
	return c;
}

main()
{
	int c, c1;

	c = 0;		/* Fake a non-special character value to kick-start */
	for(;;) {
		switch(c) {
			case '/' :						/* Possible comment */
				if((c = readch()) != '*')
					continue;
				fputs("/*", stdout);
				c = 0;						/* Forget '*' */
				do {
					c1 = c;
					putc(c = readch(), stdout); }
				while((c1 != '*') || (c != '/'));
				putc('\n', stdout);
				break;
			case '"' :						/* Literal string */
			case '\'' :						/* Character constant */
				while((c1 = readch()) != c)
					if(c1 == '\\')
						readch(); }
		c = readch(); }
}
