/*
 * Number to text translator.
 *
 * Compile command: cc textnum -fop
 */
#include <stdio.h>

/*
 * Text tables and associated function to display an unsigned integer
 * value as a string of words. Note the use of recursion to display
 * the number of thousands and hundreds.
 */
void textnum(unsigned value)
{
	static char *digits[] = {	/* Table of single digits and teens */
		"Zero", "One", "Two", "Three", "Four", "Five", "Six",
		"Seven", "Eight", "Nine", "Ten", "Eleven", "Twelve",
		"Thirteen", "Fourteen", "Fifteen", "Sixteen",
		"Seventeen", "Eighteen", "Nineteen" };
	static char *tens[] = {		/* Table of tens prefix's */
		"Ten", "Twenty", "Thirty", "Fourty", "Fifty",
		"Sixty", "Seventy", "Eighty", "Ninety" };
	char join_flag;

	join_flag = 0;

	if(value >= 1000) {				/* Display thousands */
		textnum(value/1000);
		fputs(" Thousand", stdout);
		if(!(value %= 1000))
			return;
		join_flag = 1; }

	if(value >= 100) {				/* Display hundreds */
		if(join_flag)
			fputs(", ", stdout);
		textnum(value/100);
		fputs(" Hundred", stdout);
		if(!(value %= 100))
			return;
		join_flag = 1; }

	if(join_flag)					/* Separator if required */
		fputs(" and ", stdout);

	if(value > 19) {				/* Display tens */
		fputs(tens[(value/10)-1], stdout);
		if(!(value %= 10))
			return;
		putc(' ', stdout); }

	fputs(digits[value], stdout);	/* Display digits */
}

/*
 * Main program which processes all of its arguments, interpreting each
 * one as a numeric value, and displaying that value as english text.
 */
main(int argc, char *argv[])
{
	int i;

	if(argc < 2)					/* No arguments given */
		abort("\nUse: textnum <value*>\n");

	for(i=1; i < argc; ++i) {		/* Display all arguments */
		textnum(atoi(argv[i]));
		putc('\n', stdout); }
}
