.\" Converted with mdoc2man 0.2
.\" from NiH: zip_source_function.mdoc,v 1.13 2005/06/09 21:14:54 wiz Exp 
.\" $NiH: zip_source_function.mdoc,v 1.13 2005/06/09 21:14:54 wiz Exp $
.\"
.\" zip_source_function.mdoc \-- create data source from function
.\" Copyright (C) 2004, 2005 Dieter Baron and Thomas Klausner
.\"
.\" This file is part of libzip, a library to manipulate ZIP archives.
.\" The authors can be contacted at <nih@giga.or.at>
.\"
.\" Redistribution and use in source and binary forms, with or without
.\" modification, are permitted provided that the following conditions
.\" are met:
.\" 1. Redistributions of source code must retain the above copyright
.\"    notice, this list of conditions and the following disclaimer.
.\" 2. Redistributions in binary form must reproduce the above copyright
.\"    notice, this list of conditions and the following disclaimer in
.\"    the documentation and/or other materials provided with the
.\"    distribution.
.\" 3. The names of the authors may not be used to endorse or promote
.\"    products derived from this software without specific prior
.\"    written permission.
.\"
.\" THIS SOFTWARE IS PROVIDED BY THE AUTHORS ``AS IS'' AND ANY EXPRESS
.\" OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
.\" WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
.\" ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHORS BE LIABLE FOR ANY
.\" DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE
.\" GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
.\" INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
.\" IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
.\" OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN
.\" IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
.\"
.TH ZIP_SOURCE_FUNCTION 3 "December 22, 2004" NiH
.SH "NAME"
zip_source_function \- create data source from function
.SH "LIBRARY"
libzip (-lzip)
.SH "SYNOPSIS"
.In zip.h
.Ft int
.Fn zip_source_function "struct zip *archive" "zip_source_callback fn" "void *userdata"
.SH "DESCRIPTION"
The function
.Fn zip_source_function
creates a zip source from the user-provided function
\fBfn,\fR
which must be of the following type:
.Bd \-literal
typedef ssize_t (*zip_source_callback)(void *state,
    void *data, size_t len, enum zip_source_cmd cmd);
.Ed
.PP
When called by the library, the first argument is the
\fBstate\fR
argument supplied to
.Fn zip_source_function.
The next two arguments are a buffer
\fBdata\fR
of size
\fBlen\fR
when data is expected to be returned, or else
.Dv NULL
and 0.
The last argument,
\fBcmd,\fR
specifies which action the function should perform:
.RS
.TP 21
Dv ZIP_SOURCE_OPEN
Prepare for reading.
Return 0 on success, \-1 on error.
.TP 21
Dv ZIP_SOURCE_READ
Read data into the buffer
\fBdata\fR
of size
\fBlen.\fR
Return the number of bytes placed into
\fBdata\fR
on success, \-1 on error.
.TP 21
Dv ZIP_SOURCE_CLOSE
Reading is done.
.TP 21
Dv ZIP_SOURCE_STAT
Get meta information for the input data.
\fBdata\fR
points to a struct zip_stat, which should be filled in.
Return 0 on success, \-1 on error.
.TP 21
Dv ZIP_SOURCE_ERROR
Get error information.
\fBdata\fR
points to an array of two ints, which should be filled with the libzip
error code and the corresponding system error code for the error that
occurred.
See
zip_errors(3)
for details on the error codes.
Return 0.
.TP 21
Dv ZIP_SOURCE_FREE
Clean up and free all resources.
Return 0.
.RE
.PP
The library will always issue
.Dv ZIP_SOURCE_OPEN
before issuing
.Dv ZIP_SOURCE_READ.
When it no longer wishes to read from this source, it will issue
.Dv ZIP_SOURCE_CLOSE.
If the library wishes to read the data again, it will issue
.Dv ZIP_SOURCE_OPEN
a second time.
If the function is unable to provide the data again, it should
return \-1.
.PP
.Dv ZIP_SOURCE_STAT
can be issued at any time.
.Dv ZIP_SOURCE_ERROR
will only be issued in response to the function
returning \-1.
.Dv ZIP_SOURCE_FREE
will be the last command issued.
.SH "RETURN VALUES"
Upon successful completion, the created source is returned.
Otherwise,
.Dv NULL
is returned and the error code in
\fBarchive\fR
is set to indicate the error.
.SH "ERRORS"
.Fn zip_source_function
fails if:
.RS
.TP 4
Bq Er ZIP_ER_MEMORY
Required memory could not be allocated.
.RE
.SH "SEE ALSO"
libzip(3),
zip_add(3),
zip_replace(3),
zip_source_buffer(3),
zip_source_file(3),
zip_source_filep(3),
zip_source_free(3),
zip_source_zip(3)
.SH "AUTHORS"
-nosplit
Dieter Baron <dillo@giga.or.at>
and
Thomas Klausner <tk@giga.or.at>
