.*
.*
.option SYMFILE
.*
.np
The "SYMFILE" option provides a method for specifying an alternate
file for debugging information.
The format of the "SYMFILE" option (short form "SYMF") is as follows.
.mbigbox
    OPTION SYMFILE[=symbol_file]
.embigbox
.synote
.mnote symbol_file
is a file specification for the name of the symbol file.
If no file extension is specified, a file extension of "sym" is
assumed.
.esynote
.np
By default, no symbol file is generated; debugging information is
appended at the end of the executable file.
.ix 'symbol file'
Specifying this option causes the &lnkname to generate a symbol file.
The symbol file contains the debugging information generated by the
linker when the "DEBUG" directive is used.
The symbol file can then be used by &dbgname..
If no debugging information is requested, no symbol file is created,
regardless of the presence of the "SYMFILE" option.
.np
If no file name is specified, the symbol file will have a default file
extension of "sym" and the same path and file name as the executable
file.
Note that the symbol file will be placed in the same directory as the
executable file.
.np
Alternatively, a file name can be specified.
The following directive instructs the linker to generate a symbol
file and call it "myprog.sym" regardless of the name of the executable
file.
.millust begin
option symf=myprog
.millust end
.pc
You can also specify a path and/or file extension when using the
"SYMFILE=" form of the "SYMFILE" option.
.autonote Notes:
.note
This option should be used to debug a DOS "COM" executable file.
A DOS "COM" executable file must not contain any additional
information other than the executable information itself since DOS
uses the size of the file to determine what to load.
.note
This option should be used when creating a Microsoft Windows
executable file.
Typically, before an executable file can be executed as a Microsoft
Windows application, a resource compiler takes the Windows executable
file and a resource file as input and combines them.
If the executable file contains debugging information, the resource
compiler will strip the debugging information from the executable
file.
Therefore, debugging information must not be part of the executable
file created by the linker.
.endnote
