;*****************************************************************************
;*
;*                            Open Watcom Project
;*
;*    Portions Copyright (c) 1983-2002 Sybase, Inc. All Rights Reserved.
;*
;*  ========================================================================
;*
;*    This file contains Original Code and/or Modifications of Original
;*    Code as defined in and that are subject to the Sybase Open Watcom
;*    Public License version 1.0 (the 'License'). You may not use this file
;*    except in compliance with the License. BY USING THIS FILE YOU AGREE TO
;*    ALL TERMS AND CONDITIONS OF THE LICENSE. A copy of the License is
;*    provided with the Original Code and Modifications, and is also
;*    available at www.sybase.com/developer/opensource.
;*
;*    The Original Code and all software distributed under the License are
;*    distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
;*    EXPRESS OR IMPLIED, AND SYBASE AND ALL CONTRIBUTORS HEREBY DISCLAIM
;*    ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF
;*    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR
;*    NON-INFRINGEMENT. Please see the License for the specific language
;*    governing rights and limitations under the License.
;*
;*  ========================================================================
;*
;* Description:  WHEN YOU FIGURE OUT WHAT THIS FILE DOES, PLEASE
;*               DESCRIBE IT HERE!
;*
;*****************************************************************************


        modstart  386log

        xref    __FLDAC         ; add constant from stack
        xref    ___LDA          ; add
        xref    __FLDS          ; subtract
        xref    __FLDD          ; divide
        xref    ___LDD          ; divide
        xref    __FLDM          ; multiply
        xref    ___LDM          ; multiply
        xref    __I4LD          ; convert long to long double
        xref    __EvalPoly      ; evaluate polynomial
        xref    __poly          ; evaluate polynomial
        xref    __OddPoly       ; oddpoly

        xdefp   __log           ; calc log(fac1)
        xdefp   __fyl2x         ; calc. log2([eax]) * [edx]
        xdefp   __fyl2xp1       ; calc. log2([ax]+1.0) * [dx]

;;one_over_loge2 dt      1.4426950408889634075

        align   2
APoly   dt      -0.78956112887491257267
        dt       0.16383943563021534222e+2
        dt      -0.64124943423745581147e+2

BPoly   dt       1.0
        dt      -0.35667977739034646171e+2
        dt       0.31203222091924532844e+3
        dt      -0.76949932108494879777e+3


        defp    __fyl2xp1
        push    EBX             ; save EBX
        push    EDX             ; save address for result
        push    EAX             ; save address of operand
        push    ONE_EXP         ; point to 1.0
        push    ONE_HW          ; ...
        push    ONE_LW          ; ...
        mov     EBX,EAX         ; place for result
        call    __FLDAC         ; calc. x = x + 1.0
        pop     EAX             ; restore address of operand
        pop     EDX             ; restore address for result
        pop     EBX             ; restore EBX
;
;       fall into __fyl2x routine
;
__fyl2xp1 endp


        defp    __fyl2x
        push    EDI                     ; save registers
        push    ESI                     ; ...
        push    EDX                     ; ...
        push    ECX                     ; ...
        push    EBX                     ; ...
        push    EAX                     ; save address of operand
        call    __log                   ; calc. ln([eax])
        pop     EAX                     ; restore address of ln([eax])
        mov     EBX,EDX                 ; point to place for result
        push    EDX                     ; save address of result
        call    __FLDM                  ; multiply
        pop     EDI                     ; restore address of result
        mov     SI,8[EDI]               ; load x
        mov     ECX,4[EDI]              ; ...
        mov     EBX,[EDI]               ; ...
        shl     ESI,16                  ; shift exponent to top
        mov     SI,LN2R_EXP             ; load 1/loge(2)
        mov     EDX,LN2R_HW             ; ...
        mov     EAX,LN2R_LW             ; ...
        call    ___LDM                  ; calc x * 1/loge(2)
        mov     [EDI],EAX               ; store result
        mov     4[EDI],EDX              ; ...
        mov     8[EDI],SI               ; ...
        pop     EBX                     ; restore EBX
        pop     ECX                     ; restore ECX
        pop     EDX                     ; restore EDX
        pop     ESI                     ; restore ESI
        pop     EDI                     ; restore EDI
        ret                             ; return
__fyl2x endp



;;void __log( long double *x )
;;/**************************/
;;{
;;        int     exp;
;;        double  z;

;;    if( x <= 0.0 ) {
;;        x = _matherr( x == 0.0 ? SING : DOMAIN, "log", &x, &x, -HUGE_VAL );
;;    } else {

        defp    __log
        push    EDI                     ; save registers
        push    ESI                     ; ...
        push    EDX                     ; ...
        push    ECX                     ; ...
        push    EBX                     ; ...
        sub     ECX,ECX                 ; zero ECX
        mov     CX,8[EAX]               ; get exponent
        _guess                          ; guess: x > 0.0
          or    CX,CX                   ; - quit if negative
          _quif s                       ; - ...
          ; check for 0
        _admit                          ; admit: x <= 0.0
          ;                             ; - error
        _endguess                       ; endguess

;;        x = frexp( x, &exp );

        mov     EDI,EAX                 ; save address of argument
        mov     EDX,00003FFEh           ; set exponent
        sub     ECX,00003FFEh           ; ...
        push    ECX                     ; save exponent
        mov     8[EDI],DX               ; set exponent in the fraction

;;        z = x - .5;
        mov     EAX,[EDI]               ; load x
        mov     EDX,4[EDI]              ; ...
        mov     ESI,0BFFE3FFEh          ; and -.5
        mov     ECX,080000000h          ; ...
        sub     EBX,EBX                 ; ...
        call    ___LDA                  ; calc. z = x - .5

;;        if( x > sqrt_of_half ) {
        cmp     word ptr 8[EDI],3FFEh           ; if x > sqrt(.5)
        _if     e                               ; ...
          cmp   dword ptr 4[EDI],0B504F333h     ; ...
          _if   e                               ; ...
            cmp dword ptr [EDI],0F9DE6484h      ; ...
          _endif                                ; ...
        _endif                                  ; ...
        _if     a                               ; if x > sqrt(.5)
;;            z -= .5;
;;        } else {
;;            x = z;
;;            --exp;
;;        }
          and   ESI,00000FFFFh                  ; - load -.5
          or    ESI,0BFFE0000h                  ; - ...
          mov   ECX,80000000h                   ; - ...
          sub   EBX,EBX                         ; - ...
          call  ___LDA                          ; - calc z = z - .5
        _else                                   ; else
          mov   [EDI],EAX                       ; - set x = z
          mov   4[EDI],EDX                      ; - ...
          mov   8[EDI],SI                       ; - ...
          dec   dword ptr [ESP]                 ; - decrement exponent
        _endif                                  ; endif
        push    EAX                             ; save z
        push    EDX                             ; ...
        push    ESI                             ; ...
;;        z = z / (x * .5 + .5);
        mov     EAX,[EDI]                       ; load x
        mov     EDX,4[EDI]                      ; ...
        mov     SI,8[EDI]                       ; ...
        dec     SI                              ; multiply by .5
        and     ESI,0000FFFFh                   ; load .5
        or      ESI,3FFE0000h                   ; ...
        mov     ECX,080000000h                  ; ...
        sub     EBX,EBX                         ; ...
        call    ___LDA                          ; calc. x * .5 + .5
        shl     ESI,16                          ; move result to ESI:ECX:EBX
        mov     ECX,EDX                         ; ...
        mov     EBX,EAX                         ; ...
        pop     EAX                             ; restore z
        mov     SI,AX                           ; ...
        pop     EDX                             ; ...
        pop     EAX                             ; ...
        call    ___LDD                          ; calc. z = z / (x * .5 + .5)
        push    EAX                             ; save z
        push    EDX                             ; ...
        push    ESI                             ; ...

;;        x = z * z;
        mov     ECX,ESI                         ; duplicate z
        shl     ESI,16                          ; ...
        mov     SI,CX                           ; ...
        mov     ECX,EDX                         ; ...
        mov     EBX,EAX                         ; ...
        call    ___LDM                          ; calc. x = z * z
        mov     [EDI],EAX                       ; ...
        mov     4[EDI],EDX                      ; ...
        mov     8[EDI],SI                       ; ...

;;        x = z + z * x * _EvalPoly( x, APoly, 2 ) / _EvalPoly( x, BPoly, 3 );
        mov     EBX,3                           ; degree
        lea     ECX,BPoly                       ; polynomial
        call    __poly                          ; evaluate polynomial
        push    EAX                             ; save result
        push    EDX                             ; ...
        push    ESI                             ; ...
        mov     EAX,[EDI]                       ; load x
        mov     EDX,4[EDI]                      ; ...
        mov     SI,8[EDI]                       ; ...
        lea     ECX,APoly                       ; polynomial
        mov     EBX,2                           ; degree
        call    __poly                          ; evaluate polynomial
        pop     ECX                             ; load __poly(x,BPoly,3)
        rol     ESI,16                          ; ...
        mov     SI,CX                           ; ...
        rol     ESI,16                          ; ...
        pop     ECX                             ; ...
        pop     EBX                             ; ...
        call    ___LDD                          ; calc. APoly / BPoly
        mov     EBX,[EDI]                       ; load x
        mov     ECX,4[EDI]                      ; ...
        rol     ESI,16                          ; ...
        mov     SI,8[EDI]                       ; ...
        rol     ESI,16                          ; ...
        call    ___LDM                          ; calc. x * Apoly / BPoly
        rol     ESI,16                          ; load z
        mov     SI,[ESP]                        ; ...
        rol     ESI,16                          ; ...
        mov     ECX,4[ESP]                      ; ...
        mov     EBX,8[ESP]                      ; ...
        call    ___LDM                          ; calc. z * x * APoly / BPoly
        rol     ESI,16                          ; load z
        pop     ECX                             ; ...
        mov     SI,CX                           ; ...
        rol     ESI,16                          ; ...
        pop     ECX                             ; ...
        pop     EBX                             ; ...
        call    ___LDA                          ; calc. z + z * x * APoly/BPoly

;;        if( exp != 0 ) {
;;            z = exp;
;;            x = (z * C2 + x) + z * C1;
;;        }
        pop     ECX                             ; restore exponent
        or      ECX,ECX                         ; if not zero
        _if     ne                              ; then
          push  EAX                             ; - save x
          push  EDX                             ; - ...
          push  ESI                             ; - ...
          mov   EDX,EDI                         ; - convert exponent to LD
          mov   EAX,ECX                         ; - ...
          call  __I4LD                          ; - ...
          mov   EAX,[EDI]                       ; - load z
          mov   EDX,4[EDI]                      ; - ...
          mov   SI,8[EDI]                       ; - ...
          and   ESI,0000FFFFh                   ; - load C2
          or    ESI,0BFF20000h                  ; - ...
          mov   ECX,0DE8082E3h                  ; - ...
          mov   EBX,00865435Ch                  ; - ...
          call  ___LDM                          ; - calc. z * C2
          pop   ECX                             ; - load x
          rol   ESI,16                          ; - ...
          mov   SI,CX                           ; - ...
          rol   ESI,16                          ; - ...
          pop   ECX                             ; - ...
          pop   EBX                             ; - ...
          call  ___LDA                          ; - calc. z * C2 + x
          push  EAX                             ; - save (z * C2 + x)
          push  EDX                             ; - ...
          push  ESI                             ; - ...
          mov   EAX,[EDI]                       ; - load z
          mov   EDX,4[EDI]                      ; - ...
          mov   SI,8[EDI]                       ; - ...
          and   ESI,0000FFFFh                   ; - load C1 (355./512.)
          or    ESI,3FFE0000h                   ; - ...
          mov   ECX,0B1800000h                  ; - ...
          sub   EBX,EBX                         ; - ...
          call  ___LDM                          ; - calc. z * C1
          pop   ECX                             ; - load (z * C2 + x)
          rol   ESI,16                          ; - ...
          mov   SI,CX                           ; - ...
          rol   ESI,16                          ; - ...
          pop   ECX                             ; - ...
          pop   EBX                             ; - ...
          call  ___LDA                          ; - calc. (z * C2 + x) + z * C1
        _endif                                  ; endif
        mov     [EDI],EAX                       ; save in x
        mov     4[EDI],EDX                      ; ...
        mov     8[EDI],SI                       ; ...

;;    }
;;    return( x );
;;}

        pop     EBX                     ; restore registers
        pop     ECX                     ; ...
        pop     EDX                     ; ...
        pop     ESI                     ; ...
        pop     EDI                     ; ...
        ret                             ; return
__log   endp

