
        modstart e86i8ld

        xdefp   __I8LD

;       __I8LD - convert 64-bit integer into long double
;
__I8LD  proc    near
        push    DI              ; save DI
        mov     DI,403Eh        ; get exponent and sign
        or      CX,CX           ; if number is negative
        _if     s               ; then
          not   CX              ; - negate the value
          not   BX              ; - ...
          not   DX              ; - ...
          neg   AX              ; - ...
          sbb   DX,-1           ; - ...
          sbb   BX,-1           ; - ...
          sbb   CX,-1           ; - ...
          or    DI,8000h        ; - turn on sign bit
        _endif                  ; endif
        or      CX,CX           ; if high order word is 0
        _if     e               ; then
          sub   DI,16           ; - adjust exponent
          or    CX,BX           ; - shift operand left 16 bits
          mov   BX,DX           ; - ...
          mov   DX,AX           ; - ...
          mov   AX,0            ; - ...
          _if   e               ; - if next word was also 0
            sub   DI,16         ; - - adjust exponent
            or    CX,BX         ; - - shift operand left 16 bits again
            mov   BX,DX         ; - - ...
            mov   DX,AX         ; - - ...
            _if   e             ; - - if next word was also 0
              sub   DI,16       ; - - - adjust exponent
              or    CX,BX       ; - - - shift operand left 16 bits again
              mov   BX,DX       ; - - - ...
              _if   e           ; - - - if last word was also 0
                mov   DI,AX     ; - - - - set exponent to 0
                jmp   short donei8ld; - - - - and get out
              _endif            ; - - - endif
            _endif              ; - - endif
          _endif                ; - endif
        _endif                  ; endif
        cmp     CH,0            ; if high order byte is 0
        _if     e               ; then
          sub   DI,8            ; - adjust exponent
          or    CH,CL           ; - shift up 8 bits
          mov   CL,BH           ; - ...
          mov   BH,BL           ; - ...
          mov   BL,DH           ; - ...
          mov   DH,DL           ; - ...
          mov   DL,AH           ; - ...
          mov   AH,AL           ; - ...
          mov   AL,0            ; - ...
        _endif                  ; endif
        _if   ns                ; if not already normalized
          _loop                 ; - loop (normalize result)
            dec   DI            ; - - decrement exponent
            _shl  AX,1          ; - - shift left 1 bit
            _rcl  DX,1          ; - - ...
            _rcl  BX,1          ; - - ...
            _rcl  CX,1          ; - - ...
          _until  s             ; - until normalized
        _endif                  ; endif
donei8ld:mov    8[SI],DI        ; store exponent
        mov     6[SI],CX        ; fraction
        mov     4[SI],BX        ; ...
        mov     2[SI],DX        ; ...
        mov     [SI],AX         ; ...
        pop     DI              ; restore DI
        ret                     ; return
__I8LD  endp

