/****************************************************************************
*
*                            Open Watcom Project
*
*    Portions Copyright (c) 1983-2002 Sybase, Inc. All Rights Reserved.
*
*  ========================================================================
*
*    This file contains Original Code and/or Modifications of Original
*    Code as defined in and that are subject to the Sybase Open Watcom
*    Public License version 1.0 (the 'License'). You may not use this file
*    except in compliance with the License. BY USING THIS FILE YOU AGREE TO
*    ALL TERMS AND CONDITIONS OF THE LICENSE. A copy of the License is
*    provided with the Original Code and Modifications, and is also
*    available at www.sybase.com/developer/opensource.
*
*    The Original Code and all software distributed under the License are
*    distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
*    EXPRESS OR IMPLIED, AND SYBASE AND ALL CONTRIBUTORS HEREBY DISCLAIM
*    ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF
*    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR
*    NON-INFRINGEMENT. Please see the License for the specific language
*    governing rights and limitations under the License.
*
*  ========================================================================
*
* Description:  WHEN YOU FIGURE OUT WHAT THIS FILE DOES, PLEASE
*               DESCRIBE IT HERE!
*
****************************************************************************/


#include    <dos.h>
#include    <stdlib.h>
#include    <string.h>
#include    "uidef.h"
#include    "charmap.h"
#include    "uigchar.h"

static char UiMapChar[] = {
    0xC6,       /* UI_RADIO_LEFT        */
    0xEA,       /* UI_RADIO_RIGHT       */
    0xC7,       /* UI_RADIO_FULL        */
    0xD0,       /* UI_RADIO_EMPTY       */
    0xD1,       /* UI_CHECKBOX_LEFT     */
    0xEB,       /* UI_CHECKBOX_RIGHT    */
    0xD2,       /* UI_CHECKBOX_FULL     */
    0xD3,       /* UI_CHECKBOX_EMPTY    */
    0xD4,       /* UI_BOX_TOP_LEFT      */
    0xCB,       /* UI_BOX_TOP_RIGHT     */
    0xCA,       /* UI_BOX_BOTTOM_RIGHT  */
    0xDE,       /* UI_BOX_BOTTOM_LEFT   */
    0xCC,       /* UI_BOX_TOP_LINE      */
    0xBA,       /* UI_BOX_RIGHT_LINE    */
    0xCE,       /* UI_BOX_BOTTOM_LINE   */
    0xCF,       /* UI_BOX_LEFT_LINE     */
    0xDF,       /* UI_SHADOW_BOTTOM     */
    0xDC,       /* UI_SHADOW_B_LEFT     */
    0xFD,       /* UI_SHADOW_RIGHT      */
    0xF5,       /* UI_SHADOW_B_RIGHT    */
    0x00
};

static unsigned char MappingData[][16] = {
    {   0x00,0x00,0x01,0x02,0x02,0x04,0x04,0x04,
        0x04,0x02,0x02,0x01,0x00,0x00,0x00,0x00     },  // Radio Left
    {   0x00,0x00,0x00,0x80,0x80,0x40,0x40,0x40,
        0x40,0x80,0x80,0x00,0x00,0x00,0x00,0x00     },  // Radio Right
    {   0x00,0xfe,0x01,0x00,0x7c,0xfe,0xfe,0xfe,
        0xfe,0x7c,0x00,0x01,0xfe,0x00,0x00,0x00     },  // Radio Full
    {   0x00,0xfe,0x01,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x01,0xfe,0x00,0x00,0x00     },  // Radio Empty
    {   0x00,0x07,0x04,0x04,0x04,0x04,0x04,0x04,
        0x04,0x04,0x04,0x04,0x07,0x00,0x00,0x00     },  // Checkbox Left
    {   0x00,0xc0,0x40,0x40,0x40,0x40,0x40,0x40,
        0x40,0x40,0x40,0x40,0xc0,0x00,0x00,0x00     },  // Checkbox Right
    {   0x00,0xff,0x00,0xc6,0xee,0x7c,0x38,0x38,
        0x7c,0xee,0xc6,0x00,0xff,0x00,0x00,0x00     },  // Checkbox Full
    {   0x00,0xff,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0xff,0x00,0x00,0x00     },  // Checkbox Empty
   {    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00     },  // Top Left Corner
   {    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00     },  // Top Right Corner
    {   0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,
        0xf0,0xf0,0xf0,0x00,0x00,0x00,0x00,0x00     },  // Bottom Right Corner
    {   0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,
        0x07,0x07,0x07,0x00,0x00,0x00,0x00,0x00     },  // Bottom Left Corner
    {   0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00     },  // Top Line
    {   0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,
        0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0     },  // Right Line
    {   0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
        0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00     },  // Bottom Line
    {   0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,
        0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07     },  // Left Line
    {   0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00     },  // Shadow Bottom
    {   0x3f,0x3f,0x3f,0x3f,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00     },  // Shadow Bottom Left
    {   0x00,0x00,0x00,0xe0,0xe0,0xe0,0xe0,0xe0,
        0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0,0xe0     },  // Shadow Right
    {   0xe0,0xe0,0xe0,0xe0,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00     }   // Shadow Bottom Right
};

static void MapCharacter( char ch, unsigned char data[16] )
{
    unsigned short              s,  points;
    int                         j;
    unsigned char               temp;

    points = _POINTS;

    s = ch * 32;

    for( j = 0; j < points; j++ ) {
        temp = _peekb( 0xA000, s );
        _pokeb( 0xA000, s++, data[j] );
        data[j] = temp;
    }
}

bool UIMapCharacters( char mapchar[], char mapdata[][16] )
{
    int         i;

    if( ( UIData->colour == M_EGA || UIData->colour == M_VGA )
                && !UIData->desqview
                && !UIData->no_graphics
                && UIData->height == 25 ) {
        SetSequencer();
        SetWriteMap();

        for( i = 0; mapchar[i] != '\0'; i++ ) {
            MapCharacter( mapchar[i], mapdata[i] );
        }
        ResetSequencer();
        return( TRUE );
    }
    return( FALSE );
}

bool FlipCharacterMap()
{
    ATTR        old;
    ATTR        new;

    if( UIMapCharacters( UiMapChar, MappingData ) ) {
        memcpy( UiGChar, UiMapChar, sizeof( UiMapChar ) - 1 );
        /* swap fore and back color for Dialog attr so you get nice title */
        old = UIData->attrs[ATTR_DIAL_FRAME];
        new = 0;
        new |= ( old >> 4 ) & 0x0f;
        new |= ( old << 4 ) & 0xf0;
        UIData->attrs[ATTR_DIAL_FRAME] = new;
        return( TRUE );
    }
    return( FALSE );
}
