.chap *refid=vidprep Preparing a Program to be Debugged
.*
.np
.ix 'debugging' 'preparing application for'
.ix 'program' 'preparing for debugging'
Before you can debug a program, you must put
.us debugging information
into the code.
.np
There are three different formats of debugging information that can be
put into the code &mdash. "Watcom", "DWARF" or "CodeView".
Starting with version 11.0 (and continuing in the &company 1.0 and later
compilers), the default format is "DWARF". In earlier releases, the
default was "Watcom". Although the debugger supports all three formats,
it is best if you allow the default format to be generated.
.np
To produce an executable that has debugging
information, you need to:
.autopoint
.point
specify the correct compiler options when you compile, and
.point
specify the correct linker options when you link.
.endpoint
.np
During development, use the
.us d2
option of the compiler and use the
.us debug all
directive at the beginning of your linker command line or at the
beginning of your linker directive file.
This will ensure that maximum debugging information is available
during your debugging session.
Change to the
.us d1
option when you need to create a distribution version of your product.
This is necessary since the
.us d2
option disables most compiler optimizations, whereas
.us d1
will not affect the quality of generated code.
During production, you can use the linker's
.us symfile
option to put the
.us d1
debugging information into a separate file.  This
lets you distribute a production quality executable yet still
have the luxury of source line debugging when bugs are reported.
.*
.section Compiler Debugging Options
.*
.ix 'debug compiler options'
.begnote
.note d0
The
.us d0
option will generate no debugging information. This is the default
option.
.note d1
The
.us d1
option will generate debugging information for global symbols and
line numbers.
.note d1+
The
.us d1+
option will generate debugging information for global symbols and
line numbers, and typing information for local structs and arrays.
.note d2
The
.us d2
option will generate the most debugging information
that is normally needed,
including global information, line numbers, types, and local
variables.
.note d2i
The
.us d2i
option is identical to
.us d2
but does not permit inlining of functions.
This option can result in larger object and/or executable files
(we are discussing both "code" and "file" size here).
.note d2t
The
.us d2t
option is identical to
.us d2
but does not include type name debugging information.
This option can result in smaller object and/or executable files (we
are discussing "file" size here).
.note d3
The
.us d3
option will generate all debugging information generated by
.us d2.
In addition, it will generate information about all types defined
in a compilation unit, regardless of whether they are used
in that compilation unit.
.bi This option will create very large objects and executable files. Do
.bi not use it unless you want to have access to types that have
.bi no variables associated with them.
.endnote
.*
.section Linker Debugging Options
.*
.np
.ix 'debug linker options'
The linker is the tool that puts together a complete program and sets
up the debugging information for all the modules in the executable
file. There is a linker directive that tells the linker when it should
include debugging information from the modules.
.np
The directive you should use in the general case is:
.begnote
.note DEBUG ALL
.endnote
.np
This directive will include all debugging information in the default
format. You should always use this directive except in the rare cases
when you need debugging information in a format other than the default.
.np
For "DWARF" format debugging information, the directive is:
.begnote
.note DEBUG DWARF
.endnote
.np
For "Watcom" format debugging information, there are two levels of
debugging information that you should collect during the link. They
are:
.begnote
.note DEBUG WATCOM LINES
global names, source line numbers
.note DEBUG WATCOM ALL
global names, source line numbers, local variables, typing information
.endnote
.np
Linker DEBUG directives are position dependent so you must make sure
that the directive
.us precedes
the object files and libraries that require debugging information.
.np
For instance, if the file "mylink.lnk" contained:
.millust begin
#
# invoke with: wlink @mylink
#
file main
debug watcom lines
file input, output
debug watcom all
file process
.millust end
.pc
then the files
.us input
and
.us output
will have global names and source line information available during
debugging. All debugging information in the file
.us process
is available during debugging.
No information is available for
.us main
except global names.
.np
If you use a DEBUG directive anywhere, all files, including
.us main,
will have global name information.
.*
.section Debugger Settings
.*
.np
.ix 'source code' 'locating'
.ix 'locating source code'
.ix 'settings'
You may encounter problems if the debugger does not know where to find
the source code associated with your executable. The name of the
source file included in the debugging information is the path and the
original name from the compiler's command line. If the original
filename is no longer valid (i.e., you have moved the source to another
directory), you must tell the debugger where to find the source files
by choosing
.menuref 'Source Path' 'File'
.dot
