;*****************************************************************************
;*
;*                            Open Watcom Project
;*
;*    Portions Copyright (c) 1983-2002 Sybase, Inc. All Rights Reserved.
;*
;*  ========================================================================
;*
;*    This file contains Original Code and/or Modifications of Original
;*    Code as defined in and that are subject to the Sybase Open Watcom
;*    Public License version 1.0 (the 'License'). You may not use this file
;*    except in compliance with the License. BY USING THIS FILE YOU AGREE TO
;*    ALL TERMS AND CONDITIONS OF THE LICENSE. A copy of the License is
;*    provided with the Original Code and Modifications, and is also
;*    available at www.sybase.com/developer/opensource.
;*
;*    The Original Code and all software distributed under the License are
;*    distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
;*    EXPRESS OR IMPLIED, AND SYBASE AND ALL CONTRIBUTORS HEREBY DISCLAIM
;*    ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF
;*    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR
;*    NON-INFRINGEMENT. Please see the License for the specific language
;*    governing rights and limitations under the License.
;*
;*  ========================================================================
;*
;* Description:  WHEN YOU FIGURE OUT WHAT THIS FILE DOES, PLEASE
;*               DESCRIBE IT HERE!
;*
;*****************************************************************************


;;
;; CORTNS       : i/o co-routines (common to READ and WRITE)
;;

.8087

include ptypes.inc
include struct.inc
include mdef.inc

        modstart cortns, byte

        dataseg
        assume  ES:DGROUP

        xred    "C",IORslt,      word
        xred    "C",_STACKLOW,   word

; for all 16-bit systems we now use a 4K coroutine stack
COSTACK_SIZE = 4096

; we also need our normal stack to be minimum 4K
F77_STACK_SIZE = 4096

STACK   SEGMENT STACK BYTE 'STACK'
ifdef __OS2__
other_stack_low label   word
endif
        db      F77_STACK_SIZE dup(?)
        db      COSTACK_SIZE dup(?)
STACK   ENDS

CoStack dw      COSTACK_SIZE
SaveSP  dw      ?
SaveSS  dw      ?
RetAddr dw      2 dup(?)
SaveReg dw      6 dup(?)
SaveSeg dw      2 dup(?)
IORtn   dw      2 dup(?)
ifdef __OS2__
InitStackLow dw 0
endif
ifdef __WINDOWS__
SaveAX  dw      ?
BPLink  dw      ?
endif

        enddata


        defp    Switch                  ; switch back to generated code
ifdef __WINDOWS__
        inc     BP                      ; set up Windows BP-chain
        push    BP                      ; ...
        mov     BP,SP                   ; ...
else
        xdefp   IOSwitch
IOSwitch:
        push    BP                      ; save current registers
endif
        push    BX                      ; ...
        push    CX                      ; ...
        push    DX                      ; ...
        push    DI                      ; ...
        push    SI                      ; ...
        push    DS                      ; ...
        push    ES                      ; ...
        mov     BX,DGROUP               ; get segment address of DGROUP
        mov     ES,BX                   ; ...
        mov     ES:SaveSS,SS            ; switch stacks
        mov     SS,BX                   ; ...
        xchg    ES:SaveSP,SP            ; ...
        pop     ES                      ; restore previous registers
        pop     DS                      ; ...
        pop     SI                      ; ...
        pop     DI                      ; ...
        pop     DX                      ; ...
        pop     CX                      ; ...
        pop     BX                      ; ...
ifdef __WINDOWS__
        mov     SaveAX,AX               ; save return value
        inc     BP                      ; fix up Windows BP-chain
        mov     AX,BP                   ; ...
        pop     BP                      ; ...
        dec     BP                      ; ...
        push    BX                      ; ...
        mov     BX,BPLink               ; ...
        xchg    [BX],AX                 ; ...
        mov     BX,_STACKLOW            ; ...
        add     BX,CoStack              ; ...
        add     BX,1                    ; ...
        and     BX,0FFFEh               ; ...
        lea     BX,-6[BX]               ; ...
        mov     SS:[BX],AX              ; ...
        pop     BX                      ; ...
        mov     AX,SaveAX               ; restore return value
else
        pop     BP                      ; ...
endif
        ret                             ; return to generated code
        endproc Switch


ifdef __WINDOWS__
        xdefp   IOSwitch                ; switch back to i/o system
        defp    IOSwitch
        inc     BP                      ; set up Windows BP-chain
        push    BP                      ; ...
        mov     BP,SP                   ; ...
        push    BX                      ; save registers
        push    CX                      ; ...
        push    DX                      ; ...
        push    DI                      ; ...
        push    SI                      ; ...
        push    DS                      ; ...
        push    ES                      ; ...
        mov     BX,DGROUP               ; get segment address of DGROUP
        mov     ES,BX                   ; ...
        mov     BX,ES:SaveSS            ; switch stacks
        mov     ES:SaveSS,SS            ; ...
        mov     SS,BX                   ; ...
        xchg    ES:SaveSP,SP            ; ...
        pop     ES                      ; restore previous registers
        pop     DS                      ; ...
        pop     SI                      ; ...
        pop     DI                      ; ...
        pop     DX                      ; ...
        pop     CX                      ; ... (except BX)
        mov     SaveAX,AX               ; save return value
        mov     AX,BP                   ; fix up Windows BP-chain
        inc     AX                      ; ...
        mov     BX,_STACKLOW            ; ...
        add     BX,CoStack              ; ...
        add     BX,1                    ; ...
        and     BX,0FFFEh               ; ...
        lea     BX,-6[BX]               ; ...
        xchg    SS:[BX],AX              ; ...
        pop     BX                      ; now restore BX
        mov     BP,[BP]                 ; ...
        dec     BP                      ; ...
        cmp     BP,BPLink               ; get BP link to generated code
        _if     ne                      ; if array i/o, its next link
          mov   BP,[BP]                 ; ...
          dec   BP                      ; ...
        _endif                          ; ...
        mov     [BP],AX                 ; ...
        pop     BP                      ; ...
        dec     BP                      ; ...
        mov     AX,SaveAX               ; restore return value
        ret                             ; return to run-time system
        endproc IOSwitch
endif

FRAME_SIZE      = (8*2+4)       ; define stack frame to discard when restoring
                                ; state (8 registers and return address)

        xdefp   RdWrCommon
        defp    RdWrCommon
        ; on entry address of i/o routine is on stack
        push    BP                      ; get stack addressability
        mov     BP,SP                   ; ...
        push    ES                      ; save ES
        mov     AX,DGROUP               ; get segment address of DGROUP
        mov     ES,AX                   ; ...
ifdef __OS2__
        cmp     es:InitStackLow,0       ; check to see if we need to adjust _STACKLOW
        _if     e                       ; if already done then no needto do so again
          mov   ax,offset DGROUP:other_stack_low        ; compare our low stack offset to _STACKLOW
          cmp   ax,es:_STACKLOW         ; and pick the lesser of the two
          _if   b                       ; ...
            mov es:_STACKLOW, ax        ; ...
          _endif                        ; ...
          mov   es:InitStackLow, 1      ; So we don't need to check it again.
        _endif
endif
        mov     AX,2[BP]                ; save address of i/o routine
        mov     ES:IORtn,AX             ; ...
        mov     AX,4[BP]                ; ...
        mov     ES:IORtn+2,AX           ; ...
        mov     ES:SaveReg,BX           ; save state
        mov     ES:SaveReg+2,CX         ; ... (in case ERR= or END=)
        mov     ES:SaveReg+4,DX         ; ...
        mov     ES:SaveReg+6,DI         ; ...
        mov     ES:SaveReg+8,SI         ; ...
        mov     AX,0[BP]                ; ... (original BP if on the stack)
        mov     ES:SaveReg+10,AX        ; ...
        mov     ES:SaveSeg,DS           ; ...
        mov     AX,-2[BP]               ; ... (original ES if on the stack)
        mov     ES:SaveSeg+2,AX         ; ...
        mov     AX,6[BP]                ; save return address
        mov     ES:RetAddr,AX           ; ...
        mov     AX,8[BP]                ; ...
        mov     ES:RetAddr+2,AX         ; ...
        pop     ES                      ; restore ES
        pop     BP                      ; restore BP
        add     SP,4                    ; remove address of i/o routine
ifdef __WINDOWS__
        mov     BPLink,BP               ; set up Windows BP-chain
        inc     BP                      ; ...
        push    BP                      ; ...
        mov     BP,SP                   ; ...
else
        push    BP                      ; save CG registers
endif
        push    BX                      ; ...
        push    CX                      ; ...
        push    DX                      ; ...
        push    DI                      ; ...
        push    SI                      ; ...
        push    DS                      ; ...
        push    ES                      ; ...
        mov     BX,DGROUP               ; get segment address of DGROUP
        mov     ES,BX                   ; ...
        mov     ES:SaveSP,SP            ; save stack pointer of executing code
        mov     ES:SaveSS,SS            ; ...
        mov     AX,ES:_STACKLOW         ; point to new stack
        add     AX,ES:CoStack           ; ...
        add     AX,1                    ; ...
        and     AX,0FFFEh               ; ...
        mov     SS,BX                   ; ...
        mov     SP,AX                   ; ...
        call    dword ptr ES:IORtn      ; start i/o operation
        test    AX,AX                   ; check if i/o error
        je      ExitCoRtns              ; return to generated code
        mov     BX,DGROUP               ; get segment address of DGROUP
        mov     ES,BX                   ; ...
        mov     BX,ES:SaveSS            ; switch stacks
        mov     ES:SaveSS,SS            ; ...
        mov     SS,BX                   ; ...
        xchg    ES:SaveSP,SP            ; ...
        add     SP,FRAME_SIZE           ; discard previous registers
        mov     BX,ES:SaveReg           ; restore state
        mov     CX,ES:SaveReg+2         ; (in case ERR= or END=)
        mov     DX,ES:SaveReg+4         ; ...
        mov     DI,ES:SaveReg+6         ; ...
        mov     SI,ES:SaveReg+8         ; ...
        mov     BP,ES:SaveReg+10        ; ...
        mov     DS,ES:SaveSeg           ; ...
        push    ES:RetAddr+2            ; get return address
        push    ES:RetAddr              ; get return address
        mov     ES,ES:SaveSeg+2         ; ...
        ret                             ; return
        endproc RdWrCommon


        defp    ExitCoRtns              ; switch back to generated code
        mov     BX,DGROUP               ; get segment address of DGROUP
        mov     ES,BX                   ; ...
        mov     BX,ES:SaveSS            ; switch stacks
        mov     ES:SaveSS,SS            ; ...
        mov     SS,BX                   ; ...
        xchg    ES:SaveSP,SP            ; ...
        pop     ES                      ; restore previous registers
        pop     DS                      ; ...
        pop     SI                      ; ...
        pop     DI                      ; ...
        pop     DX                      ; ...
        pop     CX                      ; ...
        pop     BX                      ; ...
ifdef __WINDOWS__
        pop     BP                      ; ...
        dec     BP                      ; ...
else
        pop     BP                      ; ...
endif
        ret                             ; return to generated code
        endproc ExitCoRtns


        xdefp   "C",IOType
        defp    IOType
        sub     AX,AX                   ; indicate i/o operation succeeded
        jmp     Switch                  ; return to generated code
        endproc IOType


        xdefp   IOChar
        defn    IOChar                  ; i/o for CHARACTER*n value
if _MODEL and _BIG_DATA
        push    DS                      ; save DS
        mov     DS,DX                   ; set DS to segment of SCB
endif
        push    SI                      ; save SI
        mov     SI,AX                   ; set SI to address of SCB
        push    ES                      ; save ES
        mov     AX,DGROUP               ; get segment address of DGROUP
        mov     ES,AX                   ; ...
        lodsw                           ; put SCB in IORslt
        mov     ES:IORslt,AX            ; ...
        lodsw                           ; ...
        mov     ES:IORslt+2,AX          ; ...
if _MODEL and _BIG_DATA
        lodsw                           ; ...
        mov     ES:IORslt+4,AX          ; ...
endif
        mov     AX,PT_CHAR              ; return CHARACTER*n type
        pop     ES                      ; restore ES
        pop     SI                      ; restore SI
if _MODEL and _BIG_DATA
        pop     DS                      ; restore DS
endif
        jmp     IOSwitch                ; return to caller of IOType()
        endproc IOChar


        xdefp   IOStr
        defn    IOStr                   ; i/o for CHARACTER*n value
        push    DI                      ; save DI
        push    ES                      ; save ES
        mov     DI,DGROUP               ; get segment address of DGROUP
        mov     ES,DI                   ; ...
        mov     ES:IORslt,AX            ; put SCB in IORslt
if _MODEL and _BIG_DATA
        mov     ES:IORslt+2,DX          ; ...
        mov     ES:IORslt+4,BX          ; ...
else
        mov     ES:IORslt+2,DX          ; ...
endif
        mov     AX,PT_CHAR              ; return CHARACTER*n type
        pop     ES                      ; restore ES
        pop     DI                      ; restore DI
        jmp     IOSwitch                ; return to caller of IOType()
        endproc IOStr

        xdefp   IOArr
        defn    IOArr                   ; put array descriptor in IORslt
        push    DI                      ; save DI
        push    ES                      ; save ES
        mov     DI,DGROUP               ; get segment address of DGROUP
        mov     ES,DI                   ; ...
                                        ; put array descriptor in IORslt
        mov     ES:IORslt,AX            ; ... data pointer
if _MODEL and _BIG_DATA
        mov     ES:IORslt+2,DX          ; ...
        mov     ES:IORslt+4,BX          ; ... number of elements
        mov     ES:IORslt+6,CX          ; ...
        mov     DI,SP                   ; ... type of array
        mov     DL,SS:8[DI]             ; ...
        mov     AX,SS:6[DI]             ; get rid of stacked argument by
        mov     SS:8[DI],AX             ; ... moving the return address up
        mov     AX,SS:4[DI]             ; ... the stack
        mov     SS:6[DI],AX             ; ...
        mov     byte ptr ES:IORslt+10,DL; ...
else
        mov     ES:IORslt+2,BX          ; ... number of elements
        mov     ES:IORslt+4,CX          ; ...
        mov     byte ptr ES:IORslt+8,DL ; ...
endif
        pop     ES                      ; restore ES
        pop     DI                      ; restore DI
if _MODEL and _BIG_DATA
        add     SP,2                    ; adjust stack for stacked argument
endif
        mov     AX,PT_ARRAY             ; return ARRAY type
        jmp     IOSwitch                ; return to caller of IOType()
        endproc IOArr


        xdefp   IOChArr
        defn    IOChArr                 ; put array descriptor in IORslt
        push    DI                      ; save DI
        push    ES                      ; save ES
        mov     DI,DGROUP               ; get segment address of DGROUP
        mov     ES,DI                   ; ...
                                        ; put array descriptor in IORslt
        mov     ES:IORslt,AX            ; ... data pointer
if _MODEL and _BIG_DATA
        mov     ES:IORslt+2,DX          ; ...
        mov     ES:IORslt+4,BX          ; ... number of elements
        mov     ES:IORslt+6,CX          ; ...
        mov     DI,SP                   ; ... element size
        mov     DX,SS:8[DI]             ; ...
        mov     ES:IORslt+8,DX          ; ...
        mov     AL,PT_CHAR              ; ... type of array
        mov     byte ptr ES:IORslt+10,AL;...
        mov     AX,SS:6[DI]             ; get rid of stacked argument by
        mov     SS:8[DI],AX             ; ... moving the return address up
        mov     AX,SS:4[DI]             ; ... the stack
        mov     SS:6[DI],AX             ; ...
else
        mov     ES:IORslt+2,BX          ; ... number of elements
        mov     ES:IORslt+4,CX          ; ...
        mov     ES:IORslt+6,DX          ; ... element size
        mov     AL,PT_CHAR              ; ... type of array
        mov     byte ptr ES:IORslt+8,AL ; ...
endif
        mov     AX,PT_ARRAY             ; return ARRAY type
        pop     ES                      ; restore ES
        pop     DI                      ; restore DI
if _MODEL and _BIG_DATA
        add     SP,2                    ; adjust stack for stacked argument
endif
        jmp     IOSwitch                ; return to caller of IOType()
        endproc IOChArr


        xdefp   RT@EndIO
        defp    RT@EndIO
        mov     AX,PT_NOTYPE            ; return "no i/o items remaining"
        jmp     IOSwitch                ; return to caller of IOType()
        endproc RT@EndIO

        endmod
        end
