/****************************************************************************
*
*                            Open Watcom Project
*
*    Portions Copyright (c) 1983-2002 Sybase, Inc. All Rights Reserved.
*
*  ========================================================================
*
*    This file contains Original Code and/or Modifications of Original
*    Code as defined in and that are subject to the Sybase Open Watcom
*    Public License version 1.0 (the 'License'). You may not use this file
*    except in compliance with the License. BY USING THIS FILE YOU AGREE TO
*    ALL TERMS AND CONDITIONS OF THE LICENSE. A copy of the License is
*    provided with the Original Code and Modifications, and is also
*    available at www.sybase.com/developer/opensource.
*
*    The Original Code and all software distributed under the License are
*    distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
*    EXPRESS OR IMPLIED, AND SYBASE AND ALL CONTRIBUTORS HEREBY DISCLAIM
*    ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF
*    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR
*    NON-INFRINGEMENT. Please see the License for the specific language
*    governing rights and limitations under the License.
*
*  ========================================================================
*
* Description:  Table of Java VM opcodes and corresponding decode routines.
*
****************************************************************************/


/*
      Idx,              Name,           Opcode,         Mask,           Handler
*/
inspick( bipush,        "bipush",       16,             0x000000ff,     JVMSByte )
inspick( sipush,        "sipush",       17,             0x000000ff,     JVMSShort )
inspick( ldc,           "ldc",          18,             0x000000ff,     JVMUByte )
inspick( ldc_w,         "ldc_w",        19,             0x000000ff,     JVMUShort )
inspick( ldc2_w,        "ldc2_w",       20,             0x000000ff,     JVMUShort )
inspick( aconst_null,   "aconst_null",  1,              0x000000ff,     JVMNull )
inspick( iconst_m1,     "iconst_m1",    2,              0x000000ff,     JVMNull )
inspick( iconst_0,      "iconst_0",     3,              0x000000ff,     JVMNull )
inspick( iconst_1,      "iconst_1",     4,              0x000000ff,     JVMNull )
inspick( iconst_2,      "iconst_2",     5,              0x000000ff,     JVMNull )
inspick( iconst_3,      "iconst_3",     6,              0x000000ff,     JVMNull )
inspick( iconst_4,      "iconst_4",     7,              0x000000ff,     JVMNull )
inspick( iconst_5,      "iconst_5",     8,              0x000000ff,     JVMNull )
inspick( lconst_0,      "lconst_0",     9,              0x000000ff,     JVMNull )
inspick( lconst_1,      "lconst_1",     10,             0x000000ff,     JVMNull )
inspick( fconst_0,      "fconst_0",     11,             0x000000ff,     JVMNull )
inspick( fconst_1,      "fconst_1",     12,             0x000000ff,     JVMNull )
inspick( fconst_2,      "fconst_2",     13,             0x000000ff,     JVMNull )
inspick( dconst_0,      "dconst_0",     14,             0x000000ff,     JVMNull )
inspick( dconst_1,      "dconst_1",     15,             0x000000ff,     JVMNull )
inspick( iload,         "iload",        21,             0x000000ff,     JVMWIndex )
inspick( iload_0,       "iload_0",      26,             0x000000ff,     JVMNull )
inspick( iload_1,       "iload_1",      27,             0x000000ff,     JVMNull )
inspick( iload_2,       "iload_2",      28,             0x000000ff,     JVMNull )
inspick( iload_3,       "iload_3",      29,             0x000000ff,     JVMNull )
inspick( lload,         "lload",        22,             0x000000ff,     JVMWIndex )
inspick( lload_0,       "lload_0",      30,             0x000000ff,     JVMNull )
inspick( lload_1,       "lload_1",      31,             0x000000ff,     JVMNull )
inspick( lload_2,       "lload_2",      32,             0x000000ff,     JVMNull )
inspick( lload_3,       "lload_3",      33,             0x000000ff,     JVMNull )
inspick( fload,         "fload",        23,             0x000000ff,     JVMWIndex )
inspick( fload_0,       "fload_0",      34,             0x000000ff,     JVMNull )
inspick( fload_1,       "fload_1",      35,             0x000000ff,     JVMNull )
inspick( fload_2,       "fload_2",      36,             0x000000ff,     JVMNull )
inspick( fload_3,       "fload_3",      37,             0x000000ff,     JVMNull )
inspick( dload,         "dload",        24,             0x000000ff,     JVMWIndex )
inspick( dload_0,       "dload_0",      38,             0x000000ff,     JVMNull )
inspick( dload_1,       "dload_1",      39,             0x000000ff,     JVMNull )
inspick( dload_2,       "dload_2",      40,             0x000000ff,     JVMNull )
inspick( dload_3,       "dload_3",      41,             0x000000ff,     JVMNull )
inspick( aload,         "aload",        25,             0x000000ff,     JVMWIndex )
inspick( aload_0,       "aload_0",      42,             0x000000ff,     JVMNull )
inspick( aload_1,       "aload_1",      43,             0x000000ff,     JVMNull )
inspick( aload_2,       "aload_2",      44,             0x000000ff,     JVMNull )
inspick( aload_3,       "aload_3",      45,             0x000000ff,     JVMNull )
inspick( istore,        "istore",       54,             0x000000ff,     JVMWIndex )
inspick( istore_0,      "istore_0",     59,             0x000000ff,     JVMNull )
inspick( istore_1,      "istore_1",     60,             0x000000ff,     JVMNull )
inspick( istore_2,      "istore_2",     61,             0x000000ff,     JVMNull )
inspick( istore_3,      "istore_3",     62,             0x000000ff,     JVMNull )
inspick( lstore,        "lstore",       55,             0x000000ff,     JVMWIndex )
inspick( lstore_0,      "lstore_0",     63,             0x000000ff,     JVMNull )
inspick( lstore_1,      "lstore_1",     64,             0x000000ff,     JVMNull )
inspick( lstore_2,      "lstore_2",     65,             0x000000ff,     JVMNull )
inspick( lstore_3,      "lstore_3",     66,             0x000000ff,     JVMNull )
inspick( fstore,        "fstore",       56,             0x000000ff,     JVMWIndex )
inspick( fstore_0,      "fstore_0",     67,             0x000000ff,     JVMNull )
inspick( fstore_1,      "fstore_1",     68,             0x000000ff,     JVMNull )
inspick( fstore_2,      "fstore_2",     69,             0x000000ff,     JVMNull )
inspick( fstore_3,      "fstore_3",     70,             0x000000ff,     JVMNull )
inspick( dstore,        "dstore",       57,             0x000000ff,     JVMWIndex )
inspick( dstore_0,      "dstore_0",     71,             0x000000ff,     JVMNull )
inspick( dstore_1,      "dstore_1",     72,             0x000000ff,     JVMNull )
inspick( dstore_2,      "dstore_2",     73,             0x000000ff,     JVMNull )
inspick( dstore_3,      "dstore_3",     74,             0x000000ff,     JVMNull )
inspick( astore,        "astore",       58,             0x000000ff,     JVMWIndex )
inspick( astore_0,      "astore_0",     75,             0x000000ff,     JVMNull )
inspick( astore_1,      "astore_1",     76,             0x000000ff,     JVMNull )
inspick( astore_2,      "astore_2",     77,             0x000000ff,     JVMNull )
inspick( astore_3,      "astore_3",     78,             0x000000ff,     JVMNull )
inspick( iinc,          "iinc",         132,            0x000000ff,     JVMIInc )
inspick( wide,          "wide",         196,            0x000000ff,     JVMWide )
inspick( newarray,      "newarray",     188,            0x000000ff,     JVMUByte )
inspick( anewarray,     "anewarray",    189,            0x000000ff,     JVMUShort )
inspick( multianewarray,"multianewarray",197,           0x000000ff,     JVMMultiANewArray )
inspick( arraylength,   "arraylength",  190,            0x000000ff,     JVMNull )
inspick( iaload,        "iaload",       46,             0x000000ff,     JVMNull )
inspick( laload,        "laload",       47,             0x000000ff,     JVMNull )
inspick( faload,        "faload",       48,             0x000000ff,     JVMNull )
inspick( daload,        "daload",       49,             0x000000ff,     JVMNull )
inspick( aaload,        "aaload",       50,             0x000000ff,     JVMNull )
inspick( baload,        "baload",       51,             0x000000ff,     JVMNull )
inspick( caload,        "caload",       52,             0x000000ff,     JVMNull )
inspick( saload,        "saload",       53,             0x000000ff,     JVMNull )
inspick( iastore,       "iastore",      79,             0x000000ff,     JVMNull )
inspick( lastore,       "lastore",      80,             0x000000ff,     JVMNull )
inspick( fastore,       "fastore",      81,             0x000000ff,     JVMNull )
inspick( dastore,       "dastore",      82,             0x000000ff,     JVMNull )
inspick( aastore,       "aastore",      83,             0x000000ff,     JVMNull )
inspick( bastore,       "bastore",      84,             0x000000ff,     JVMNull )
inspick( castore,       "castore",      85,             0x000000ff,     JVMNull )
inspick( sastore,       "sastore",      86,             0x000000ff,     JVMNull )
inspick( nop,           "nop",          0,              0x000000ff,     JVMNull )
inspick( pop,           "pop",          87,             0x000000ff,     JVMNull )
inspick( pop2,          "pop2",         88,             0x000000ff,     JVMNull )
inspick( dup,           "dup",          89,             0x000000ff,     JVMNull )
inspick( dup2,          "dup2",         92,             0x000000ff,     JVMNull )
inspick( dup_x1,        "dup_x1",       90,             0x000000ff,     JVMNull )
inspick( dup2_x1,       "dup2_x1",      93,             0x000000ff,     JVMNull )
inspick( dup_x2,        "dup_x2",       91,             0x000000ff,     JVMNull )
inspick( dup2_x2,       "dup2_x2",      94,             0x000000ff,     JVMNull )
inspick( swap,          "swap",         95,             0x000000ff,     JVMNull )
inspick( iadd,          "iadd",         96,             0x000000ff,     JVMNull )
inspick( ladd,          "ladd",         97,             0x000000ff,     JVMNull )
inspick( fadd,          "fadd",         98,             0x000000ff,     JVMNull )
inspick( dadd,          "dadd",         99,             0x000000ff,     JVMNull )
inspick( isub,          "isub",         100,            0x000000ff,     JVMNull )
inspick( lsub,          "lsub",         101,            0x000000ff,     JVMNull )
inspick( fsub,          "fsub",         102,            0x000000ff,     JVMNull )
inspick( dsub,          "dsub",         103,            0x000000ff,     JVMNull )
inspick( imul,          "imul",         104,            0x000000ff,     JVMNull )
inspick( lmul,          "lmul",         105,            0x000000ff,     JVMNull )
inspick( fmul,          "fmul",         106,            0x000000ff,     JVMNull )
inspick( dmul,          "dmul",         107,            0x000000ff,     JVMNull )
inspick( idiv,          "idiv",         108,            0x000000ff,     JVMNull )
inspick( ldiv,          "ldiv",         109,            0x000000ff,     JVMNull )
inspick( fdiv,          "fdiv",         110,            0x000000ff,     JVMNull )
inspick( ddiv,          "ddiv",         111,            0x000000ff,     JVMNull )
inspick( irem,          "irem",         112,            0x000000ff,     JVMNull )
inspick( lrem,          "lrem",         113,            0x000000ff,     JVMNull )
inspick( frem,          "frem",         114,            0x000000ff,     JVMNull )
inspick( drem,          "drem",         115,            0x000000ff,     JVMNull )
inspick( ineg,          "ineg",         116,            0x000000ff,     JVMNull )
inspick( lneg,          "lneg",         117,            0x000000ff,     JVMNull )
inspick( fneg,          "fneg",         118,            0x000000ff,     JVMNull )
inspick( dneg,          "dneg",         119,            0x000000ff,     JVMNull )
inspick( ishl,          "ishl",         120,            0x000000ff,     JVMNull )
inspick( ishr,          "ishr",         122,            0x000000ff,     JVMNull )
inspick( iushr,         "iushr",        124,            0x000000ff,     JVMNull )
inspick( lshl,          "lshl",         121,            0x000000ff,     JVMNull )
inspick( lshr,          "lshr",         123,            0x000000ff,     JVMNull )
inspick( lushr,         "lushr",        125,            0x000000ff,     JVMNull )
inspick( iand,          "iand",         126,            0x000000ff,     JVMNull )
inspick( land,          "land",         127,            0x000000ff,     JVMNull )
inspick( ior,           "ior",          128,            0x000000ff,     JVMNull )
inspick( lor,           "lor",          129,            0x000000ff,     JVMNull )
inspick( ixor,          "ixor",         130,            0x000000ff,     JVMNull )
inspick( lxor,          "lxor",         131,            0x000000ff,     JVMNull )
inspick( i2l,           "i2l",          133,            0x000000ff,     JVMNull )
inspick( i2f,           "i2f",          134,            0x000000ff,     JVMNull )
inspick( i2d,           "i2d",          135,            0x000000ff,     JVMNull )
inspick( l2i,           "l2i",          136,            0x000000ff,     JVMNull )
inspick( l2f,           "l2f",          137,            0x000000ff,     JVMNull )
inspick( l2d,           "l2d",          138,            0x000000ff,     JVMNull )
inspick( f2i,           "f2i",          139,            0x000000ff,     JVMNull )
inspick( f2l,           "f2l",          140,            0x000000ff,     JVMNull )
inspick( f2d,           "f2d",          141,            0x000000ff,     JVMNull )
inspick( d2i,           "d2i",          142,            0x000000ff,     JVMNull )
inspick( d2l,           "d2l",          143,            0x000000ff,     JVMNull )
inspick( d2f,           "d2f",          144,            0x000000ff,     JVMNull )
inspick( i2b,           "i2b",          145,            0x000000ff,     JVMNull )
inspick( i2c,           "i2c",          146,            0x000000ff,     JVMNull )
inspick( i2s,           "i2s",          147,            0x000000ff,     JVMNull )
inspick( ifeq,          "ifeq",         153,            0x000000ff,     JVMBrShort )
inspick( ifnull,        "ifnull",       198,            0x000000ff,     JVMBrShort )
inspick( iflt,          "iflt",         155,            0x000000ff,     JVMBrShort )
inspick( ifle,          "ifle",         158,            0x000000ff,     JVMBrShort )
inspick( ifne,          "ifne",         154,            0x000000ff,     JVMBrShort )
inspick( ifnonnull,     "ifnonnull",    199,            0x000000ff,     JVMBrShort )
inspick( ifgt,          "ifgt",         157,            0x000000ff,     JVMBrShort )
inspick( ifge,          "ifge",         156,            0x000000ff,     JVMBrShort )
inspick( if_icmpeq,     "if_icmpeq",    159,            0x000000ff,     JVMBrShort )
inspick( if_icmpne,     "if_icmpne",    160,            0x000000ff,     JVMBrShort )
inspick( if_icmplt,     "if_icmplt",    161,            0x000000ff,     JVMBrShort )
inspick( if_icmpgt,     "if_icmpgt",    163,            0x000000ff,     JVMBrShort )
inspick( if_icmple,     "if_icmple",    164,            0x000000ff,     JVMBrShort )
inspick( if_icmpge,     "if_icmpge",    162,            0x000000ff,     JVMBrShort )
inspick( lcmp,          "lcmp",         148,            0x000000ff,     JVMNull )
inspick( fcmpl,         "fcmpl",        149,            0x000000ff,     JVMNull )
inspick( fcmpg,         "fcmpg",        150,            0x000000ff,     JVMNull )
inspick( dcmpl,         "dcmpl",        151,            0x000000ff,     JVMNull )
inspick( dcmpg,         "dcmpg",        152,            0x000000ff,     JVMNull )
inspick( if_acmpeq,     "if_acmpeq",    165,            0x000000ff,     JVMBrShort )
inspick( if_acmpne,     "if_acmpne",    166,            0x000000ff,     JVMBrShort )
inspick( goto,          "goto",         167,            0x000000ff,     JVMBrShort )
inspick( goto_w,        "goto_w",       200,            0x000000ff,     JVMBrInt )
inspick( jsr,           "jsr",          168,            0x000000ff,     JVMBrShort )
inspick( jsr_w,         "jsr_w",        201,            0x000000ff,     JVMBrInt )
inspick( ret,           "ret",          169,            0x000000ff,     JVMWIndex )
inspick( ireturn,       "ireturn",      172,            0x000000ff,     JVMNull )
inspick( lreturn,       "lreturn",      173,            0x000000ff,     JVMNull )
inspick( freturn,       "freturn",      174,            0x000000ff,     JVMNull )
inspick( dreturn,       "dreturn",      175,            0x000000ff,     JVMNull )
inspick( areturn,       "areturn",      176,            0x000000ff,     JVMNull )
inspick( return,        "return",       177,            0x000000ff,     JVMNull )
inspick( breakpoint,    "breakpoint",   202,            0x000000ff,     JVMNull )
inspick( tableswitch,   "tableswitch",  170,            0x000000ff,     JVMTableSwitch )
inspick( lookupswitch,  "lookswitch",   171,            0x000000ff,     JVMLookupSwitch )
inspick( putfield,      "putfield",     181,            0x000000ff,     JVMUShort )
inspick( getfield,      "getfield",     180,            0x000000ff,     JVMUShort )
inspick( putstatic,     "putstatic",    179,            0x000000ff,     JVMUShort )
inspick( getstatic,     "getstatic",    178,            0x000000ff,     JVMUShort )
inspick( invokevirtual, "invokevirtual",182,            0x000000ff,     JVMUShort )
inspick( invokespecial, "invokespecial",183,            0x000000ff,     JVMUShort )
inspick( invokestatic,  "invokestatic",184,             0x000000ff,     JVMUShort )
inspick( invokeinterface,"invokeinterface",185,         0x000000ff,     JVMInterface )
inspick( athrow,        "athrow",       191,            0x000000ff,     JVMNull )
inspick( new,           "new",          187,            0x000000ff,     JVMUShort )
inspick( checkcast,     "checkcast",    192,            0x000000ff,     JVMUShort )
inspick( instanceof,    "instanceof",   193,            0x000000ff,     JVMUShort )
inspick( monitorenter,  "monitorenter", 194,            0x000000ff,     JVMNull )
inspick( monitorexit,   "monitorexit",  195,            0x000000ff,     JVMNull )
