.pp
C is sometimes called a "low-level" language,
referring to the fact that C programmers tend
to think in terms of bits, bytes, addresses and other concepts
fundamental to assembly-language programming.
.pp
But C is also a "broad spectrum" language.
In addition to accessing
the basic components of the computer, it also
provides features common to many "high-level" languages.
Structured
program control, data structures and modular program design
are recent additions to some high-level languages, but have been part
of the C language since its inception.
.pp
C gives the programmer the ability to write applications at a
level just above the assembly language level, without having to know
the assembly language of the machine.
Language compilers provided this ability in the past,
but the application was often
quite "fat", because the code produced by the compiler was never
as good as could be written by a good assembly language programmer.
But with modern code
generation techniques it is often difficult, if not impossible,
to distinguish an assembly language
program written by a human from the same
program generated by a C compiler (based on code size).
In fact, some
compilers now generate better code than all but the best assembly
language programmers.
.pp
So, what can C be used for?
It can be used to write virtually anything, the same way that
assembly language
can be used. But other programming languages continue to be used
for specific programming applications at which they excel.
.pp
C tends to be used for "systems programming", a term that refers to
the writing of operating systems, programming languages and other
software tools that don't fall into the class of "applications
programming".
A classic example is the
UNIX
operating system, developed by Bell Laboratories. It is written almost
entirely in C and is one of the most portable operating systems
available.
.pp
C is also used for writing large programs that require more efficiency
than the average application. Typical examples are
interpreters and compilers
for programming languages.
.pp
Another area where C is commonly used is large-scale application
programs, such as databases, spreadsheets, word processors and so on.
These require a high degree of efficiency and compactness, since they
are often basic to an individual's or company's computing needs,
and therefore consume a lot of computer resources.
.pp
It seems that C is used extensively for commercially available products,
but C can also be used for any application that just
requires more efficiency. For example, a large transaction processing
system may be written in COBOL, but to squeeze the last bit of
speed out of the system, it may be desirable to rewrite it in C.
That application could certainly be written in assembly language,
but many
programmers now prefer to avoid
programming at such a low level,
when a C compiler can generate code that is just as efficient.
.pp
Finally, of course, a major reason for writing a program in C is that
it will run with little or no modification on any system
with a C compiler.
In the past, with the proliferation of C compilers
and no standard to guide their design, it was much more difficult.
Today, with the appearance of the ISO standard for the C programming
language, a program written entirely in a conforming C implementation
should be transportable
to a new compiler with relatively little work.
Of course, issues like file names, memory layout and command line
parameter syntax will vary from one system to another, but a properly
designed C application will isolate these parts of the code in
"system-dependent" files, which can be changed for each system.
(Refer to "&portable.".)
