\ 4tH CSV to TCS converter - Copyright 2010,2012 J.L. Bezemer
\ You can redistribute this file and/or modify it under
\ the terms of the GNU General Public License

include lib/argopen.4th
include lib/parsing.4th
include lib/leading.4th
include lib/zenfloat.4th
include lib/zenans.4th
include lib/fpin.4th
include lib/fpout.4th

char a constant 'a'

: ReadLine refill tib count nip /tib 1- = abort" Line too long" ;
: .float maxdigits (f.) type ;
: float|string 2dup >float if .float 2drop else .| " | type .| "| then cr ;
: .Field 2>r over . dup emit ."  = " 2r> float|string ;
: WriteField -leading -trailing dup if .Field else 2drop then 1+ ;
: WriteLine >r begin r@ "parse"? while WriteField repeat 2drop drop 1+ 'a' r> ;
: ProcessFile 0 'a' rot begin ReadLine while WriteLine repeat ;
: CloseFiles drop drop drop close close ;

\ Open all files and get ASCII delimiter
: OpenFiles                            ( -- h h n)
  argn 4 < abort" Usage: csv2tcs ascii csv-file tcs-file"
  input 2 arg-open output 3 arg-open
  1 args number error? abort" Bad ASCII code"
;

: Convert OpenFiles ProcessFile CloseFiles ;

Convert
