\ -----------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Play BASIC musicfiles 
\ CATEGORY    : Music 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : March 17, 1994, Coos Haak 
\ -----------------------------------------



        NEEDS -sounds

        ?DEF -basmusic [IF] -basmusic [THEN]

        MARKER -basmusic


0 value startline
0 value endline

create linebuffer       /line allot

0 value thefile
0 value eof

0 value comment
0 value counter
0 value line

: getline
        linebuffer /line thefile read-line throw
        invert to eof to endline clear startline clear comment 1 +to line
        ;

0 value echo?

: echo.off
        clear echo?
        ;

: echo.on
        true to echo?
        ;

: getch
        begin   startline endline =
        while   getline
                eof
                if      -1 exit
                then
                echo?
                if      cr line 3 .r space
                then
        repeat
        startline linebuffer + c@ 1 +to startline echo?
        if      dup emit
        then
        ;

: peek
        startline linebuffer + c@
        ;

soundlib also sound

: do-a
        peek '#' =
        if      ais getch drop
        else    a
        then
        1 +to counter
        ;

: do-b
        b
        ;

: do-c
        peek '#' =
        if      cis getch drop
        else    c
        then
        1 +to counter
        ;

: do-d
        peek '#' =
        if      dis getch drop
        else    d
        then
        1 +to counter
        ;

: do-e
        e
        1 +to counter
        ;

: do-f
        peek '#' =
        if      fis getch drop
        else    f
        then
        1 +to counter
        ;

: do-g
        peek '#' =
        if      gis getch drop
        else    g
        then
        1 +to counter
        ;

: do-attack
        getch >upc case
        'L' of  legato  endof
        'N' of  normrest        endof
        'S' of  staccato        endof
        endcase
        ;

: getnumber
        getch #10 digit
        if      peek #10 digit
                if      getch drop swap #10 * +
                        peek #10 digit
                        if      getch drop swap #10 * +
                        else    drop
                        then
                else    drop
                then
        else    drop
        then
        ;

#256 fraction: /256

: do-len
        #256 getnumber / /256
        ;

: do-tempo
        getnumber tempo ! 1 /4 measure a.tempo
        ;

: do-rest
        tempo @ getnumber tempo ! pause tempo !
        ;

: process
        >upc comment
        if      drop exit
        then
        case
        ''' of  true to comment endof
        'A' of  do-a    endof
        'B' of  do-b    endof
        'C' of  do-c    endof
        'D' of  do-d    endof
        'E' of  do-e    endof
        'F' of  do-f    endof
        'G' of  do-g    endof
        'O' of  getch #10 digit drop 1 max 7 min octave !       endof
        'M' of  do-attack       endof
        'L' of  do-len  endof
        'T' of  do-tempo        endof
        '>' of  octave incr     endof
        '<' of  octave decr     endof
        'P' of  do-rest endof
        endcase
        ;

: play
        hide-cursor clear counter
        s" .snd" bl word append here count r/o open-file throw to thefile
        clear startline clear endline clear line timer-reset
        begin   getch dup -1 <> stop? invert and
        while   process
        repeat
        drop thefile close-file throw
        cr .elapsed ."  Played " line . ." lines and " counter . ." notes."
        show-cursor
        ;

-2 set-order

graphics 20 to l/scr keyboard

                            \ (* End of Source *) /
