\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ * LANGUAGE    : ANS Forth with DFW extensions
\ * PROJECT     : DFW Forth Environments
\ DESCRIPTION : Check the number of levels of Forth's program tree
\ CATEGORY    : Curiosity (see JFAR Vol 5, No 4, 1989)
\ AUTHOR      : Marcel Hendrix 
\ LAST CHANGE : April 25, 1994, Coos Haak 
\ LAST CHANGE : April 18, 1994, Marcel Hendrix 
\ ----------------------------------------------------------------------



        NEEDS -miscutil

        ?DEF -depth [IF] -depth [THEN]

        MARKER -depth


DOC
Subject: depth
From: mhx (Marcel Hendrix)
Level whiz: Valid DFW member
Date: Mon, 18 Apr 94 22:23:34 GMT
Organization: Dutch Forth Workshop, Arnhem Netherlands

Bij het lezen van JFAR Vol 5 (Forth Processors, parallel Forth,
Statistics), ging ik me afvragen hoe diep de return stack groeit
tijdens het uitvoeren van een Forth woord. Dit (statistische)
gegegeven is van belang voor het bouwen van een Forth processor
met on-chip stacks, maar ook voor de Forth compilerbouwer is het
van belang.

Onderstaande utility test voor iForth tot welke diepte
(ongeveer!) de return stack groeit. De betekenis van 'ongeveer'
wordt duidelijk als je voor je eigen Forth TEST probeert aan te
passen: TEST gebruikt immers ook zelf de return stack weer...

De routine kan ook gecompileerd worden onder CHForth (zonder
wijzigingen) maar hij werkt dan NIET. Waarom niet? Vraag dat
maar aan Coos Haak :-)

Een paar resultaten:

TEST cr                         ( 5 posities)
TEST space                      ( 1 positie )
TEST in formula                 ( 101 posities!)
TEST play-full galop.mid        ( 24 posities)

In JFAR wordt voor de SC32 aangegeven dat 32 posities voor 99.99%
van de applicaties genoeg is. 

Ik zie statistieken voor andere Forths met belangstelling tegemoet.

>M.
---
ENDDOC


        PRIVATES

DOC
(*
 This utility assumes that stacks grow down.
 This utility assumes that stacks are at least 130 cells deep.
 This utility is not very accurate for shallow programs (words).
*)
ENDDOC


0 VALUE deep130  PRIVATE        
0 VALUE rminimum PRIVATE

S" RETURN-STACK-CELLS" ENVIRONMENT? DROP CONSTANT #130

-- This words writes the same address all over the return stack

: MARK-130      RECURSIVE
                deep130 #130 < IF 1 +TO deep130 
                                  MARK-130
                            ENDIF ; PRIVATE

?UNDEF NOOP [IF]

: NOOP ; PRIVATE

[THEN]

-- This words serves to find out how many levels TEST itself will use.

S" CHFORTH" ENVIRONMENT? [IF] DROP

: STACK@
        ALSO INTERNAL
        S" STKSEG @ SWAP @X " EVALUATE
        PREVIOUS
        ;  IMMEDIATE

: STACK@+
        ALSO INTERNAL
        S" DUP CELL+ STKSEG @ ROT @X " EVALUATE
        PREVIOUS
        ;  IMMEDIATE

INTERNAL

' RP@ ALIAS RP@

FORTH
           
[THEN]

S" IFORTH" ENVIRONMENT? [IF] DROP

: STACK@
        S" @ " EVALUATE
        ;  IMMEDIATE

: STACK@+
        S" @+ " EVALUATE
        ;  IMMEDIATE

[THEN]

: CALIBRATE     0 LOCAL lowraddr
                CLEAR deep130
                ['] NOOP >S
                RP@ #130 CELLS - TO lowraddr 
                MARK-130 S> EXECUTE
                lowraddr DUP STACK@ >S  
                #130 0 DO STACK@+ S <> IF LEAVE ENDIF LOOP -S ( addr)
                lowraddr #130 CELLS + SWAP - #CELLS TO rminimum ;

                CALIBRATE  FORGET CALIBRATE


: TEST          0 LOCAL lowraddr        \ <?> TEST #<name># --> <?>
                CLEAR deep130
                ' ( token) >S
                RP@ #130 CELLS - TO lowraddr 
                MARK-130 S> EXECUTE
                lowraddr DUP STACK@ >S  
                #130 0 DO STACK@+ S <> IF LEAVE ENDIF LOOP -S ( addr)
                lowraddr #130 CELLS + SWAP - #CELLS rminimum -
                CR ." Approximately " .DEC ." Rstack cells used." ;


DEPRIVE

: .HELP
        CR ." TEST <word>  finds out how many stack cells <word> uses."
        CR ." Example: TEST CR " 
        CR ." The accuracy is rather low for `shallow' words!" ;

.HELP
                            \ (* End of Source *) /
