\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : World of Blocks 
\ CATEGORY    : Graphics 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------



        NEEDS -graphics
        NEEDS -classes


        ?DEF -blocks [IF] -blocks [THEN]

        MARKER -blocks



DOC
   Vijgeblad 4, blz 44 (1982)
ENDDOC


class rechthoek
        int breed       private
        int hoog        private
        : init
                hoog ! breed !
        ;
        : draw
                local y local x
                x               y               moveto
                x               y hoog @ +      draw
                x breed @ +     y hoog @ +      draw
                x breed @ +     y               draw
                x               y               draw
        ;
endclass

class driehoek
        int breed       private
        int hoog        private
        : init
                hoog ! breed !
        ;
        : draw
                local y local x
                x               y               moveto
                x breed @ 2/ +  y hoog @ +      draw
                x breed @ +     y               draw
                x               y               draw
        ;
endclass

class boom
        rechthoek stam  private
        int bladeren    private

        : init
                6 30 stam init 20 bladeren !
                ;

        : draw
                local y local x
                x y stam draw x 3 + y 30 + bladeren @ + bladeren @ circle
                ;
endclass

boom boompje

class huis
        rechthoek kamer private
        driehoek dak    private
        : init
                40 40 kamer init 40 20 dak init
        ;
        : draw
                2dup kamer draw 40 + dak draw
        ;
endclass

40 40 rechthoek blokje
40 4 rechthoek deksel
huis huisje

100 value speed

: wacht
        speed ms
;

: go
        text?
        if      graphics
        then
        begin   randcolor
                xmax 40 - choose ymax 40 - choose 2dup blokje draw 2>r
                wacht
                xmax 40 - choose ymax 80 - choose 2dup huisje draw 2>r
                wacht
                xmax 40 - choose ymax 40 - choose 2dup deksel draw 2>r
                wacht
                xmax 40 - choose ymax 40 - choose 2dup boompje draw
                black
                2r> 2r> 2r> blokje draw
                wacht
                huisje draw
                wacht
                deksel draw
                wacht
                boompje draw
                wacht
                stop?
        until
        ;

                            \ (* End of Source *) /
