\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Rotating mathematical bodies 
\ CATEGORY    : Graphics 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------



        NEEDS -graphics
        NEEDS -gonio
        NEEDS -vectors

        ?DEF -bodies [IF] -bodies [THEN]

        MARKER -bodies


relplot
warning off

privates

: cnvrt
        swap xmax 4096 */ swap xmax 4096 */ ;   private

: plot
        cnvrt plot ;

: move
        cnvrt moveto ;

: draw
        cnvrt draw ;

warning on

( x1 y1 z1 -- x2 y2 )   -- ruimtelijke coordinaten naar schermcoordinaten
: 3>2
        >r >r dup negate 2/ 2/ swap negate 2/ r> + swap r> + ;

( p1 p2 ... pn n -- )   -- pi zijn tweedimensinale vec's
: poly
        -rot 2dup move 2>r 1- 0
        ?do     randcolor draw
        loop
        2r> draw ;

vec a   private
vec b   private
vec c   private
vec d   private
vec e   private
vec f   private
vec g   private
vec h   private

( a b d -- )            -- eigenlijk een parallelogram
: square
        3>2 to d 3>2 to b 3>2 to a
        b a v- d v+ to c
        a b c d 4 poly ;

( a b c d -- )
: tetrahedron
        3>2 to d 3>2 to c 3>2 to b 3>2 to a
        d c b a 4 poly c draw b move d draw ;

( a b d e -- )
: cube
        3>2 to e 3>2 to d 3>2 to b 3>2 to a
        b a v- d v+ to c b a v- e v+ to f d a v- e v+ to h b a v- h v+ to g
        d h e f g c b a 8 poly
        e draw b move f draw g move h draw d move c draw ;

( a b d e -- )
: octahedron
        3>2 to e 3>2 to d 3>2 to b 3>2 to a
        b a v- d v+ to c a e v- c v+ to f
        e c f d e b f a d c b a 12 poly ;

( a b d e f h -- )
: 'tetrabipy'
        3>2 to h 3>2 to f 3>2 to e       f e v- h v+ to g
        3>2 to d 3>2 to b 3>2 to a       b a v- d v+ to c
        a b c d a e b f c g d h 12 poly
        e f g h 4 poly ;

deprive

 500 constant  rrr
-500 constant -rrr
 353 constant  sss
-353 constant -sss
 400 constant  ttt
-400 constant -ttt

privates

3vec a  private
3vec b  private
3vec c  private
3vec d  private
3vec e  private
3vec f  private

3vec a' private
3vec b' private
3vec c' private
3vec d' private
3vec e' private
3vec f' private

10 constant hoek        private

0 value hoek'   private

: st_c
         rrr  rrr  rrr to a
         rrr -rrr  rrr to b
         rrr  rrr -rrr to c
        -rrr  rrr  rrr to d ;

: st_o
        rrr     0       0       to a
        0       rrr     0       to b
        0       -rrr    0       to c
        0       0       rrr     to d ;

: st_t1
         rrr  rrr  rrr to a
         rrr -rrr -rrr to b
        -rrr  rrr -rrr to c
        -rrr -rrr  rrr to d ;

: st_t2
         rrr  rrr -rrr to a
         rrr -rrr  rrr to b
        -rrr  rrr  rrr to c
        -rrr -rrr -rrr to d ;

: st_tb
        rrr     0       -ttt to a
        0       rrr     -ttt to b
        0       -rrr    -ttt to c
         sss  sss  ttt to d
        -sss  sss  ttt to e
         sss -sss  ttt to f ;

: rotz
        >r hoek' rotate r> ;

: roty
        swap >r hoek' rotate r> swap ;

: rotx
        hoek' rotate ;

vector rotator

: moveit
        hoek +to hoek'
        a rotator to a'
        b rotator to b'
        c rotator to c'
        d rotator to d'
        e rotator to e'
        f rotator to f' ;

#20 constant aantal

: kubus
        st_c ['] rotz is rotator clear hoek' aantal 0
        do      page a' b' c' d' cube moveit
        loop
        st_c ['] rotx is rotator clear hoek' aantal 0
        do      page a' b' c' d' cube moveit
        loop
        st_c ['] roty is rotator clear hoek' aantal 0
        do      page a' b' c' d' cube moveit
        loop ;

: tetra
        st_t1 ['] rotz is rotator clear hoek' aantal 0
        do      page a' b' c' d' tetrahedron moveit
        loop
        st_t1 ['] rotx is rotator clear hoek' aantal 0
        do      page a' b' c' d' tetrahedron moveit
        loop
        st_t1 ['] roty is rotator clear hoek' aantal 0
        do      page a' b' c' d' tetrahedron moveit
        loop
        st_t2 ['] rotz is rotator clear hoek' aantal 0
        do      page a' b' c' d' tetrahedron moveit
        loop
        st_t2 ['] rotx is rotator clear hoek' aantal 0
        do      page a' b' c' d' tetrahedron moveit
        loop
        st_t2 ['] roty is rotator clear hoek' aantal 0
        do      page a' b' c' d' tetrahedron moveit
        loop ;

: okta
        st_o ['] rotz is rotator clear hoek' aantal 0
        do      page a' b' c' d' octahedron moveit
        loop
        st_o ['] rotx is rotator clear hoek' aantal 0
        do      page a' b' c' d' octahedron moveit
        loop
        st_o ['] roty is rotator clear hoek' aantal 0
        do      page a' b' c' d' octahedron moveit
        loop ;

: tetrabi
        st_tb ['] rotz is rotator clear hoek' aantal 0
        do      page a' b' c' d' e' f' 'tetrabipy' moveit
        loop
        st_tb ['] rotx is rotator clear hoek' aantal 0
        do      page a' b' c' d' e' f' 'tetrabipy' moveit
        loop
        st_tb ['] roty is rotator clear hoek' aantal 0
        do      page a' b' c' d' e' f' 'tetrabipy' moveit
        loop ;

deprive

                            \ (* End of Source *) /
