\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's
\ DESCRIPTION : ??????????
\ CATEGORY    : Standard Programs
\ AUTHOR      : Coos Haak
\ LAST CHANGE : November 04, 1994, Coos Haak
\ ----------------------------------------------------------------------



        NEEDS -graphics


        ?DEF -diffusion [IF] -diffusion [THEN]


        MARKER -diffusion


2variable counter

2variable c1
2variable c2
2variable c3
2variable c4

: plot
        plot
        1. counter d+!
        home counter 2@ 6 d.r
        c1 2@ 6 d.r 
        c2 2@ 6 d.r 
        c3 2@ 6 d.r 
        c4 2@ 6 d.r 
        sound 100. microseconds nosound
    ;

: stars
\       1000 0
\       do      80 choose 40 - xmax 2/ +
\               80 choose 40 - ymax 2/ + plot
\       loop
\       xmax 2/ 100 - ymax 2/ 30 - over 200 + over 60 + box
\       xmax 2/ ymax 2/ plot
        xmax 2/     ymax 2/     ymax 10 / circle
\       xmax 2/ ymax 2/ plot
    ;

0 value x1
0 value y1
0 value x2
0 value y2
0 value x3
0 value y3
0 value x4
0 value y4

: new-top        ( -- )
        xmax 4 - choose 2 + to x1
        ymax 16 - to y1
    ;

: new-bottom     ( -- )
        xmax 4 - choose 2 + to x2
        0 to y2
    ;

: new-left       ( -- )
        0 to x3
        ymax 16 - 4 - choose 2 + to y3
    ;

: new-right      ( -- )
        xmax to x4
        ymax 16 - 4 - choose 2 + to y4
    ;

: top-stop?     ( -- flag )
        x1 xmax 2 - 2 within
        y1 ymax 4 / < or
    ;

: bottom-stop?  ( -- flag )
        x2 xmax 2 - 2 within
        y2 ymax 3 4 */ > or
    ;

: left-stop?    ( -- flag )
        x3 xmax 3 4 */ >
        y3 ymax 2 - 2 within or
    ;

: right-stop?   ( -- flag )
        x4 xmax 4 / <
        y4 ymax 2 - 2 within or
    ;

: top-step?     ( -- flag )
        x1 1- y1 1- get-dot
        x1    y1 1- get-dot or
        x1 1+ y1 1- get-dot or 0=
    ;

: bottom-step?  ( -- flag )
        x2 1- y2 1+ get-dot
        x2    y2 1+ get-dot or
        x2 1+ y2 1+ get-dot or 0=
    ;

: left-step?    ( -- flag )
        x3 1+ y3 1- get-dot
        x3 1+ y3    get-dot or
        x3 1+ y3 1+ get-dot or 0=
    ;

: right-step?   ( -- flag )
        x4 1- y4 1- get-dot
        x4 1- y4    get-dot or
        x4 1- y4 1+ get-dot or 0=
    ;

: top-step
        3 choose 1- +to x1
        -1 +to y1
    ;

: bottom-step
        3 choose 1- +to x2
        1 +to y2
    ;

: left-step
        1 +to x3
        3 choose 1- +to y3
    ;

: right-step
        -1 +to x4
        3 choose 1- +to y4
    ;

: top-plot
        14 to color
        x1 y1 plot
        1. c1 d+!
    ;

: bottom-plot
        13 to color
        x2 y2 plot
        1. c2 d+!
    ;

: left-plot
        12 to color
        x3 y3 plot
        1. c3 d+!
    ;

: right-plot
        11 to color
        x4 y4 plot
        1. c4 d+!
    ;

: go
        [ 440 8 * ] literal pitch
        counter d0!
        c1 d0!
        c2 d0!
        c3 d0!
        c4 d0!
        text?
        if      graphics
        then
        page white
        stars new-top new-bottom new-left new-right
        begin   top-stop?
                if      new-top
                then
                bottom-stop?
                if      new-bottom
                then
                left-stop?
                if      new-left
                then
                right-stop?
                if      new-right
                then
                top-step?
                if      top-step
                else    top-plot new-top
                then
                bottom-step?
                if      bottom-step
                else    bottom-plot new-bottom
                then
                left-step?
                if      left-step
                else    left-plot new-left
                then
                right-step?
                if      right-step
                else    right-plot new-right
                then
                stop?
        until
        white
    ;




                            \ (* End of Source *) /
