\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's
\ DESCRIPTION : Graphic Toy
\ CATEGORY    : Example
\ AUTHOR      : Marcel Hendrix, September 9th 1989
\ LAST CHANGE : November 12, 1994, Coos Haak
\ LAST CHANGE : June 9, 1993, Marcel Hendrix
\ ----------------------------------------------------------------------



        NEEDS -miscutil
        NEEDS -graphics
        NEEDS -igraph

        ?DEF -turmites [IF] -turmites [THEN]

        MARKER -turmites


\       REVISION -turmites " Turmites            Version 1.00 "

        PRIVATES

DOC Turmite
(*
 This (Turing) Machine consists of a state table that prescribes
 actions to perform in each state, given two possible input values.
 The "action" record consists of:
        -  a new state. 
        -  a colour. Plot the current pixel with it.
        -  a direction to turn to. Move 1 pixel in this new direction.
           The colour of this new pixel is the "input value" mentioned
           above.

 Alternatively, the state table can be translated into the brains of a neural 
 network.  The reverse is much more useful though.

 Further reading: A. K. Dewdney, Computer Recreations, Scientific American, 
                  September 1989
*)
ENDDOC


0 VALUE CurrentState    PRIVATE
0 VALUE Direction       PRIVATE

: TURMITE,
        CREATE  \ enter <new state> , <colour> , <angle> ,
                PRIVATE
        DOES>   CurrentState 6 * +              \ state
                GETXY GET-DOT 0<>  1 AND 3 * +  \ Input
                C@+ TO CurrentState
                C@+ GETXY ROT SET-DOT 
                C@ Direction + 3 AND DUP TO Direction 
                CASE 
                  0 OF  1  0  ENDOF
                  1 OF  0  1  ENDOF
                  2 OF -1  0  ENDOF
                  3 OF  0 -1  ENDOF
                        0  0 ROT
                ENDCASE IMOVETO ; PRIVATE

TURMITE, RedPole
        \ <state> <colour> <angle>   
( in=0)      0 C,  white C,   1 C,     
( in=1)      0 C,  black C,   3 C, 

TURMITE, Spiral
        \ <state> <colour> <angle>
( in=0)      0 C, white C,   1 C, 
( in=1)      1 C, black C,   0 C, 
( in=0)      0 C,   red C,   3 C,  
( in=1)      0 C,   red C,   3 C,  

TURMITE, Q
    \ <state> <colour>   <angle>  <state> <colour>   <angle>
         1 C,   white C,   3 C,      0 C,   black C,   3 C, 
         2 C,   black C,   0 C,      3 C,     red C,   0 C, 
         3 C,  yellow C,   3 C,      1 C,   black C,   2 C, 
         0 C,   black C,   2 C,      2 C,   green C,   1 C, 

TURMITE, W
    \ <state> <colour>   <angle>  <state> <colour>   <angle>
         1 C,   white C,   2 C,      2 C,   black C,   1 C, 
         2 C,  yellow C,   0 C,      5 C,   black C,   3 C, 
         3 C, magenta C,   1 C,      0 C,   black C,   1 C, 
         4 C,     red C,   3 C,      6 C,   black C,   3 C, 
         5 C,   black C,   1 C,      7 C,  yellow C,   2 C, 
         6 C,   green C,   3 C,      1 C,   black C,   0 C, 
         7 C,    blue C,   2 C,      4 C,   black C,   0 C, 
         0 C,   black C,   0 C,      7 C,   black C,   2 C, 

TURMITE, E
    \ <state> <colour>   <angle>  <state> <colour>   <angle>
         1 C,   white C,   3 C,      4 C,   black C,   1 C, 
         2 C,   white C,   2 C,      5 C,   black C,   0 C, 
         3 C,     red C,   1 C,      6 C,   black C,   3 C, 
         0 C,     red C,   0 C,      7 C,   black C,   2 C, 
         1 C,  yellow C,   3 C,      5 C,   black C,   1 C, 
         2 C,  yellow C,   2 C,      6 C,   black C,   0 C, 
         3 C,    blue C,   1 C,      7 C,   black C,   3 C, 
         0 C,    blue C,   0 C,      4 C,   black C,   2 C, 

DEFER turmite   PRIVATE

: DoRedPole     ['] RedPole IS turmite ;
: DoSpiral      ['] Spiral  IS turmite ;
: DoQ           ['] Q       IS turmite ;
: DoW           ['] W       IS turmite ;
: DoE           ['] E       IS turmite ;

 TRUE VALUE ?border
  #40 VALUE dimension   PRIVATE
    0 VALUE zz          PRIVATE

: gbox          zz zz  Xmax zz 2* -  Ymax zz 2* - 
                GETCOLOR RECTANGLE ; PRIVATE

: border        ?border IF dimension        TO zz gbox
                           dimension    5 + TO zz gbox 
                           dimension #100 + TO zz gbox 
                           dimension #105 + TO zz gbox 
                     ENDIF ; PRIVATE

: DO-IT         TEXTMODE? IF GRAPHICS ENDIF
                CLEAR CurrentState  
                cyan SETCOLOR PUT! CLS
                border CENTER           \ Obstructing turmite is more fun..
                BEGIN 
                 turmite
                 KEY? 
                UNTIL 
                KEY DROP ;


:ABOUT          CR ." enter ( doRedPole | doSpiral | doQ | doW | doE )  DO-IT " ;


                DoRedPole
                .ABOUT -turmites CR
                DEPRIVE

                            \ (* End of Source *) /
