\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Verhulst fractals 
\ CATEGORY    : Graphics 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------



        NEEDS -graphics
        NEEDS -fixed

        ?DEF -verhulst [IF] -verhulst [THEN]

        MARKER -verhulst


: display
        3 6 n.r
        ;

fvalue x
fvalue y
fvalue a

: newx
        1.0e x f- y f- a f* x f*
        ;

: newy
\       x y f* a f*
        x y f* a 0.85e f* f*
        ;

: calc
        newx newy to y to x
        ;

#cpu @ #386 = [if]

: play
        nosound #40 * 100 + pitch sound \ #125. microseconds
        ;

[else]

: play
        #40 * 100 + 1 swap tone
        ;

[then]

: plot
        tuck plot play
        ;

: plotten
        2000 0
        do      i maxc and to color
                calc
                x xmax s>f f* round
                y ymax s>f f* round plot
        loop
        ;

absplot

4000 constant high
3300 constant low

: go
        text?
        if      graphics
        then
        sound high low
        do      i s>f 1000e f/ to a 0.05e to x 0.05e to y 1000 0
                do      calc
                loop
                page a display
                plotten
                stop? ?leave
        loop
        nosound
    ;

: go1
        text?
        if      graphics
        then
        sound high low
        do      i s>f 1000e f/ to a 0.05e to x 0.05e to y
                page a display xmax 2 lshift 0 do
                        calc
                        i 2/ 2/ x ymax s>f f* round plot
                loop
                stop? ?leave
        10 +loop
        nosound
    ;

: go2
        text?
        if      graphics
        then
        sound high low
        do      i s>f 1000e f/ to a 0.05e to x 0.05e to y
                page a display xmax 0
                do      calc
                        i x ymax s>f f* round plot
                loop
                stop? ?leave
        10 +loop
        nosound
    ;
                            \ (* End of Source *) /
