\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Joystick 
\ CATEGORY    : Peripherals 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------


        NEEDS -graphics
        NEEDS -peripher


        ?DEF -joystick [IF] -joystick [THEN]


        MARKER -joystick



: staafje
        %00001011 attr ! 10 / dup 0
        ?do     '' emit
        loop
        %00001001 attr ! 41 swap
        ?do     '' emit
        loop
        normal
        ;

: omrekenen
        dup 50 <
        if      drop -1
        else    300 >
                if      1
                else    0
                then
        then
        ;

: go
        cr cr
        begin   0 ?at nip 1- at-xy stick
                dup staafje omrekenen 3 .r cr
                dup staafje omrekenen 3 .r
                strig key? or
        until
        ;

: stick
        stick omrekenen swap omrekenen swap
        ;

: tekenen
        page hide-cursor
        c/l 2/ local x
        l/scr 2/ local y
        0 local c
        begin   stick
                y + l/scr 2 - min 0 max to y
                x + c/l 1- min 0 max to x
                c 1+ #26 mod to c
                x y at-xy 'A' c + emit \ 50 ms x y at-xy space
                strig key? or
        until
        home cr show-cursor
        ;

-- positie
variable x      c/l 2/ x !
variable y      l/scr 2/ y !
variable c

-- relatieve rijrichting
0 constant gestopt
1 constant vooruit
2 constant links
3 constant achteruit
4 constant rechts

-- absolute rijrichting
0 constant noord
1 constant oost
2 constant zuid
3 constant west
$04 constant 'stop'     'stop' c !
$18 constant 'noord'
$1A constant 'oost'
$19 constant 'zuid'
$1B constant 'west'

variable absoluut       noord absoluut !
variable x      c/l 2/ x !
variable y      l/scr 2/ y !

: stapje        ( richting -- )
        case
            gestopt of      'stop' c ! endof
            vooruit of
                case absoluut @
                    noord of    'noord' c ! y @ 1- 0 max y !        endof
                    oost of     'oost' c ! x @ 1+ c/l min x !       endof
                    zuid of     'zuid' c ! y @ 1+ l/scr 2 - min y ! endof
                    west of     'west' c ! x @ 1- 0 max x !         endof
                endcase     endof
            rechts of   absoluut @ 1+ 3 and absoluut !  endof
            achteruit of
                case absoluut @
                    noord of    y @ 1+ l/scr 2 - min y !    endof
                    oost of     x @ 1- 0 max x !            endof
                    zuid of     y @ 1- 0 max y !            endof
                    west of     x @ 1+ c/l 1- min x !       endof
                endcase     endof
            links of    absoluut @ 1- 3 and absoluut !  endof
        endcase
        ;

: wacht
        click 100 ms
        ;

: rijden
        page hide-cursor
        c/l 2/ x !
        l/scr 2/ y !
        begin   stick
                case
                    -1 of   vooruit stapje wacht    endof
                     1 of   achteruit stapje wacht  endof
                endcase
                case
                    -1 of   links stapje wacht      endof
                     1 of   rechts stapje wacht     endof
                endcase
                case absoluut
                    noord of    $1E     endof
                    oost of     $10     endof
                    zuid of     $1F     endof
                    west of     $11     endof
                    4 swap
                endcase
                x @ y @ at-xy c @ emit
                strig key? or
        until
        home show-cursor cr
        ;

                            \ (* End of Source *) /
