\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Michael Stolowitz' expression parser 
\ CATEGORY    : Standard Programs 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------


        MARKER -algebra


vocabulary algebraic

privates

create op       private
        op #22 cells dup allot erase

: ?interp
        state @
        if      ,
        else    execute
        then
        ;  private

: opp@
        op dup @ +
        ;  private

: >op
        2 cells op +! opp@ 2!
        ;  private

: op>
        opp@ 2@ -2 cells op +! drop ?interp
        ;  private

: lev?
        opp@ @
        ;  private

algebraic definitions

: ]a
        begin   lev?
        while   op>
        repeat
        previous
        ;  immediate

' ]a alias } immediate

warning off

: (
        ['] noop 1 >op
        ;  immediate

warning on

: )
        begin   1 lev? <
        while   op>
        repeat
        1 lev? <> abort" Missing '('" -2 cells op +!
        ;  immediate

forth definitions

: infix
        ' get-current ['] algebraic >body set-current
        create  set-current swap 2, immediate
        does>   2@
                begin   dup lev? > invert
                while   2>r op> 2r>
                repeat
                >op
        ;

: a[
        op off also algebraic
        ;  immediate

' a[ alias { immediate

deprive
                            \ (* End of Source *) /
