\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Object Oriented Forth 
\ CATEGORY    : Utilities 
\ AUTHOR      : Dick Pountain 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------


        MARKER -classes


: allotz
        here swap dup allot erase ;

-- variables

privates

variable size   private
variable val    private val off
variable in.class.def?  private
variable the.class      private the.class off
variable heir   private
variable save-current   private

-- operator stack

32 cells constant maxnest       private

create instances        private here maxnest + , maxnest allotz

?undef assembler [if]

: instance
        -1 cells instances +! instances @ ! ;   private

: {{
        inline# instance ;      private

: }}
        1 cells instances +! ;  private

: offset+
        instances @ @ + ;       private

: (+)
        inline# offset+ ;       private

: index+
        rot * + ;       private

[else]

code instance
                mov     di, instances
                dec     di
                dec     di
                mov     instances di
                mov     0 [di], bx
                pop     bx
                next    end-code        private

code {{
                lodsw   es:
                mov     di, instances
                dec     di
                dec     di
                mov     instances di
                mov     0 [di], ax
                next    end-code        private

code }}
                add     instances # 1 cells
                next    end-code        private

code offset+
                mov     di, instances
                add     bx, 0 [di]
                next    end-code        private

code (+)
                lodsw   es:
                mov     di, instances
                add     ax, 0 [di]
                push    bx
                mov     bx, ax
                next    end-code        private

code index+
                pop     cx
                pop     ax
                mul     bx
                add     ax, cx
                mov     bx, ax
                next    end-code        private

[then]

?def decompiler [if]
also decompiler

:noname
        [ decompiler ]
        cell+ \" {{ " dup l@ body> >head .head space cell+ ;
        ' {{ tab!

:noname
        [ decompiler ]
        cell+ '+' emit dup l@ h. cell+ ;
        ' (+) tab!

:noname
        dup l@ >head .head nl cell+ ;
        ' }} tab!

previous
[then]

-- type vocabulary

create namebuffer       private #32 allotz

: findname      ( wid c-addr u -- 0 | xt -1 )
        namebuffer pack count casesensitive @ invert
        if      2dup upper
        then
        rot search-wordlist ;   private

: find.op
        bl parse-word findname 0=
        if      instances dup dup maxnest erase maxnest + swap !
                true abort" wrong operator"
        then ;  private

: initialize
        swap instance s" init" findname
        if      execute \ cr ." Initialized " @latest .head
        then
        }} ;    private

-- executing and compiling

: do.op
        find.op swap instance execute }} ;      private

: array.do.op
        find.op -rot cell+ cell+ dup @ index+ instance execute }} ;     private

: compile.call
        postpone instance compile, postpone }} ;        private

: compile.op
        find.op swap postpone {{ compile, compile, postpone }} ;        private

: array.comp.op
        find.op >r cell+ cell+ dup @ val @
        if      index+ postpone literal
        else    swap postpone literal postpone literal postpone index+
        then
        r> compile.call val off ;       private

: do.or.comp
        state @
        if      compile.op
        else    do.op
        then ;  private

: array.do.or.comp
        state @
        if      array.comp.op
        else    array.do.op
        then ;  private

-- instances

: var>
        create  here swap dup @ dup , swap cell+ @ allotz initialize immediate
        does>   dup @ do.or.comp ;      compile-only

: array.var>
        create  2dup @ , , cell+ @ dup , * allotz immediate
        does>   dup @ array.do.or.comp ;        compile-only

?def decompiler [if]
also decompiler

:noname
        ." VAR> " >parm @ 2 cells - body> >head .head ;
        ' var> >body 3 cells + tab!

:noname
        ." ARRAY.VAR> " >parm @+ swap 2@ h. h. 2 cells - body> >head .head ;
        ' array.var> >body 3 cells + tab!

previous
[then]

: def>
        create  2@ , size @ , size +! immediate
        does>   2@ swap postpone (+) compile, find.op compile.call ;
        compile-only

: array.def>
        create  dup @ , over , cell+ @ dup , * size @ cell+ , size +! immediate
        does>   dup @ find.op >r dup 3 cells + @ cell- swap cell+ cell+ @ val @
                if      index+ postpone (+) compile,
                else    swap postpone literal postpone literal postpone index+
                        postpone offset+
                then
                r> compile.call val off ;       compile-only

-- the user interface

: self ;

0 constant dummy

: val[
        val on postpone [ ;     immediate

: var
        create  size @ cell+ , size +! immediate
        does>   @ postpone (+) compile, ;

: int
        1 cells var ;

: chr
        1 var ;

: array-of
        ' >body in.class.def? @
        if      array.def>
        else    array.var>
        then ;

: class
        the.class @ the.class off heir off
        abort" not yet finished with previous CLASS"
        create  here the.class ! here 2 cells + , 0 ,
                get-current save-current !
                also here 0 , 0 , dup set-context set-current
                size off in.class.def? on
        does>   in.class.def? @
                if      def>
                else    var>
                then ;

internal definitions

: f:class
        @ dup
        begin   @ dup [ internal ] _dp [ forth ] @ u<
        until
        swap !
        ;

internal

' f:class is-forget class

forth definitions

here cell- body> constant _class        private

?def decompiler [if]
also decompiler

:noname
        ." CLASS " >parm cell+ @ h. ;
        ' class >body 3 cells + tab!

previous
[then]

also internal   ( for deprive-wordlist )

: endclass
        the.class @ 0= abort" use CLASS first"
        get-context deprive-wordlist save-current @ set-current previous
        size @ the.class @ cell+ ! the.class off
        in.class.def? off ;

previous

: 'class
        ' dup >call _class <> abort" no CLASS"
        >body @ ;       private

: inherit-from
        heir @ heir on abort" can't inherit twice"
        'class cell+ local oud get-context cell+ local nieuw
        oud @
        if      nieuw @
                if      nieuw @
                        begin   dup h@
                        while   h@
                        repeat
                        dup oud @ u<
                        abort" can't inherit from younger"
                        oud @ swap h!
                else    oud @ nieuw !
                then
        then ;

\ I can't remember the use of this word:
\ : apply
\       2>r dup @ 2r> findname 0= abort" can't apply APPLY"
\       swap instance execute }} ;

: ^
        instances @ @ cell+ ;   compile-only

?def decompiler [if]

: .ops
        get-context 'class set-context all set-context ;

[then]

: ops
        get-context 'class set-context words set-context ;

deprive
                            \ (* End of Source *) /
