\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Logging of exceptions during compilation 
\ CATEGORY    : Debugging 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : June 11, 1994, Coos Haak 
\ ----------------------------------------------------------------------



        NEEDS -outfile

        MARKER -errorlog



also internal

\G Contains the name of the logfile for compilation errors.
CREATE ERRORLOG        ( -- c-addr )            \ ERRORLOG
        here #64 dup allot erase
        s" error.log" errorlog place

\G Compiled when during loading an undefined word is encountered
\G in a colon definition. As an alias of EVALUATE , it will
\G evaluate a string with the name of the unfound word. This can
\G be used to create forward references.
: FORWARD               ( c-addr u -- )         \ ERRORLOG
        evaluate
        ;

privates

: first-time    ( -- )
        errorlog count file-status nip                  \ new file?
        errorlog count fappend                          \ append to file
        if      push err# push err$
                ." Filename: " errorlog count type      \ write filename
                .signon                                 \ write message
                pop err$ pop err#
        then
        ;  private

: new-session
        retcode @ 0=                                    \ not yet used?
        if      cr ." Log from: "                       \ new item info
                (date) type ." , " .time cr cr          \ data and time
        then
        ;  private

: log-the-error
        source-id 1 < blk @ 0= and                      \ only file or block
        if      exit                                    \ not from terminal
        then                                            \ or in evaluate
        push base decimal                               \ decimal
        push emit ['] femit is emit                     \ save, redirect
        first-time new-session
        parsed-word type space err$ count type
        cr ." Exception " err# .
        blk @
        if      ." in block " blk ?
                ." of " block-file-name count type
                ."  at line " >in @ #64 / .
        else    ." in " errname @ count type space
                ." at line " errline ?
        then
        mark-word cr                                    \ type the line
        fclose                                          \ close the file
        pop emit                                        \ restore
        pop base                                        \ restore
        ?at at-xy                                       \ set cursor right
        retcode incr                                    \ count errors
        ;  private

' log-the-error is log-error                            \ put in vector

: (?crash)      ( x -- )                                \ the handler
        drop                                            \ "word not found"
        #-518 .mess                                     \ "forward reference"
        parsed-word postpone sliteral                   \ compile string
        postpone forward                                \ for later evaluating
        'name errname !
        #lines @ errline !
        log-the-error
        ;  private

' (?crash) is ?crash                                    \ put in vector

deprive

previous

                            \ (* End of Source *) /
