\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Expanded memory access, LIM EMS 4.0
\ CATEGORY    : Utilities 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------



        MARKER -expanded



create emmname  private ", EMMXXXX0"

code emm-present?               ( -- flag )             \ true is ok
                push    bx
                push    si
                push    es
                mov     ax, # $3567
                int     $21
                xor     bx, bx
                mov     di, # #10
                mov     si, # emmname 1+
                mov     cx, # 8
                cld
                repz    cmpsb
                pop     es
                pop     si
        0= if
                dec     bx
        then
                next
end-code

code emm-status
                push    bx
                mov     ah, # $40
                int     $67
                mov     bl, ah
                xor     bh, bh
                next
end-code

code emm-frame
                push    bx
                mov     ah, # $41
                int     $67
                push    bx
                mov     bl, ah
                xor     bh, bh
                next
end-code

code emm-available
                push    bx
                mov     ah, # $42
                int     $67
                push    bx
                mov     bl, ah
                xor     bh, bh
                next
end-code

code emm-total
                push    bx
                mov     ah, # $42
                int     $67
                push    dx
                mov     bl, ah
                xor     bh, bh
                next
end-code

code emm-alloc
                mov     ah, # $43
                int     $67
                push    dx
                mov     bl, ah
                xor     bh, bh
                next
end-code

code emm-map
                mov     dx, bx
                pop     ax
                pop     bx
                mov     ah, # $44
                int     $67
                mov     bl, ah
                xor     bh, bh
                next
end-code

code emm-dealloc
                mov     dx, bx
                mov     ah, # $45
                int     $67
                mov     bl, ah
                xor     bh, bh
                next
end-code

code emm-version
                push    bx
                mov     ah, # $46
                int     $67
                xor     dh, dh
                mov     dl, al
                push    dx
                mov     bl, ah
                xor     bh, bh
                next
end-code

: ?emm
        ?dup
        if      dup $80 = abort" Serious EMM software problem."
                dup $81 = abort" Serious EMM hardware problem."
                dup $82 = abort" The EMM system is BUSY."
                dup $83 = abort" EMM can't find the handle specified."
                dup $84 = abort" Invalid function code passed to EMM."
                dup $85 = abort" No handles are currently available."
                dup $86 = abort" A mapping context restoration error detected."
                dup $87 = over $88 = or
                    abort" Requested pages exceeds available pages."
                dup $89 = abort" Could not allocate ANY pages."
                dup $8A =
                    abort" Logical page to map is not in allocated range."
                dup $8B = abort" Physical page specified is not valid."
                dup $8C = abort" The mapping context save area is full."
                dup $8D =
                    abort" Attempt to save context of already saved handle."
                dup $8E =
                    abort" Attempt to restore context without saving first."
                dup $8F = abort" Subfunction passed is not defined."
                cr ." EMM errorcode is " h. true abort" unknown error in EMM"
        then
        ;

deprive
                            \ (* End of Source *) /
