\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Graphics routines 
\ CATEGORY    : Graphics 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : April 13, 1994, Coos Haak 
\ ----------------------------------------------------------------------



        NEEDS -assembler


        MARKER -graphics



DOC
\ 
\ Suitable for CGA, EGA and VGA
\ 
ENDDOC


0 value maxc
0 value (maxc)
0 value maxxpix
0 value maxypix

vector plot     ( x y -- )      -- Zet een punt in de huidige kleur
vector get-dot  ( x y -- c )    -- Geeft de kleur
vector line     ( x1 y1 x2 y2 -- )
vector draw     ( x y -- )      -- Teken een lijn naar een punt
vector moveto   ( x y -- )      -- Als plot, maar zet geen punt
vector fillarea ( x y -- )      -- Vul vanuit dit punt
vector graphics ( -- )          -- Set graphics mode

0 value color           -- De huidige plotkleur

: set-dot       ( x y c -- )    -- Zet een punt in de gewenste kleur
        to color plot ;

0 value xmax            -- Maximum aantal punten horizontaal
0 value ymax            -- Maximum aantal punten vertikaal
0 value xpix            -- Het huidige punt, relatief t.o.v. xorg
0 value ypix            -- Het huidige punt, relatief t.o.v. yorg

privates

vector change   private ( x y -- f )    -- Moet dit punt een andere kleur krijgen

0 value xorg    private         -- Links
0 value yorg    private         -- Onder
0 value oldcolor        private         -- Voor vergelijking bij fillarea

variable steps  private
variable stepselect     private
variable stepincr       private
variable xhstep private
variable yhstep private
variable xdstep private
variable ydstep private

0 value xleft   private
0 value xright  private
0 value xr      private
0 value yr      private
0 value flg     private

0 value xmidden private
0 value ymidden private
0 value xrand   private
0 value yrand   private

code border     ( n -- )        -- Zet de kleur van de rand
                xor     bh, bh
                mov     ah, # $B
                int     $10
                pop     bx
                next    end-code

code palette    ( n -- )        -- Alleen voor modes 4 en 5
                mov     bh, # 1
                mov     ah, # $B
                int     $10
                pop     bx
                next    end-code

code setpal     ( rood groen blauw n -- )
                pop     cx
                pop     ax
                mov     ch, al
                and     cx, # $3F3F
                pop     dx
                mov     dh, dl
                and     dh, # $3F
                mov     ax, # $1010
                int     $10
                pop     bx
                next    end-code

code getpal     ( n -- rood groen blauw )
                mov     ax, # $1015
                int     $10
$if386
                movzx   dx, dh
                push    dx
                movzx   bx, cl
                movzx   cx, ch
                push    cx
$else
                mov     dl, dh
                xor     dh, dh
                push    dx
                mov     bl, cl
                xor     bh, bh
                mov     cl, ch
                xor     ch, ch
                push    cx
$then
                next    end-code

: black
        clear color ;

: col-1                 -- De laagste, niet zwarte, kleur
        maxc 1 min to color ;

: col-2                 -- De op n na laagste kleur
        maxc 2 min to color ;

: white                 -- De hoogste kleur, (maximaal 15, niet 255)
        maxc to color ;

: gray                  -- Meng kleuren, werkt niet altijd
        color $80 or to color ;

: randcolor             -- Kies een kleur, niet zwart
        maxc choose 1+ to color ;

create grijswaarden     private $300 allot

:noname $40 0 do grijswaarden i $C * + $C i fill loop ;
dup execute dup >body @ internal ldp ! dp ! forth

create dazzling private         here $300 dup allot erase

create systeembuffer    private here $300 dup allot erase

code _sync
                mov     di, ds
                xor     ax, ax
                mov     ds, ax
                mov     dx, $463
                mov     ds, di
                add     dx, # 6
        0 $:    in      al, dx
                and     al, # %1000
                jnz     0 $
        1 $:    in      al, dx
                and     al, # %1000
                jz      1 $
                ret     end-code        private

code setpalettes
                call    ' _sync
                mov     di, si
                mov     si, bx
                mov     cx, # $100
                mov     dx, # $3C8
                xor     al, al
                out     dx, al
                inc     dx
        0 $:    lodsb
                out     dx, al
                lodsb
                out     dx, al
                lodsb
                out     dx, al
                loop    0 $
                mov     si, di
                pop     bx
                next    end-code

code getpalettes
                call    ' _sync
                mov     di, bx
                mov     bx, es
                mov     ax, ds
                mov     es, ax
                mov     cx, # $100
                mov     dx, # $3C7
                xor     al, al
                out     dx, al
                inc     dx
                inc     dx
        0 $:    in      al, dx
                stosb
                in      al, dx
                stosb
                in      al, dx
                stosb
                loop    0 $
                mov     es, bx
                pop     bx
                next    end-code        private

code rel>abs
                mov     ax, adr xmax
                shr     ax, # 1
                pop     dx
                add     ax, dx
                push    ax
                mov     ax, adr ymax
                shr     ax, # 1
                add     bx, ax
                next    end-code        private

code _dot
                mov     cx, adr xpix
                add     cx, adr xorg
                cmp     cx, adr xmax
                jae     0 $
                mov     dx, adr ypix
                add     dx, adr yorg
                cmp     dx, adr ymax
                jae     0 $
                neg     dx
                add     dx, ' maxypix >body
                dec     dx
                xor     bh, bh
                mov     al, adr color []
                mov     ah, # $C
                int     $10
        0 $:    ret     end-code        private

code _get-dot   \ -- al=kleur
                mov     cx, adr xpix
                add     cx, adr xorg
                cmp     cx, adr xmax
                jae     0 $
                mov     dx, adr ypix
                add     dx, adr yorg
                cmp     dx, adr ymax
                jae     0 $
                neg     dx
                add     dx, ' maxypix >body
                dec     dx
                xor     bh, bh
                mov     ah, # $D
                int     $10
        0 $:    ret     end-code        private

code aplot
                mov     adr ypix bx
                pop     adr xpix
                call    ' _dot
                pop     bx
                next    end-code        private

code aget-dot
                mov     adr ypix bx
                pop     adr xpix
                call    ' _get-dot
                xor     bh, bh
                mov     bl, al
                next    end-code        private

code aline
                mov     dx, bx
                pop     cx
                pop     bx
                pop     ax
                mov     adr xpix ax
                mov     adr ypix bx
                sub     dx, bx
                mov     bx, dx
                jns     0 $
                neg     bx
        0 $:    sub     cx, ax
                mov     ax, cx
                jns     1 $
                neg     ax
        1 $:    cmp     ax, bx
                jae     2 $
                mov     steps bx
                shr     bx, # 1
                mov     stepselect bx
                mov     stepincr ax
                mov     xhstep # 0
                mov     yhstep # 1
                test    dx, dx
                jns     3 $
                neg     yhstep
                jmp     3 $
        2 $:    mov     steps ax
                shr     ax, # 1
                mov     stepselect ax
                mov     stepincr bx
                mov     yhstep # 0
                mov     xhstep # 1
                test    cx, cx
                jns     3 $
                neg     xhstep
        3 $:    mov     xdstep # 1
                test    cx, cx
                jns     4 $
                neg     xdstep
        4 $:    mov     ydstep # 1
                test    dx, dx
                jns     5 $
                neg     ydstep
        5 $:    call    ' _dot
                mov     cx, steps
                jcxz    9 $
        6 $:    mov     ax, stepselect
                add     ax, stepincr
                mov     stepselect ax
                cmp     ax, steps
                jae     7 $
                mov     ax, xhstep
                mov     bx, yhstep
                jmp     8 $
        7 $:    sub     ax, steps
                mov     stepselect ax
                mov     ax, xdstep
                mov     bx, ydstep
        8 $:    add     adr xpix ax
                add     adr ypix bx
                push    cx
                call    ' _dot
                pop     cx
                loop    6 $
        9 $:    pop     bx
                next    end-code        private

vector hline    private

code ahline             \ x1 x2 y --    \ x1 < x2
                mov     adr ypix bx
                pop     cx
                pop     ax
                cmp     ax, cx
                jl      0 $
                xchg    ax, cx
        0 $:    mov     adr xpix ax
                sub     cx, ax
                jcxz    2 $
        1 $:    push    cx
                call    ' _dot
                inc     adr xpix
                pop     cx
                loop    1 $
        2 $:    pop     bx
                next    end-code        private

: amove
        to ypix to xpix ;       private

: adraw
        xpix ypix 2swap aline ; private

: <newplot>
        get-dot color <> ;        private

: <oldplot>
        get-dot oldcolor = ;      private

: (scan)
        begin   xr xright > invert
        while   clear flg
                begin   xr yr change xr xright > invert and
                while   true to flg 1 +to xr
                repeat
                flg
                if      xr xr yr change invert xr xright <> or
                        if      1-
                        then
                        yr
                then
                xr
                begin   xr yr change invert xr xright < and
                while   1 +to xr
                repeat
                xr =
                if      1 +to xr
                then
        repeat ;        private

: afill
        2dup get-dot color of     2drop exit
        then
        to oldcolor depth 2 - >r
        begin   2dup aplot to yr dup 1+ to xr
                begin   xr yr change
                while   xr yr aplot 1 +to xr
                repeat
                xr 1- to xright to xr -1 +to xr
                begin   xr yr change
                while   xr yr aplot -1 +to xr
                repeat
                xr 1+ dup to xleft to xr yr 1+ ymax 1- min to yr (scan)
                xleft to xr yr 2 - 0 max to yr (scan)
                depth r@ =
                ?stack
        until
        r>drop ;        private

-- De relatieve versies, normaal met de oorsprong in het midden

: rplot
        rel>abs aplot ; private

: rget-dot
        rel>abs aget-dot ;        private

: rline
        2>r rel>abs 2r> rel>abs aline ; private

: rmove
        rel>abs amove ; private

: rdraw
        rel>abs adraw ; private

: rfill
        rel>abs afill ; private

: rhline
        rel>abs 2>r 0 rel>abs drop 2r> ahline ; private

: grijs
        grijswaarden setpalettes ;

: kleur
        systeembuffer setpalettes ;

: circle        ( x y r -- )
        dup>r to xmidden clear ymidden moveto xpix to xrand ypix to yrand
        1 r> 2 lshift -
        begin   xmidden ymidden 4 0
                do      over xrand + over yrand + aplot
                        negate
                        over xrand + over yrand + aplot
                        swap
                loop
                2drop 1 +to ymidden ymidden 2* 1+ 2 lshift + dup 0>
                if      -1 +to xmidden 1 xmidden - 3 lshift +
                then
                xmidden ymidden <
        until
        drop xrand yrand amove ;

: disk          ( x y r -- )
        dup>r to xmidden clear ymidden moveto xpix to xrand ypix to yrand
        1 r> 2 lshift -
        begin   ymidden xmidden 2 0
                do      over xrand + over yrand + 2>r
                        over xrand + over negate yrand + 2r> aline
                        swap
                        over negate xrand + over yrand + 2>r
                        over negate xrand + over negate yrand + 2r> aline
                loop
                2drop 1 +to ymidden ymidden 2* 1+ 2 lshift + dup 0>
                if      -1 +to xmidden 1 xmidden - 3 lshift +
                then
                xmidden ymidden <
        until
        drop xrand yrand amove ;

: box           ( x1 y1 x2 y2 -- )
        2>r 2dup over r@ line r' r> draw dup r> swap draw draw ;

: fillbox       ( x1 y1 x2 y2 -- )
        rot 2dup max 1+ -rot min
        do      2dup i hline
        loop
        2drop ;

\ --            Vul de gehele omtrek
: newplot
        ['] <newplot> is change ;

\ --            Vul tot waar de kleur verandert, dus de oude kleur
: oldplot
        ['] <oldplot> is change ;

\ --            Oorsprong linksonder, uiteraard niet linksboven
: absplot
        ['] aplot is plot
        ['] aget-dot is get-dot
        ['] aline is line
        ['] ahline is hline
        ['] amove is moveto
        ['] adraw is draw
        ['] afill is fillarea ;

\ --            Oorsprong in het midden
: relplot
        ['] rplot is plot
        ['] rget-dot is get-dot
        ['] rline is line
        ['] rhline is hline
        ['] rmove is moveto
        ['] rdraw is draw
        ['] rfill is fillarea ;

\ --            Als Print Screen Toets, GRAPHICS onder DOS eerst laden
code screendump
                int     5
                next    end-code

: (gr')
        to maxypix to maxxpix dup to (maxc) $F and to maxc
        white newplot
        clear xorg maxxpix to xmax
        clear yorg maxypix to ymax
        systeembuffer getpalettes ;     private

absplot

: graphicsprompt
        push base hex
        getmode 0 <# '>' hold # # #> type
        pop base
        ;  private

: (graphics)
        ['] graphicsprompt is prompt setmode clear text?
        ;  private

: cres
        4 (graphics) 3 #320 #200 (gr')
        ;

: lres-
        6 (graphics) 1 #640 #200 (gr')
        ;

: lres
        $E (graphics) $F #640 #200 (gr')
        ;

: mres-
        $F (graphics) 1 #640 #350 (gr')
        ;

: mres
        $10 (graphics) $F #640 #350 (gr')
        ;

: hres-
        $11 (graphics) 1 #640 #480 (gr')
        ;

: hres
        $12 (graphics) $F #640 #480 (gr')
        ;

: vres
        $13 (graphics) $FF #320 #200 (gr')
        ;

: vres+
        $5F (graphics) $FF #640 #480 (gr')
        ;

' hres is graphics

( adr -- )
: shiftpalette
        3 + local my_pal
        my_pal count swap count swap c@
        my_pal 3 + my_pal $2FA cmove
        my_pal $2FC + c!
        my_pal $2FB + c!
        my_pal $2FA + c!
        my_pal 3 - setpalettes ;        private

: dazzle
        dazzling getpalettes $3FC 0
        do      dazzling shiftpalette stop? ?leave
        loop ;

: change-colors
        dazzling getpalettes
        dazzling $2FD + count local r count local g c@ local b
        #1000 0
        do
                r 3 choose 1- + dup to r dazzling $2FD + c!
                g 3 choose 1- + dup to g dazzling $2FE + c!
                b 3 choose 1- + dup to b dazzling $2FF + c!
                dazzling 6 + dazzling 3 + $2FA cmove
                dazzling setpalettes stop? ?leave
        loop
        ;

: change-grays
        dazzling getpalettes
        dazzling $2FD + count swap count swap c@ + + 3 / local tint
        #1000 0
        do
                dazzling 6 + dazzling 3 + $2FA cmove
                dazzling $2FD + 3 tint 3 choose 1- + dup to tint fill
                dazzling setpalettes stop? ?leave
        loop
        ;

create palpath  private ", f:\fonts\"

: preparepalpath
        palpath count temporary pack append s" .pal" temporary append
        temporary count
        ;  private

: (savepalette)
        preparepalpath w/o bin create-file throw >r
        grijswaarden $300 r@ write-file throw
        r> close-file throw ;

: savepalette
        bl word count (savepalette) ;

: (loadpalette)
        preparepalpath r/o bin open-file throw >r
        grijswaarden $300 r@ read-file throw drop
        $30 s>d r@ reposition-file throw
        grijswaarden $30 + $2D0 r@ read-file throw drop
        r> close-file throw ;

: loadpalette
        bl word count (loadpalette) ;

: loadwinpalette
        grijswaarden $300 erase
        s" .pal" bl word append
        here count r/o bin open-file throw local h
        grijswaarden $32 h read-file throw drop
        grijswaarden 1+ c@ 0
        do      grijswaarden i 3 * + 4 h read-file throw drop
                grijswaarden i 3 * +
                dup c@ 4 rshift over c! 1+
                dup c@ 4 rshift over c! 1+
                dup c@ 4 rshift swap c!
        loop
        h close-file throw ;
                
deprive

                            \ (* End of Source *) /
