\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's
\ DESCRIPTION : Interrupt vectors
\ CATEGORY    : Utilities
\ AUTHOR      : Coos Haak
\ LAST CHANGE : July 22, 1994, Coos Haak
\ ----------------------------------------------------------------------



        MARKER -intvec


internal also definitions

doer: dointvec  ( addr -- x-addr )                  \ get the value
        c@ get-interrupt
    ;

: f:intvec      ( addr -- )                         \ reset the vector to its
        count >r 2@ r> set-interrupt                \ default value
    ;  compile-only

' f:intvec is-forget dointvec                       \ store forget code

forth definitions

methods dointvec

: from          ( "name" -- x )                     \ get the interrupt number.
        c@ postpone literal
    ;

: to            ( addr "name" -- )                  \ set new value, in CSEG !
        postpone cseg postpone swap                 \ extended address
        c@ postpone literal                         \ interrupt number
        postpone set-interrupt                      \ set new vector
    ;

: clear         ( "name" -- )                       \ reset to initial value
        postpone literal postpone f:intvec
    ;

: adr           ( "name" -- addr )                  \ storage address
        char+ postpone literal                      \ use with care
    ;

end-methods

\G Skip leading space delimiters. Parse name delimited by a space.
\G Create a definition for name with the execution semantics defined
\G below. Name is referred to as an "interrupt vector".
\G
\G name Executing: ( -- x-addr )
\G Place x-addr, the extended address of the current vector assigned
\G to interrupt number x. The value of this vector can be changed by
\G executing 'addr TO name', can be reset to its initial value by
\G 'CLEAR name' and the number x can be obtained by executing 'FROM
\G name'. To get the address where the default value is stored, use
\G 'ADR name'.
: INTVEC        ( x "name" -- )                     \ INTVEC "interrupt-vector"
        create  dup c, get-interrupt 2, align
        dointvec
    ;

previous forth

                            \ (* End of Source *) /
