\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Memory manager 
\ CATEGORY    : Utilities 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------



cr
cr .( The memory manager changes LIMIT, this is at the moment)
cr .( not allowed because of the FLYER buffers on top of it.)
cr .( Also, the memory manager is not standard, is uses handles)
cr .( not adresses.)
cr abort

        MARKER -memory



DOC
-- Works different from ANS standard Forth
-- Uses handles instead of real adresses
-- Get the addres with @
-- Get the size allocated with ALLOCATED
ENDDOC


privates

create oldlimit         private
        limit ,

:noname
        @ ['] limit >body !
        ;  ' oldlimit >head head>forget h!

variable heapsize       private
variable heap           private
variable endheap        private

variable ^heap  private         ^heap off
variable ^alloc private         ^alloc off
variable ^free  private

warning @ warning off
: allot
        dup unused #1000 - 0 max > abort" memory full" allot ;
warning !

: available             ( -- u )
        ^alloc @ ^heap @ - cell- cell- ;

$-60 constant mem:neg   private
$-61 constant mem:unav  private
$-62 constant mem:nohdl private
$-63 constant mem:i,non private
$-64 constant mem:i,neg private
$-65 constant mem:i,ovr private

mem:neg         mess" no negative allocation permitted"
mem:unav        mess" not enough memory"
mem:nohdl       mess" addres outside the memory allocation"
mem:i,non       mess" give a value for the size of the heap"
mem:i,neg       mess" no negative value for the size of the heap"
mem:i,ovr       mess" too much memory for size the heap asked"

: init-mem
        depth 0= mem:i,non ?error
        dup 0< mem:i,neg ?error
        6 + dup available unused + u< invert mem:i,ovr ?error
        heapsize ! [ limit ] literal endheap !
        endheap @ heapsize @ - dup heap ! [ ' limit >body ] literal !
        heap @ heapsize @ erase
        heap @ ^heap !
        endheap @ cell- ^alloc !
        ^free off ;

: adjust.handles
        swap negate endheap @ ^alloc @ cell+
        do      i @ pluck ^alloc @ cell+ within
                if      dup i +!
                then
                1 cells
        +loop
        2drop ; private

: get.handle
        ^free @ ?dup
        if      dup @ ^free !
        else    ^alloc @ -1 cells ^alloc +!
        then ;  private

: release.handle
        ^free @ over ! ^free ! ;        private

: allocated             ( hdl -- u )
        @ cell- @ ;

: ?allocate             ( f -- )
        throw ;

: allocate              ( u -- hdl ior )
        local lengte
        lengte 0<
        if      false mem:neg exit
        then
        lengte available >
        if      false mem:unav exit
        then
        get.handle local handle
        ^heap @ cell+ handle !
        lengte ^heap @ !
        lengte cell+ ^heap +!
        handle false ;

: free                  ( hdl -- ior )
        local handle
        handle endheap @ heap @ within
        if      mem:nohdl exit
        then
        handle dup allocated cell+ handle @ cell- 2dup + dup>r
        swap ^heap @ r@ - move
        dup negate ^heap +! swap release.handle r> adjust.handles
        false ;

: resize                ( hdl1 u -- hdl2 ior )
        local size local old
        old endheap @ heap @ within
        if      false mem:nohdl exit
        then
        size allocate ?dup
        if      exit
        then
        local new
        old @ new @ old allocated new allocated umin move
        old free ?dup
        if      false swap exit
        then
        new false ;

deprive

unused u2/ init-mem
                            \ (* End of Source *) /
