\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Quadruple precision operators 
\ CATEGORY    : Utilities 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------



        NEEDS -double

        MARKER -quad



code knegate
                push    bx
                xchg    sp, bp
                mov     cx, # 8
                mov     di, # 14
        0 $:    not     0 [bp+di]
                dec     di
                dec     di
                loop    0 $
                mov     di, # 12
                mov     cx, # 7
                add     14 [bp], # 1
        1 $:    adc     0 [bp+di], # 0
                dec     di
                dec     di
                loop    1 $
                xchg    sp, bp
                pop     bx
                next    end-code

: ?knegate
        0<
        if      knegate
        then ;

: kabs
        dup ?knegate ;

: q>k
        2dup s>d -rot s>d ;

code sqrt
                pop     ax
                mov     cx, ax
                or      cx, bx
                jnz     0 $
                mov     bx, ax
                next
        0 $:    mov     di, # 1
                xor     dx, dx
                mov     cx, # 14
        1 $:    add     ax, ax
                adc     bx, bx
                adc     dx, dx
                add     ax, ax
                adc     bx, bx
                adc     dx, dx
                sub     dx, di
                jae     2 $
                add     dx, di
                dec     di
                jmp     3 $
        2 $:    inc     di
        3 $:    add     di, di
                inc     di
                loop    1 $
                add     ax, ax
                adc     bx, bx
                adc     dx, dx
                add     ax, ax
                adc     bx, bx
                adc     dx, dx
                jae     4 $
                sub     dx, di
                inc     di
                jmp     6 $
        4 $:    cmp     dx, di
                jae     5 $
                dec     di
                jmp     6 $
        5 $:    sub     dx, di
                inc     di
        6 $:    cmp     dh, # $80
                jz      7 $
                add     ax, ax
                adc     bx, bx
                adc     dx, dx
                sub     bx, # $8000
                sbb     dx, di
                jb      8 $
        7 $:    inc     di
        8 $:    mov     bx, di
                next    end-code

: 4swap
        7 roll 7 roll 7 roll 7 roll ;

code 4drop
                add     sp, # 6
                pop     bx
                next    end-code

code 4nip
                pop     ax
                pop     cx
                pop     dx
                add     sp, # 8
                push    dx
                push    cx
                push    ax
                next    end-code

: 4over
        7 pick 7 pick 7 pick 7 pick ;

: 8dup
        4over 4over ;

code q0<
                add     sp, # 6
                shl     bx, # 1
                sbb     bx, bx
                next    end-code

code q0=
                pop     cx
                or      bx, cx
                pop     cx
                or      bx, cx
                pop     cx
                or      bx, cx
                mov     bx, # 0
                jnz     0 $
                dec     bx
        0 $:    next    end-code

code q0>
                test    bx, bx
                jns     0 $
                xor     bx, bx
                add     sp, # 6
                next
        0 $:    pop     ax
                or      ax, bx
                xor     bx, bx
                pop     cx
                or      ax, cx
                pop     cx
                or      ax, cx
                jz      1 $
                dec     bx
        1 $:    next    end-code

privates

: d#s
        begin   base @ 0 dmu/mod 2rot drop 9 over <
                if      7 +
                then
                '0' + hold 4dup q0=
        until
        2drop ; private

: (q.)
        dup>r qabs <# d#s r> sign #> ;  private

: (qu.)
        <# d#s #> ;     private

: q.
        (q.) type space ;

: q.r
        >r (q.) r> over - spaces type ;

: qu.
        (qu.) type space ;

: qu.r
        >r (qu.) r> over - spaces type ;

code 4>r
                sub     bp, # 8
                mov     0 [bp], bx
                pop     2 [bp]
                pop     4 [bp]
                pop     6 [bp]
                pop     bx
                next    end-code

code 4r>
                push    bx
                push    6 [bp]
                push    4 [bp]
                push    2 [bp]
                mov     bx, 0 [bp]
                add     bp, # 8
                next    end-code

code 4r@
                push    bx
                push    6 [bp]
                push    4 [bp]
                push    2 [bp]
                mov     bx, 0 [bp]
                next    end-code

code q+
                pop     cx
                pop     dx
                pop     ax
                xchg    sp, bp
                add     6 [bp], ax
                adc     4 [bp], dx
                adc     2 [bp], cx
                xchg    sp, bp
                pop     ax
                adc     ax, bx
                mov     bx, ax
                next    end-code

: q-
        qnegate q+ ;

code q<
                pop     cx
                pop     dx
                pop     ax
                xchg    sp, bp
                sub     6 [bp], ax
                sbb     4 [bp], dx
                sbb     2 [bp], cx
                xchg    sp, bp
                pop     ax
                sbb     ax, bx
                jge     0 $
                mov     bx, # true
                jmp     1 $
        0 $:    xor     bx, bx
        1 $:    add     sp, # 6
                next    end-code

: q=
        q- q0= ;

: q>
        4swap q< ;

code qu<
                xor     bx, # $8000
                xchg    sp, bp
                xor     6 [bp], # $8000
                xchg    sp, bp
                jmp     ' q<    end-code

: qu>
        4swap qu< ;

: qmax
        8dup q<
        if      4nip
        else    4drop
        then ;

: qmin
        8dup q>
        if      4nip
        else    4drop
        then ;

: qumax
        8dup qu<
        if      4nip
        else    4drop
        then ;

: qumin
        8dup qu>
        if      4nip
        else    4drop
        then ;

code q2/
                xchg    sp, bp
                sar     bx, # 1
                rcr     0 [bp], # 1
                rcr     2 [bp], # 1
                rcr     4 [bp], # 1
                xchg    sp, bp
                next    end-code

code q2*
                xchg    sp, bp
                shl     4 [bp], # 1
                rcl     2 [bp], # 1
                rcl     0 [bp], # 1
                rcl     bx, # 1
                xchg    sp, bp
                next    end-code

code qum*
                push    bx
                sub     sp, # 8
                xchg    sp, bp
                xor     ax, ax
                xchg    22 [bp], ax
                mov     6 [bp], ax
                xor     ax, ax
                xchg    20 [bp], ax
                mov     4 [bp], ax
                xor     ax, ax
                xchg    18 [bp], ax
                mov     2 [bp], ax
                xor     ax, ax
                xchg    16 [bp], ax
                mov     0 [bp], ax
                mov     cx, # 64
        0 $:    shl     22 [bp], # 1
                rcl     20 [bp], # 1
                rcl     18 [bp], # 1
                rcl     16 [bp], # 1
                rcl     14 [bp], # 1
                rcl     12 [bp], # 1
                rcl     10 [bp], # 1
                rcl     8 [bp], # 1
                jae     1 $
                mov     ax, 6 [bp]
                add     22 [bp], ax
                mov     ax, 4 [bp]
                adc     20 [bp], ax
                mov     ax, 2 [bp]
                adc     18 [bp], ax
                mov     ax, 0 [bp]
                adc     16 [bp], ax
                adc     14 [bp], # 0
                adc     12 [bp], # 0
                adc     10 [bp], # 0
                adc     8 [bp], # 0
        1 $:    loop    0 $
                xchg    sp, bp
                add     sp, # 8
                pop     bx
                next    end-code

code qum/mod
                push    bx
                xchg    sp, bp
                mov     cx, # 64
        0 $:    shl     22 [bp], # 1
                rcl     20 [bp], # 1
                rcl     18 [bp], # 1
                rcl     16 [bp], # 1
                rcl     14 [bp], # 1
                rcl     12 [bp], # 1
                rcl     10 [bp], # 1
                rcl     8 [bp], # 1
                jae     1 $
                mov     ax, 6 [bp]
                sub     14 [bp], ax
                mov     ax, 4 [bp]
                sbb     12 [bp], ax
                mov     ax, 2 [bp]
                sbb     10 [bp], ax
                mov     ax, 0 [bp]
                sbb     8 [bp], ax
                jmp     2 $
        1 $:    mov     ax, 6 [bp]
                sub     14 [bp], ax
                mov     ax, 4 [bp]
                sbb     12 [bp], ax
                mov     ax, 2 [bp]
                sbb     10 [bp], ax
                mov     ax, 0 [bp]
                sbb     8 [bp], ax
                jae     2 $
                mov     ax, 6 [bp]
                add     14 [bp], ax
                mov     ax, 4 [bp]
                adc     12 [bp], ax
                mov     ax, 2 [bp]
                adc     10 [bp], ax
                mov     ax, 0 [bp]
                adc     8 [bp], ax
                sub     22 [bp], # 1
                sbb     20 [bp], # 0
                sbb     18 [bp], # 0
                sbb     16 [bp], # 0
        2 $:    add     22 [bp], # 1
                adc     20 [bp], # 0
                adc     18 [bp], # 0
                adc     16 [bp], # 0
                dec     cx
                jcxz    3 $
                jmp     0 $
        3 $:    mov     cx, # 4
        4 $:    mov     ax, 8 [bp]
                xchg    16 [bp], ax
                mov     8 [bp], ax
                inc     bp
                inc     bp
                loop    4 $
                xchg    sp, bp
                pop     bx
                next    end-code

: qm*
        dup>r qabs 4swap dup>r qabs qum* 2r> xor ?knegate ;

' qm* alias q*k

: q*
        q*k 4drop ;

: qm/mod
        4 pick >r 4>r kabs 4r> dup>r qabs qum/mod r> r@ xor ?qnegate
        4swap r> ?qnegate 4swap ;

: q/mod
        4>r q>k 4r> qm/mod ;

: q/
        q/mod 4nip ;

: qmod
        q/mod 4drop ;

: qu*/mod
        4>r qum* 4r> qum/mod ;

: qu*/
        qu*/mod 4nip ;

: q*/mod
        4>r q*k 4r> qm/mod ;

: q*/
        q*/mod 4nip ;

deprive
                            \ (* End of Source *) /
