\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Sound routines 
\ CATEGORY    : Utilities 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------



        NEEDS -graphics

        MARKER -sounds



vocabulary soundlib
vocabulary sound

sound also soundlib definitions also

0 value oktaaf
0 value x-offset
0 value y-offset
0 value x-width
0 value kleur

: !char
        to color x-offset y-offset x-offset x-width + 80 fillbox ;

 7 constant w-
w- 8 + constant w+
 6 constant z-
z- 8 + constant z+

: keys
        create  , , , , ,
        does>   @+ to x-offset @+ to y-offset @+ to x-width @+ to kleur @
                oktaaf 91 * +to x-offset !char ;

w+ w- 8 00 00 keys c;
z+ z- 6 10 09 keys cis;
w+ w- 6 00 15 keys d;
z+ z- 6 10 22 keys dis;
w+ w- 8 00 28 keys e;
w+ w- 8 00 39 keys f;
z+ z- 6 10 48 keys fis;
w+ w- 6 00 54 keys g;
z+ z- 6 10 61 keys gis;
w+ w- 6 00 67 keys a;
z+ z- 6 10 74 keys bes;
w+ w- 8 00 80 keys b;

: display
        12 - 12 /mod to oktaaf
        exec:   c; cis; d; dis; e; f; fis; g; gis; a; bes; b; ;

: discard
        kleur !char ;

4096 constant +1

variable graph          graph on
variable echo           echo off
variable length         1000 length !
variable fraction       +1 fraction !
variable tempo          60 tempo !
variable unit           250 unit !
variable octave         4 octave !
variable speed          +1 speed !
variable slowingrate    5000 slowingrate !
variable ?ritard        ?ritard off
variable resting        -4 resting !

: fraction:
        create  +1 swap / ,
        does>   @ * fraction ! ;

: setrest
        create  ,
        does>   @ resting ! ;

sound definitions

-2 setrest staccato  \ 1/4
-3 setrest normrest  \ 1/8
 0 setrest legato

 1 fraction: /1
 2 fraction: /2
 3 fraction: /3
 4 fraction: /4
 6 fraction: /6
 8 fraction: /8
12 fraction: /12
16 fraction: /16
24 fraction: /24
32 fraction: /32
64 fraction: /64

soundlib definitions

: seconds
        1000 * slowingrate ! ;

sound definitions

: poco
        slowingrate @ slowingrate +! ;

: ritardando
        ?ritard on ;

: a.tempo
        +1 speed ! 60 unit @ tempo @ */ length ! 5 seconds ?ritard off ;

: vivace
        tempo @ 11 10 */ tempo ! a.tempo ;

: non.troppo
        tempo @ 10 11 */ tempo ! a.tempo ;

soundlib definitions

: measure
        +1 1000 fraction @ */ unit ! a.tempo ;

: metronome:
        create  ,
        does>   @ tempo ! 1 /4 measure a.tempo ;

sound definitions

 40 metronome: lente
 52 metronome: largo
 63 metronome: larghetto
 76 metronome: adagio
 92 metronome: andante
116 metronome: moderato
144 metronome: allegro
184 metronome: presto
204 metronome: prestissimo
400 metronome: superprestissimo

: pause
        length @ fraction @ speed @ */ ms ;

soundlib definitions

: shift
        dup 0<
        if      abs rshift
        else    lshift
        then ;

: note:
        create  , ,
        does>   @+ swap @ octave @ 12 * + graph @
                if      display
                else    drop
                then
                octave @ 4 - shift >r length @ fraction @ speed @ */
                ?ritard @
                if      dup speed @ slowingrate @ */ negate speed +!
                then
                resting @
                if      dup resting @ shift tuck - r> tone ms
                else    r> tone
                then
                graph @
                if      discard
                then
                ;

: (+-)
        octave @ + 2 max 7 min octave ! ;

sound definitions

0 262 note: c
1 277 note: cis
1 277 note: des
2 294 note: d
3 311 note: dis
3 311 note: es
4 330 note: e
5 349 note: f
6 370 note: fis
6 370 note: ges
7 392 note: g
8 415 note: gis
8 415 note: as
9 440 note: a
10 466 note: ais
10 466 note: bes
11 494 note: b

: ++
        1 (+-) ;

: --
        -1 (+-) ;

: middle
        4 octave ! ;

: |:
        s" 2 0 do" evaluate ;
        immediate compile-only

: :|
        s" loop" evaluate ;
        immediate compile-only

forth definitions

: graphic
        graph on
        ;

: -graphic
        graph off
        ;

: keyboard
        [ sound ]
        1 /64 1 octave ! 6 0
        do      c cis d dis e f fis g gis a bes b ++
        loop
        allegro middle ;

allegro middle

-2 set-order definitions

                            \ (* End of Source *) /
