\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Turtle routines 
\ CATEGORY    : Graphics 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------



        NEEDS -gonio
        NEEDS -graphics

        MARKER -turtle



DOC
  Kees Moerman, Vijgeblad 10
  Lennart Benschop, Vijgeblad 29
ENDDOC

code tfr
                mov     ax, # $2800
                imul    bx
                mov     bx, dx
                next    end-code

0 value tx
0 value ty

privates

0 value phi     private

: phi!
        360 mod to phi ;

0 value pen     private

: penup
        clear pen ;     ' penup alias pu

: pendown
        true to pen ;   ' pendown alias pd

: right
        phi + phi! ;    ' right alias rt

: left
        negate right ;  ' left alias lt

: forward
        0 swap 360 phi - rotate +to ty +to tx tx tfr ty tfr pen
        if      draw
        else    moveto
        then ;  ' forward alias fd

: back
        negate forward ;        ' back alias bk

: setturtle
        to ty to tx 0 phi! penup 0 forward pendown ;

false [if]

: doturtle
        pen phi tx ty color
        gray 45 right pendown 100 back penup 100 forward 90 left
        pendown 100 back penup 100 forward 45 right
        to color setturtle phi! to pen ;        private

: [key]
        doturtle <key> doturtle ;       private

: showturtle
        ['] [key] is key ;

: hideturtle
        ['] <key> is key ;

[else]

' noop alias showturtle
' noop alias hideturtle

[then]

' showturtle alias st

' hideturtle alias ht

: turtle
        relplot decimal 0 0 setturtle
        ( showturtle ) ;        ' turtle alias gr

: vu
        page 0 0 setturtle ;

deprive
                            \ (* End of Source *) /
