\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Two and three dimensional vectors 
\ CATEGORY    : Utilities 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------



        MARKER -vectors



: v+!
        tuck +! cell+ +!
        ;

: 3v@
        dup 2 cells + @ swap 2@
        ;

: 3v!
        tuck ! cell+ tuck ! cell+ !
        ;

: 3v+!
        tuck +! cell+ tuck +! cell+ +!
        ;

: 3v0!
        dup d0! 2 cells + off
        ;

: vec
        create  0 , 0 ,
        does>   2@
        ;

methods vec

: to
        postpone literal postpone 2!
        ;

: +to
        postpone literal postpone v+!
        ;

: clear
        postpone literal postpone d0!
        ;

end-methods

: 3vec
        create  0 , 0 , 0 ,
        does>   3v@
        ;

methods 3vec

: to
        postpone literal postpone 3v!
        ;

: +to
        postpone literal postpone 3v+!
        ;

: clear
        postpone literal postpone 3v0!
        ;

end-methods

code v+
                pop     ax
                pop     cx
                pop     dx
                add     ax, dx
                push    ax
                add     bx, cx
                next
end-code

code v-
                pop     ax
                pop     cx
                pop     dx
                sub     dx, ax
                push    dx
                sub     cx, bx
                mov     bx, cx
                next
end-code

code vnegate
                pop     ax
                neg     ax
                push    ax
                neg     bx
                next
end-code

code v*
                pop     cx
                pop     ax
                mul     bx
                push    ax
                mov     ax, cx
                mul     bx
                mov     bx, ax
                next
end-code

code v/
                pop     cx
                pop     ax
                cwd
                idiv    bx
                push    ax
                mov     ax, cx
                cwd
                idiv    bx
                mov     bx, ax
                next
end-code

code v*/
                pop     cx
                pop     di
                pop     ax
                imul    cx
                idiv    bx
                push    ax
                mov     ax, di
                imul    cx
                idiv    bx
                mov     bx, ax
                next
end-code

privates

: (v.)
        6 .r
        ;  private

: v.
        swap (v.) (v.) space
        ;

deprive
                            \ (* End of Source *) /
