\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Virtual memory without blocks
\ CATEGORY    : Tools
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : July 18, 1994, Coos Haak 
\ ----------------------------------------------------------------------



        MARKER -virtual


privates

create vfile                                \ the filename
        here #64 dup allot erase
s" virtual.dat" vfile place

0 value vhdl                        private \ the file handle

: vopen
    vhdl                                    \ is already open
    if      exit
    then
    vfile count file-status nip
    if      vfile count r/o create-file     \ did not exist
    else    vfile count r/w open-file       \ reopen old file
    then
    throw to vhdl                           \ keep handle
    ;

: vclose
    vhdl                                    \ is still open
    if      vhdl close-file throw           \ close the file
            clear vhdl                      \ signal no open file
    then
    ;

create vbuffer  #256 allot          private \ a buffer for virtual interface

\G Store x at the long virtual address d.
: V!        ( x d -- )                      \ VIRTUAL "v-store"
    vhdl reposition-file throw              \ set filepointer
    vbuffer !                               \ keep number in buffer
    vbuffer 1 cells vhdl write-file throw   \ write the buffer
    ;

\G Fetch x from the long virtual address d.
: V@        ( d -- x )                      \ VIRTUAL "v-fetch"
    vhdl reposition-file throw              \ set filepointer
    vbuffer 1 cells vhdl read-file throw    \ read into the buffer
    drop                                    \ ingnore to small reads (?)
    vbuffer @                               \ get the number
    ;

\G Store char at the long virtual address d.
: VC!       ( char d -- )                   \ VIRTUAL "v-c-store"
    vhdl reposition-file throw              \ set filepointer
    vbuffer c!                              \ keep character in buffer
    vbuffer 1 chars vhdl write-file throw   \ write the buffer
    ;

\G Fetch char from the long virtual address d.
: VC@       ( d -- char )                   \ VIRTUAL "v-c-fetch"
    vhdl reposition-file throw              \ set filepointer
    vbuffer 1 chars vhdl read-file throw    \ read into the buffer
    drop                                    \ ingnore to small reads (?)
    vbuffer c@                              \ get the character
    ;

\G Store string c-addr u at the long virtual address d.
: VS!       ( c-addr u d -- )               \ VIRTUAL "v-s-store"
    vhdl reposition-file throw              \ set filepointer
    vhdl write-file throw                   \ write the string
    ;

\G Fetch string c-addr u1 from the long virtual address d. True
\G read length u2.
: VS@       ( c-addr u1 d -- u2 )           \ VIRTUAL "v-s-fetch"
    vhdl reposition-file throw              \ set filepointer
    vhdl read-file throw                    \ read the string
    ;

deprive

                            \ (* End of Source *) /
