\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : CHForth, a Dutch public domain ANS Forth for PC's 
\ DESCRIPTION : Messages and strings 
\ CATEGORY    : CHForth 
\ AUTHOR      : Coos Haak 
\ LAST CHANGE : May 16, 1994, Coos Haak 
\ ----------------------------------------------------------------------


        ?DEF -messages [IF] -messages [THEN]

        MARKER -messages


DOC
   .STRS   print all the strings.
   .MESS   print all the messages.
ENDDOC


privates

internal

: .mess
        0 local teller mess-link
        push base decimal
        begin   cr dup h. dup @+ h. @+ dup $FF00 0 within
                if      ." ANSI" 8 .r space
                else    dup $FE00 u>
                        if      ." MS-DOS" $FF and 6 .r space
                        else    dup $FD00 u>
                                if      ." CHForth" 5 .r space
                                else    ." Other" 7 .r space
                                then
                        then
                then
                count type
50 ms
                @ dup 0= stop? or 1 +to teller
        until
        cr drop teller .
        pop base
        ;

0 value codestring      private

: findstring
        clear codestring
        begin   dup cell+ swap l@
                case
                ['] (postpone) of       cell+   endof
                ['] (lit) of    cell+   endof
                ['] (chr) of    cell+   endof
                ['] (tic) of    cell+   endof
                ['] (.") of     c" ." true exit endof
                ['] (s") of     c" S" true dup to codestring exit endof
                ['] (c") of     c" C" true dup to codestring exit endof
                ['] (abort") of c" ABORT" true exit     endof
[ ?def -decompiler ] [if]
[ decompiler ' \" >body @ cell+ l@ forth ] literal
                        of      c" \" true exit endof
[then]
                endcase
                dup lhere =
        until
        false
        ;  private

forth

: stypestring
        lseg swap countx stypex
        ;  private

: .strs
        0 local teller 0
        begin   findstring
        while   cr over lseg swap x. codestring
                if      over cseg swap l@ x.
                else    #10 spaces
                then
                count type '"' emit space
                codestring
                if      dup cell+ swap l@ count stype
                else    dup stypestring dup lc@ 1+ aligned +
                then
                '"' emit 1 +to teller
50 ms
                stop?
        until   then
        cr drop teller .dec
        ;

deprive

100 mess" Bericht honderd"
101 mess" Bericht honderdeen"
102 mess" Bericht honderdtwee"

                            \ (* End of Source *) /
