\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : Meta compiler for CHForth version 1.1.0 
\ FILENAME    : INPUT.FRT 
\ DESCRIPTION : Keyboard input routines  
\ AUTHOR      : Coos Haak, Utrecht 
\ CREATED     : May 11, 1994
\ ----------------------------------------------------------------------



EXTRA:

\G Set input and output to fast BIOS routines, redirection is not
\G supported.
\G See also: MS-DOS-IO
: BIOS-IO       ( -- )                  \ EXTRA
        TRUE TO BIOS?
        ;

\G Set input and output to slow DOS routines, redirection is
\G supported.
\G See also: BIOS-IO CONSOLE! CONSOLE@
: MS-DOS-IO     ( -- )                  \ EXTRA
        CLEAR BIOS?
        ;

INTERNAL:

\ If a key is pressed, give its extended value and a true flag
\ else return a false flag.
CODE GETKEY             ( -- x true | false )
                PUSH    BX
                XOR     BX, BX
                XOR     CX, CX
                TEST    T' BIOS? # TRUE                 \ bios allowed?
                JZ      5 $
$IF386
                MOV     AH, # 11
                INT     16
                JZ      4 $
                MOV     AH, # 10
                INT     16
                CMP     AL, # E0
                JZ      1 $
                TEST    AL, AL
                JNZ     2 $
        1 $:
$ELSE
                MOV     AH, # 1
                INT     16
                JZ      4 $
                MOV     AH, # 0
                INT     16
                TEST    AL, AL
                JNZ     2 $
$THEN
                MOV     CH, AH
                JMP     3 $
        2 $:    MOV     CL, AL
        3 $:    PUSH    CX
                DEC     BX
        4 $:    NEXT
        5 $:    MOV     AH, # B
                INT     21
                TEST    AL, AL
                JZ      4 $
                MOV     AH, # 8
                INT     21
$IF386
                CMP     AL, # E0
                JZ      1 $
$THEN
                OR      AL, AL
                JNZ     2 $
                INT     21
                MOV     CH, AL
                JMP     3 $
END-CODE

FORTH:

\G If the keyboard event u corresponds a valid 8 bit character,
\G return that character and true, otherwise return u and false.
CODE EKEY>CHAR      ( u -- u false | char true )        \ FORTH "e-key-to-char"
                TEST    BL, BL
                JNZ     0 $
                PUSH    BX
                XOR     BX, BX
                JMP     1 $
        0 $:    PUSH    BX
                MOV     BX, # TRUE
        1 $:    NEXT
END-CODE  ANS

\G If a keyboard event is available, returns true. Otherwise returns
\G false.
\G
\G After EKEY? returns with a value of true, subseqent executions of
\G EKEY? prior to the execution of KEY , KEY? or EKEY also return
\G true, referring to the same event. The next execution of EKEY
\G will return the same event without indefinite delay.
: EKEY?         ( -- flag )             \ FORTH "e-key-question"
        (LIT) OLDKEY @
        IF      TRUE
        ELSE    (LIT) OLDKEY OFF GETKEY DUP
                IF      SWAP (LIT) OLDKEY !
                THEN
        THEN
        ;  ANS

\G Receive one keyboard event u. ASCII keys have bits 7 to 15 set to
\G zero; other keys have the scan code in bits 8 to 15 and the lower
\G bits set to zero. Key codes made by holding the ALT-key down and
\G using the numeric pad give a 8 bit code.
: EKEY          ( -- u )                        \ FORTH "e-key"
        BEGIN   PAUSE EKEY?
        UNTIL
        (LIT) OLDKEY @ (LIT) OLDKEY OFF
        ;  ANS

\G If a character is available, return true. Otherwise return
\G false. If non-8 bit keyboard events are available before the
\G first valid character, they are discarded and subsequently
\G unavailable.
\G
\G After KEY? returns with a value of true, subseqent executions of
\G KEY? prior to the execution of KEY or EKEY also return true,
\G without discarding keyboard events. The next execution of KEY
\G will return the character without indefinite delay.
: KEY?          ( -- flag )                     \ FORTH "key-question"
        EKEY?
        IF      (LIT) OLDKEY @ EKEY>CHAR NIP DUP INVERT
                IF      (LIT) OLDKEY OFF
                THEN
        ELSE    FALSE
        THEN
        ;  ANS

INTERNAL:

\ This is the default routine in KEY .
: (KEY)         ( -- char )
        TRUE
        BEGIN   DROP EKEY EKEY>CHAR
        UNTIL
        ;

: CONTINUE?     ( -- flag )
        KEY DUP ^[ = #-28 ?ERROR                \ stops when escape is pressed
        BL =                                    \ space was pressed
        ;

EXTRA:

\G Return false is no key is pressed. Exception -28 occurs when
\G the escape key was pressed. If the key was not space, return
\G true. Wait for a second keypress and return true if it was not
\G space, false otherwise. Exception -28 occurs when the escape key
\G was pressed.
: STOP?         ( -- flag )                     \ EXTRA "stop-question"
        KEY? DUP                                \ was any key pressed
        IF      .STATUS                         \ show user some information
                CONTINUE? DUP                   \ was it a space
                IF      DROP CONTINUE?          \ then another key
                THEN
                XOR                             \ two spaces gives false
        THEN
        ;

\G Display the cursor.
CODE SHOW-CURSOR        ( -- )                  \ EXTRA
                MOV     CX, C.SIZ
                AND     CH, # 0DF
        AHEAD
END-CODE

\G Hide the cursor.
CODE HIDE-CURSOR        ( -- )                  \ EXTRA
                MOV     CX, C.SIZ
                OR      CH, # 20
        AHEAD
END-CODE

\G Set the cursor form to a block.
CODE BLOCK-CURSOR       ( -- )                  \ EXTRA
                MOV     CX, # BL.C
        AHEAD
END-CODE

\G Set the cursor form to a line.
CODE LINE-CURSOR        ( -- )                  \ EXTRA
                MOV     CX, # UL.C
        THEN
                MOV     C.SIZ CX
        THEN
        THEN
                MOV     AH, # 1
                PUSH    SI
                PUSH    BP
                INT     10
                POP     BP
                POP     SI
                NEXT
END-CODE

LABEL ^Ctrls    TH> T.CTRL
        $20 CELLS ALLOT

LABEL ^Keys     TH> T.KEYS
        $100 CELLS ALLOT

\G Return the address that is associated with control keys and
\G extended keys. Used to store an execution token that will be
\G executed when that particular key is pressed during ACCEPT .
: []KEY         ( char | x -- addr )            \ EXTRA "key-array"
        DUP BL U<
        IF      (LIT) ^Ctrls
        ELSE    DUP 100 U< #-526 ?ERROR
                8 RSHIFT (LIT) ^Keys
        THEN
        []CELL
        ;

EDITOR:

\G A mini version of ACCEPT for the kernel.
: MINIACCEPT    ( c-addr u1 -- u2 )                     \ EDITOR
        LOCAL max LOCAL addr                            \ save addr, max
        0 LOCAL len                                     \ current len
        BEGIN   len max <                               \ stop when full
        WHILE   KEY DUP ^M <>                           \ return
        WHILE   DUP ^H =                                \ backspace
                IF      len                             \ not on beginning
                        IF      DUP EMIT SPACE EMIT     \ back up one character
                                -1 +TO len              \ decrement len
                        ELSE    DROP BEEP               \ signal at beginning
                        THEN
                ELSE    DUP EMIT                        \ echo character
                        addr len + C!                   \ store in buffer
                        1 +TO len                       \ increment len
                THEN
        REPEAT  DROP                                    \ the ^M key
        THEN
        SPACE len
        ;

FORTH:

\G Receive a string of at most +n1 characters. An ambiguous
\G condition exists if +n1 is zero or greater than 32767. Display
\G graphic characters as they are received. A Standard Program that
\G depends on the presence or absence of non-graphic characters has
\G an environmental dependancy. The editing functions, if any, that
\G the system performs in order to construct the string are
\G implementation defined.
\G
\G Input terminates when "return" is received. When "return" is
\G received, nothing is appended to the string, and the display is
\G maintained in an implementation defined way.
\G
\G +n2 is the length of the string stored at c-addr.
: ACCEPT        ( c-addr +n1 -- +n2 )                   \ FORTH
        ['] NOOP IS LOG-TOGGLE                          \ reset beforehand
        OVER LOCAL addr                                 \ keep address
        CONSOLE? PRINTING? 2>R LOGGING? >R              \ save flags
        CLEAR LOGGING?                                  \ halt logging
        'ACCEPT @ EXECUTE                               \ accept a line
        R@ DUP TO LOGGING?                              \ logging now ?
        IF      SILENT addr OVER TYPE SPACE             \ write to logfile
        THEN
        R> TO LOGGING? 2R> TO PRINTING? TO CONSOLE?     \ restore flags
        LOG-TOGGLE                                      \ set by F2
        ;  ANS

\G Make the user input device the input source. Receive input into
\G the terminal input buffer, replacing any previous contents. Make
\G the result, whose address is returned by TIB , the input buffer.
\G Set >IN to zero. 
\G
\G Note: this word is obsolescent and is included as a concession to
\G existing implementations.
: QUERY         ( -- )                                  \ FORTH
        TIB DUP C/L 1- OUT - ACCEPT SET-SOURCE
        ;  ANS

                            \ (* End of Source *) /
