\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : Meta compiler for CHForth version 1.1.0 
\ FILENAME    : META.FRT 
\ DESCRIPTION : Source for the Meta Forth 
\ AUTHOR      : Coos Haak, Utrecht 
\ CREATED     : May 11, 1994
\ ----------------------------------------------------------------------



hex

-- Environment dependant code

s" c:\chf\lib\" libpath place           \ change the path to your files!

version #121 < [if]

cr .( Version 1.2.1 or higher needed!) abort

[then]

DOC   User changable values

SPARA, paragraphs for the stacksegment STKSEG

1000 is the maximum, 10907 cells per stack in a space of 64 Kb.
 300 is normal, 2032 cells per stack, 12 Kb.
  C0 is ok, 496 cells per stack, 3 Kb.
  30 is minimal, 112 cells per stack, 0.75 Kb.

#CPU contains 86 for XT and AT and 386 for higher machines
But you can metacompile source for the other cpu.

ENDDOC

300 constant spara

cr .( Do you want to compile for a 386 processor or higher ? [Y,n])
        key dup emit cr >upc 'N' <> [if]

#386

[else]

#86

[then]

cr .( Source runs on 80) #cpu @ .dec .( or higher, )
internal
sp0 rp0 - #cells #16 - .dec .( elements per stack.)
forth

#cpu !

cr .( Target runs on 80) #cpu @ .dec .( or higher, )
spara 3 / 2 - paragraphs #cells .dec .( elements per stack.)

-- The rest stays mainly the same

staton

timer-reset

 1 constant =ansi-t             \ Header flags, order is alphabetic
 2 constant =comp-t
 4 constant =hidden-t
 8 constant =immediate-t
10 constant =local-t
20 constant =private-t

needs -assembler
needs -paragraphs
needs -outfile
needs -errorlog

marker -meta cr .(  Metaforth 1.1.0, May 1994 )

warning off                                     \ no redefining messages

: :             ( ccc -- )                      \ FIGFORTH changed context
        get-current set-context :                         \ still used here
        ;

: a;            ( -- )                          \ usable from META
        [ assembler ] a;                                \ terminate code def.
        ;

vocabulary meta

: >meta         ( -- )                          \ set new order
        -2 set-order internal also meta also definitions
        ;

: error-halt    ( -- )                          \ ALT-X terminates
        1 halt                                          \ message for MAKE
        ;  ' error-halt 2D00 []key !

: twordlist     ( -- addr )                     \ make a target wordlist
        create  2 cells allot
        ;

twordlist <forth>                               \ contains ANSI words
twordlist <extra>                               \ contains NON-ANSI words
twordlist <editor>                              \ contains EDITOR words
twordlist <internal>                            \ contains INTERNAL words
twordlist <only>                                \ some special words
twordlist <local>                               \ mini-vocabulary for LOCAL
twordlist <value>                               \ mini-vocabulary for VALUE
twordlist <variable>                            \ mini-vocabulary for VARIABLE
twordlist <vector>                              \ mini-vocabulary for VECTOR
twordlist <doc>                                 \ mini-vocabulary for DOC

0 value target                                  \ pointer to wordlist

: forth:                                        \ wordlist for target words
        <forth> to target
        ;

: extra:
        <extra> to target
        ;

: editor:
        <editor> to target
        ;

: internal:
        <internal> to target
        ;

: only:
        <only> to target
        ;

: local:
        <local> to target
        ;

: value:
        <value> to target
        ;

: variable:
        <variable> to target
        ;

: vector:
        <vector> to target
        ;

: doc:
        <doc> to target
        ;

>meta

wordlist constant imms
wordlist constant labels-wordlist
wordlist constant locals-wordlist-t

variable #local                                 \ count target locals

: imm:                                          \ make immediate definitions
        get-context get-current 2>r
        imms dup set-context set-current
        :
        2r> set-current set-context
        ;

: labfind                                       \ find forward references
        labels-wordlist search-wordlist dup
        if      over cell- @
                if      exit
                then
                2drop false
        then ;

variable ^mvect         ^mvect off              \ some link pointers
variable ^mmess         ^mmess off

-- LIST

create wtype ", ----"

: w"
        '"' parse postpone sliteral s" wtype pack drop" evaluate
        ;  immediate

: echoitem
        wtype count ftype bl femit
        ;

: spaces.l
        0
        ?do     bl femit
        loop ;

: h.l
        push base hex
        u>d <# bl hold # # # # #> ftype
        pop base
        ;

-- TRACE

variable %tr

: (?")
        %tr @
        if      .status cr here count 1F and stype .s
                8 out over mod - spaces
                inline$ typestring space space key drop exit
        then
        inline$ drop ;
        compile-only

: ?"
        postpone (?") l", ;
        immediate compile-only

-- code, data
1000 segment seg-t

variable dp-t

: ts:
        seg-t @ swap ;

: @-t
        ts: @x ;

: c@-t
        ts: c@x ;

: !-t
        ts: !x ;

: c!-t
        ts: c!x ;

: here-t
        dp-t @ ;

: org
        dp-t ! ;

: allot-t
        dp-t +! ;

: ,-t
        here-t !-t 2 allot-t ;

: c,-t
        here-t c!-t 1 allot-t ;

: s,-t
        0
        ?do     count c,-t
        loop
        drop ;

: align-t
        here-t 1 and
        if      $FC c,-t
        then ;

-- lists
1000 segment seg-l

variable dp-l

: ls:
        seg-l @ swap ;

: @-l
        ls: @x ;

: c@-l
        ls: c@x ;

: !-l
        ls: !x ;

: c!-l
        ls: c!x ;

: here-l
        dp-l @ ;

: allot-l
        dp-l +! ;

: ,-l
        here-l !-l 2 allot-l ;

: c,-l
        here-l c!-l 1 allot-l ;

: s,-l
        0
        ?do     count c,-l
        loop
        drop ;

: align-l
        here-l 1 and
        if      0 c,-l
        then ;

-- headers
1000 segment seg-h

variable dp-h

: ys:
        seg-h @ swap ;

: @-h
        ys: @x ;

: c@-h
        ys: c@x ;

: !-h
        ys: !x ;

: c!-h
        ys: c!x ;

: here-h
        dp-h @ ;

: allot-h
        dp-h +! ;

: ,-h
        here-h !-h 2 allot-h ;

: c,-h
        here-h c!-h 1 allot-h ;

: s,-h
        0
        ?do     count c,-h
        loop
        drop ;

: align-h
        here-h 1 and
        if      0 c,-h
        then ;

variable tstate

: t[
        tstate off ;    t[

: t]
        tstate on ;

: t>body
        cell+ cell+ ;

: tbody>
        cell- cell- ;

: ?odd
        here-t 1 and
        if      here count type space tib >in @ + 10 type 4 spaces
                cr ." Make address even [Y,n] " key >upc dup emit
                'N' <> negate allot-t
        then ;

DOC
?undef entry [if]

: entry
        1 cs-roll postpone then
        ;  immediate compile-only

[then]

\ Header structure:
\ | dea | flags | forget | code | count+name |

: search-wordlist-t     ( c-addr u wid -- 0 | xt 1 | xt -1 )
        cell+ @                         \ last dea
        srcseg @                        \ save value of segment register
        locals| oldseg dea len addr |
        seg-h @ srcseg !                \ set new value
        ahead                           \ skip some code ..
        begin
                dea @-h to dea          \ next word
        entry                           \ .. till here
                dea 0=
                if      oldseg srcseg ! \ restore value
                        false exit      \ not found
                then
                addr len
                dea 4 cells +           \ to name
                dup 1+ swap c@-h        \ address and count
                compare                 \ (frtseg:addr1 u1),(seg-h:addr2 u2)
                0=
        until                           \ found word
        dea 3 cells + @-h              \ execution token
        dea 1 cells + @-h              \ get flags
        =immediate-t and
        if      1                       \ immediate
        else    -1                      \ normal word
        then
        oldseg srcseg !                 \ restore value
        ;

ENDDOC

\ Header structure:
\ | dea | flags | forget | code | count+name |

code search-wordlist-t  ( c-addr u wid -- 0 | xt 1 | xt -1 )
                mov     bx, 2 [bx]      \ last dea
                xchg    sp, bp
                push    es              \ list segment
                push    si              \ forth instruction pointer
                xchg    sp, bp
                pop     cx              \ count
                pop     dx              \ addr
                mov     es, seg-h       \ dest register for compare
        ahead                           \ skip some code ..
        begin
                mov     bx, es: 0 [bx]  \ next dea
        entry                           \ .. till here
                test    bx, bx
        0= if
                xchg    sp, bp
                pop     si              \ restore ip
                pop     es              \ restore listsegment
                xchg    sp, bp
                next                    \ not found, bx = 0
        then
                cmp     cl, es: 4 cells [bx]    \ count bytes equal
        0= if
                mov     si, dx          \ address1
                lea     di, 4 cells char+ [bx]  \ address2
                push    cx              \ save count
                repz    cmpsb           \ ds:si and es:di for cx
                pop     cx              \ restore count
        0= if
                push    es: 3 cells [bx]        \ execution token
                mov     ax, es: 1 cells [bx]    \ flags
                mov     bx, # -1                \ normal = -1
                test    ax, # =immediate-t
        0= if
                neg     bx                      \ immediate = 1
        then
                xchg    sp, bp
                pop     si
                pop     es
                xchg    sp, bp
                next
        then
        then
                again
end-code

: search-context-t      ( c-addr u -- 0 | xt 1 | xt -1 )
        local len local addr
        addr len <forth> search-wordlist-t ?dup
        if      exit
        then
        addr len <extra> search-wordlist-t ?dup
        if      exit
        then
        addr len <editor> search-wordlist-t ?dup
        if      exit
        then
        addr len <internal> search-wordlist-t ?dup
        if      exit
        then
        addr len <only> search-wordlist-t
        ;

: th>
        here-t ' >body ! ;

#101 mess" target value unknown"

: tcon
        create  0 ,
        does>   @ dup 0= #101 ?error
        ;

tcon t.origin
tcon t.docreate
tcon t.dovar
tcon t.docon
tcon t.dovector
tcon t.prefix
tcon t.docol
tcon t.exit
tcon t.lit
tcon t.chr
tcon t.tic
tcon t.postpone
tcon t.initial
tcon t.doseg
tcon t.lstmax
tcon t.lstlen
tcon t.hdrmax
tcon t.hdrlen
tcon t.stkmax
tcon t.(s")
tcon t.(.")
tcon t.dodoes
tcon t.modify
tcon t.if
tcon t.else
tcon t.then
tcon t.case
tcon t.of
tcon t.endof
tcon t.endcase
tcon t.begin
tcon t.again
tcon t.until
tcon t.while
tcon t.repeat
tcon t.do
tcon t.?do
tcon t.loop
tcon t.+loop
tcon t.doval
tcon t.val@
tcon t.val!
tcon t.val+!
tcon t.val0!
tcon t.val>r
tcon t.valr>
tcon t.local
tcon t.loc@
tcon t.loc!
tcon t.loc+!
tcon t.loc0!
tcon t.vec!
tcon t.fgtmes
tcon t.ctrl
tcon t.keys

: <asm
        [ assembler ]
        ['] here        is ahere
        ['] c@          is ac@
        ['] c!          is ac!
        ['] c,          is ac,
        ['] !           is a!
        ['] ,           is a,
        ['] allot       is aallot ;

: asm>
        [ assembler ]
        ['] here-t      is ahere
        ['] c@-t        is ac@
        ['] c!-t        is ac!
        ['] c,-t        is ac,
        ['] !-t         is a!
        ['] ,-t         is a,
        ['] allot-t     is aallot ;

assembler

' rel alias rel
' wrd alias wrd
' ?byte alias ?byte

meta

: extend
        0 , tstate @ dup ,
        if      here-l , wrd [ assembler ] +pfa? ,-l %pfa [ meta ] off
        else    here here-t , [ assembler ] %?ref [ meta ] ! here-t
        then ;

: (dound)
        does>   begin   dup @ ?dup
                while   nip
                repeat
                here swap ! extend ; (dound)

' (dound)       constant dound

: h>code
        here dup cell+ over c@ 2 + cmove> true ,
        labels-wordlist voc@ h@ cnhash here cnhash <>
        if      hhere here cnhash dup h@ rot umin swap h!
        then
        hhere labels-wordlist dup voc@ h, voc!  -- link
        0 h,                                    -- head>flags
        0 h,                                    -- head>forget
        here h,                                 -- head>
        here dup c@ 1F min 1+ #cells 0          -- >head
        do      @+ h,
        loop
        drop hhere here cnhash cell+ h! ;

-- CHECK

variable %ck

#102 mess" can't find"

: forward
        %ck @
        if      cr ." Not found: " invers space here count type space invers
                cr ." Need forward reference [Y,n] " key >upc dup emit
                'N' = #102 ?error
        then
        h>code dound jump, extend ;

: patch
        0 0 0 locals| list flag dest data |
        begin   data cell+ @ to list
                list
                if      here-t data cell+ cell+ @ !-l
                else    data cell+ cell+ @ to dest dest c@-t to flag
                        flag rel and
                        if      here-t dest flag wrd and + 1+ -
                        else    here-t
                        then
                        flag wrd and
                        if      dest !-t
                        else    flag rel and
                                if      ?byte
                                then
                                dest c!-t
                        then
                then
                data @ to data data 0=
        until ;

: [dolab]
        does>   @ tstate @
                if      ,-l
                then ;  [dolab]

' [dolab]       constant dolab

: (dolab)
        dolab jump, here-t , ;

: print
        here-t h.l here-l h.l here-h h.l ;

#103 mess" use only during compiling or assembling in target"

: label
        state @ #103 ?error
        a; print echoitem
        bl word count 2dup ftype fcr labfind
        if      dup >body patch here swap dp ! (dolab) dp !
        else    h>code (dolab)
        then ;

: meta$interpret
        local len local adr tstate @
        if      adr len imms search-wordlist
                if      execute ?" execution in IMMS"
                else    adr len locals-wordlist-t search-wordlist
                        if      t.loc@ ,-l >body @ #local @ swap - 1- cells ,-l
                                ?" Compiled from LOCALS into TARGET"
                        else    adr len labfind
                                if      execute ?" compilation from LABELS to TARGET"
                                else    adr len search-context-t
                                        if      ,-l ?" compilation from & to TARGET"
                                        else    adr len number? 1 =
                                                if      charflag @
                                                        if      t.chr
                                                        else    t.lit
                                                        then    ,-l ,-l
                                                ?" compilation as a number in TARGET"
                                                else    forward
                                                then
                                        then
                                then
                        then
                then
        else    adr len search-context
                if      headflags =comp and #-14 ?error
                        execute ?" exec: META or FORTH"
                else    adr len labfind
                        if      execute ?" execution in LABELS"
                        else    adr len number? 0=
                                if      forward
                                else    ?" interpreted as a number"
                                then
                        then
                then
        then ;

#104 mess" only permitted in target"

: meta$compile
        2dup local len local adr search-context
        if      headflags =immediate and
                if      execute ?" exec: META of FORTH"
                else    compile, ?" comp: META"
                then
        else    adr len labfind
                if      execute ?" execution in LABELS"
                else    adr len number? dup 0= #104 ?error
                        postpone literals ?" compiled as a number"
                then
        then ;

#105 mess" Abort in META"

: mabort
        ['] $compile is 'compile
        ['] $interpret is 'interpret
        >meta tstate off \ true #105 ?error
        ;

: references
        retcode off labels-wordlist voc@
        begin   ?dup
        while   dup head> dup >call dound = swap cell- @ and
                if      retcode @ 0=
                        if      cr retcode on
                        then
                        dup .head space space
                then
                h@
        repeat
        out
        if      cr
        then ;

: (label)
        here count labfind
        if      execute ?" execution in LABELS"
        else    forward
        then ;

: ptr
        bl word count search-context-t 0=
        if      (label)
        then ;

#106 mess" still undefined"

: t'
        bl word count search-context-t 0= #106 ?error
        t>body
        ;

: goto
        a; here-t 1+ constant [ assembler ] mov ax, 0 # jmp ax ;

#107 mess" only when executing"

: t?exec
        state @ tstate @ or #107 ?error
        ;

variable t>flags

: echoname
        print echoitem
        here count ftype fcr w" ----" ;

: patchname
        here count labfind
        if      dup >body patch cell- off
        then ;

\ Header structure:
\ | dea | flags | forget | code | count+name |

: thead,        ( c-addr u -- )
        2>r a; t?exec t>flags @ 2 cells + ( code )
        @-h cnhash here-t cnhash <>
        if      here-h here-t cnhash dup @-h rot umin swap !-h
        then
        here-h target dup voc@ ,-h voc!                 -- link
        here-h t>flags ! 0 ,-h                          -- head>flags
        0 ,-h                                           -- head>forget
        here-t ,-h                                      -- head>
        2r> dup
        if      here place echoname patchname
        else    2drop s" {NullName}" here place echoname here off
        then
        here count dup c,-h s,-h align-h                -- >head
        here-h here-t cnhash cell+ !-h ;

: theader
        bl parse-word thead, ;

: tcall,
        ?odd E8 c,-t here-t 2 + - ,-t align-t ;

: tjump,
        ?odd E9 c,-t here-t 2 + - ,-t align-t ;

: t>call
        1+ dup @-t + cell+ ;

: tcomp
        t] t.docol tjump, here-l ,-t !csp ;

: t:
        align-t w" COLO" theader tcomp ;

: flags!-t              ( n -- )
        t>flags @ dup @-h rot or swap !-h ;

: immediate-t
        =immediate-t flags!-t ;

: compile-t
        =comp-t flags!-t ;

: ans-t
        =ansi-t flags!-t ;

: hidden-t
        =hidden-t flags!-t ;

: tcode
        w" CODE" theader [ assembler ] >asm
        ;

: t;c
        a; [ assembler ] ?resolved >meta
        ;

: orphan
        t?exec label [ assembler ] >asm ;

: :orphan
        ?odd t?exec label tcomp ;

: tdo>
        t?exec label t] t.dodoes tcall, here-l ,-t !csp ;

: tdoer:
        t: compile-t t[ t.modify ,-l here-t ,-l 0 ,-t 0 ,-t
        tdo>
        ;

: tdoercode
        t: compile-t t[ t.modify ,-l here-t ,-l 0 ,-t 0 ,-t
        orphan
        ;

: tcreate
        w" CRTE" theader t.docreate tjump, ;

: tvariable
        w" VARI" theader t.dovar tjump, 0 ,-t ;

: tvalue
        w" VALU" theader t.doval tjump, ,-t ;

: tconstant
        w" CONS" theader t.docon tjump, ,-t ;

: tvector
        w" VECT" theader t.dovector tjump, 0 ,-t
        here-t ^mvect @ ,-t ^mvect ! ;

: setvector
        t' ptr swap !-t ;

: setkey
        dup bl u<
        if      t.ctrl
        else    dup 100 u< #-526 ?error
                8 rshift t.keys
        then
        ptr rot cells rot + !-t
        ;

: tsegment
        w" SEGM" theader t.doseg tjump, ;

: twordlist
        here-t cell- 1 cells allot-t ;

: "parse
        print echoitem
        '"' parse 2dup ftype fcr w" ----" ;

: ",-t
        "parse dup c,-t s,-t tstate @
        if      align-t
        then ;

: ",-l
        "parse dup c,-l s,-l align-l ;

: tmess"
        s" " thead, hidden-t t.fgtmes t>flags @ cell+ !-h
        here-t ^mmess @ ,-t ^mmess ! ,-t ",-t ;

: tprefix
        w" METH" >in @ theader >in ! t.prefix tjump, immediate-t
        bl word count dup c,-t s,-t align-t ;

: tlocal
        w" LOCA" >in @ bl word drop >in ! echoname
        get-current locals-wordlist-t set-current create set-current
        #local @ , #local incr t.local ,-l ;

#108 mess" Wrong prefix for a local"
#109 mess" Wrong prefix for a value/variable"
#110 mess" Wrong prefix for VECTOR"
#111 mess" this word doesn't allow a prefix"

: doprefix
        bl word count locals-wordlist-t search-wordlist
        if      swap case
                -1 of   t.loc+! endof
                1 of    t.loc!  endof
                2 of    t.loc0! endof
                #108 ?error
                endcase
                ,-l >body @ #local @ swap - 1- cells ,-l exit
        then
        here count search-context-t
        if      dup t>call dup t.doval = over t.dovar = or
                if      drop swap case
                        -1 of   t.val+! endof   \ +to
                        0 of    t.val@  endof   \ from
                        1 of    t.val!  endof   \ to
                        2 of    t.val0! endof   \ clear
                        3 of    t.lit   endof   \ adr
                        4 of    t.val>r endof   \ push
                        5 of    t.valr> endof   \ pop
                        #109 ?error
                        endcase ,-l >body ,-l exit
                else    t.dovector =
                        if      swap case
                                6 of    t.vec!  endof   \ is
                                #110 ?error
                                endcase
                                ,-l >body ,-l exit
                        then
                then
        then
        true #111 ?error
        ;

: m>mark        ( x1 -- x2 x1 )
        here-l 2 allot-l swap
        ;

: m>resolve     ( x1 x2 x3 -- )
        ?pairs here-l swap !-l
        ;

: m<mark        ( x1 -- x2 x1 )
        here-l swap
        ;

: m<resolve     ( x1 x2 x3 -- )
        ?pairs ,-l
        ;

imm: [']
        t.tic ,-l ;

imm: ;
        ?csp t.exit ,-l t[ locals-wordlist-t off #local off ;

imm: s"
        w" (s')" t.(s") ,-l here-t ,-l ",-t
        ;

imm: ."
        w" (.')" t.(.") ,-l ",-l
        ;

imm: t[
        t[ ;

imm: (
        postpone ( ;

imm: \
        postpone \ ;

imm: --
        postpone -- ;

imm: \g
        postpone \g ;

imm: (lit)
        t.lit ,-l ;

imm: from
        0 doprefix ;

imm: to
        1 doprefix ;

imm: +to
        -1 doprefix ;

imm: clear
        2 doprefix ;

imm: adr
        3 doprefix ;

imm: push
        4 doprefix ;

imm: pop
        5 doprefix ;

imm: is
        6 doprefix ;

imm: postpone
        t.postpone ,-l ptr ,-l ;

imm: if
        t.if ,-l 1 m>mark ;

imm: else
        t.else ,-l 1 m>mark 2swap 1 m>resolve ;

imm: then
        t.then ,-l 1 m>resolve ;

imm: begin
        t.begin ,-l 2 m<mark ;

imm: again
        t.again ,-l 2 m<resolve ;

imm: until
        t.until ,-l 2 m<resolve ;

imm: while
        t.while ,-l 1 m>mark 2swap ;

imm: repeat
        t.repeat ,-l 2 m<resolve 1 m>resolve ;

imm: case
        t.case ,-l 3 3 ;

imm: of
        t.of ,-l 1 m>mark ;

imm: endof
        t.endof ,-l 1 m>mark 2swap 1 m>resolve ;

imm: endcase
        t.endcase ,-l
        begin   dup 3 <>
        while   1 m>resolve
        repeat
        and 3 ?pairs ;

imm: do
        t.do ,-l 4 m>mark ;

imm: ?do
        t.?do ,-l 4 m>mark ;

imm: loop
        t.loop ,-l 4 m>resolve ;

imm: +loop
        t.+loop ,-l 4 m>resolve ;

imm: forth:
        forth: ;

imm: extra:
        extra: ;

imm: editor:
        editor: ;

imm: internal:
        internal: ;

imm: only:
        only: ;

imm: local
        tlocal ;

forth definitions

: check
        %ck on ;

: nocheck
        %ck off ;

: trace
        %tr on ;

: notrace
        %tr off ;

: tdump
        seg-t @ -rot dumpx ;

: ldump
        seg-l @ -rot dumpx ;

: hdump
        seg-h @ -rot dumpx ;

forth definitions

: mload
        fcr #10 spaces.l bl word count 2dup thefile place
\       2dup cr type
        2dup upper ftype fcr fcr
        >meta
        ['] meta$interpret is 'interpret
        ['] meta$compile is 'compile
        s" .frt" here append here count r/o open-file
        0 of    ['] include-file catch
                0 of    ['] $interpret is 'interpret
                        ['] $compile is 'compile
                        exit
                then
        then
        mabort show-error quit ;

create texeh
   5A4D ,   \ 'MZ'
      0 ,   \ lengte modulo 512
      0 ,   \ lengte div 512
      0 ,   \ relocatie aantal
      2 ,   \ lengte header in para's
      0 ,   \ minimaal geheugen
   FFFF ,   \ maximaal geheugen
   FFF0 ,   \ stacksegment
   FFFC ,   \ stackoffset
      0 ,   \ checksum
      0 ,   \ ip
   FFF0 ,   \ cs
     1C ,   \ offset tabel
      0 ,   \ overlay nummer
      0 ,   \ eerste relocatie
      0 ,   \ vulsel

spara        1- paragraphs constant lstop
spara 2 3 */ 1+ paragraphs constant lsbot
spara 2 3 */ 1- paragraphs constant sptop
spara 1 3 */ 1+ paragraphs constant spbot
spara 1 3 */ 1- paragraphs constant rptop
             1  paragraphs constant rpbot

#112 mess" can't create EXE"
#113 mess" can't write preambule"
#114 mess" can't write code to disk"
#115 mess" can't write lists to disk"
#116 mess" can't write headers to disk"
#117 mess" can't close EXE"

: tsave
        [ meta ]
        seg-l cell+ @ dup t.lstmax !-t
        seg-h cell+ @ dup t.hdrmax !-t +
        spara dup t.stkmax !-t +
        t.origin 4 + !-t
        here-l #paragraphs dup t.lstlen !-t
        here-h #paragraphs dup t.hdrlen !-t +
        t.origin 2 + !-t
        here-t #paragraphs 10 + t.origin !-t
        20
        here-t paragraph-aligned +
        here-l paragraph-aligned +
        here-h paragraph-aligned +
        u>d 200 um/mod over 0<> negate + swap texeh 2 + 2!
        here-t paragraph-aligned FC + texeh 10 + !
        t.initial texeh 14 + ! s" .exe" bl word append
        here count w/o bin create-file #112 ?error >r
        texeh 20 r@ write-file #113 ?error
        seg-t @ 100 here-t paragraph-aligned r@ writex-file #114 ?error
        seg-l @ 0 here-l paragraph-aligned r@ writex-file #115 ?error
        seg-h @ 0 here-h paragraph-aligned r@ writex-file #116 ?error
        r> close-file #117 ?error
        ;

: new
        >meta [ meta ]
        <forth>    cell+ off
        <extra>    cell+ off
        <editor>   cell+ off
        <internal> cell+ off
        <only>     cell+ off
        <local>    cell+ off
        <value>    cell+ off
        <variable> cell+ off
        <vector>   cell+ off
        <doc>      cell+ off
        forth: [ assembler ] initasm
        seg-t 2@ swap 0 fillp 100 dp-t !
        seg-l 2@ swap 0 fillp dp-l off
        seg-h 2@ swap 0 fillp 102 dp-h ! ;

: old
        >meta casesensitive off
        ['] $interpret is 'interpret
        ['] $compile is 'compile
        quit ;

: mstat
        [ meta ] chain status
        #64 0 at-xy push base hex
        here-t 5 .r here-l 5 .r here-h 5 .r
        pop base
        ;  ' mstat is status

diagnose

: mdia
        [ meta ] chain diagnose
        push base decimal
        cr gettime timesave 2@ d-
        #10 um/mod 1 max >r drop
        here-t dup 5 u.r ." +" u>d
        here-l dup 5 u.r ." +" m+
        here-h dup 5 u.r ." =" m+ 2dup 6 ud.r space
        #100 r> m*/ 5 ud.r ."  bps."
        pop base
        ;  ' mdia is diagnose

asm>

-- Enkele aliassen

: here
        here-t ;

: allot
        allot-t ;

: ,
        ,-t ;

: c,
        c,-t ;

: align
        align-t ;

: code
        tcode ;

: immediate
        immediate-t ;

: compile-only
        compile-t ;

: ans
        ans-t ;

: hidden
        hidden-t ;

: header
        theader ;

: variable
        tvariable ;

: value
        tvalue ;

: prefix
        tprefix ;

: mconstant
        constant ;

: constant
        tconstant ;

: create
        tcreate ;

: vector
        tvector ;

: mess"
        tmess" ;

also assembler definitions

: end-code
        t;c ;

-2 set-order internal also forth definitions

: doer:
        [ meta ] tdoer:
        ;

: doercode
        [ meta ] tdoercode
        ;

: :
        [ meta ] t: ;

forth

s" kernel.lst" fopen

new
notrace
nocheck
warning off

\ As I assume, VGA screens do not fit on a 8086 or 80286

#cpu @ #386 <> [if]     \ true=CGA, false=MA,VGA

0607 mconstant ul.c
0205 mconstant bl.c

[else]

0B0C mconstant ul.c
060D mconstant bl.c

[then]

10 mconstant mvocs
80 mconstant t/line

#64 2 cells + mconstant t/handle
10 mconstant thandles
17E mconstant t/hist-len

warning on

casesensitive on

MLOAD startup
MLOAD struct
MLOAD math
MLOAD stacks
MLOAD logic
MLOAD memory
MLOAD compiler
MLOAD strings
MLOAD numbers
MLOAD timing
MLOAD interp
MLOAD headers
MLOAD dos
MLOAD input
MLOAD screen
MLOAD output
MLOAD block
MLOAD files
MLOAD errors
MLOAD finish

CASESENSITIVE OFF

' $interpret is 'interpret
' $compile is 'compile

fcr (.t0) ftype bl femit bl femit (date) ftype fcr
fclose
references
diagnose
tsave kernel
.free
retcode @ halt

                            \ (* End of Source *) /
