\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : Meta compiler for CHForth version 1.1.0 
\ FILENAME    : OUTPUT.FRT 
\ DESCRIPTION : Output routines 
\ AUTHOR      : Coos Haak, Utrecht 
\ CREATED     : May 11, 1994
\ ----------------------------------------------------------------------



LABEL ansi_page                                 \ ANSI.SYS string
        ^[ C, '[' C, '2' C, 'J' C, '$' C,

ORPHAN ECHO-CHAR
                PUSH    BX
                TEST    T' CONSOLE? # TRUE      \ console output allowed?
        0<> IF
                PUSH    AX
                TEST    T' BIOS? # TRUE         \ bios allowed?
        0= IF
                MOV     DL, AL
                CMP     DL, # ^L
        0= IF
                MOV     DX, # ansi_page
                MOV     AH, # 9
                INT     21
                MOV     T' OUT # 0
                MOV     vpos # 0
        ELSE
                MOV     AH, # 2
                INT     21
                INC     T' OUT
                CMP     AL, # ^M
                JNZ     1 $
                MOV     T' OUT # -1
        THEN
                JMP     1 $
        THEN
                MOV     DL, T' OUT []
                MOV     DH, vpos []
                CALL    CONOUT
        1 $:    POP     AX
        THEN
                TEST    T' PRINTING? # TRUE     \ printer output allowed?
        0<> IF
                CALL    LSTOUT
        THEN
                POP     BX
                RET
END-CODE

ORPHAN LSTOUT
                MOV     BX, T' PHANDLE
                TEST    BX, BX
        0= IF
                MOV     DL, AL
                MOV     AH, # 5
                INT     21
                RET
        THEN
                MOV     PCHBUF [], AL
                MOV     DX, # PCHBUF
                MOV     CX, # 1
                MOV     AH, # 40
                INT     21
        U< IF
                GOTO    _prter
        THEN
                RET
END-CODE

ORPHAN CONNRM
                MOV     BL, T' ATTR []
                XOR     BH, BH
                MOV     CX, # 1
                MOV     AH, # 9
                PUSH    SI
                PUSH    BP
                INT     10
                POP     BP
                POP     SI
                PUSH    DX
                MOV     DH, T' C/L []
                DEC     DH
                CMP     DH, DL
                POP     DX
        0<> IF
                INC     DL
        ELSE
                XOR     DL, DL
                CALL    CONLF
        THEN
LABEL conn1
                PUSH    DX
$IF386
                MOVZX   BX, AL
$ELSE
                MOV     BL, AL
                XOR     BH, BH
$THEN
                MOV     AH, # 2
                PUSH    SI
                PUSH    BP
                INT     10
                POP     BP
                POP     SI
                POP     DX
                MOV     T' OUT [], DL
                MOV     vpos [], DH
                MOV     AL, BL
                RET
END-CODE

ORPHAN CONOUT
                CMP     AL, # 20
                JGE     CONNRM
                CMP     AL, # ^G
                JZ      CONBEL
                CMP     AL, # ^H
                JZ      CONBS
                CMP     AL, # ^I
                JZ      CONTAB
                CMP     AL, # ^J
                JZ      CONLF
                CMP     AL, # ^L
                JZ      CONFF
                CMP     AL, # ^M
                JZ      CONCR
                JMP     CONNRM
END-CODE

ORPHAN CONBEL
                MOV     AH, # E
                PUSH    SI
                PUSH    BP
                INT     10
                POP     BP
                POP     SI
                RET
END-CODE

ORPHAN CONBS
                TEST    DL, DL
        0<> IF
                DEC     DL
                JMP     conn1
        THEN
                RET
END-CODE

ORPHAN CONTAB
                MOV     CX, # 8
$IF386
                MOVZX   AX, DL
$ELSE
                MOV     AL, DL
                XOR     AH, AH
$THEN
                DIV     CL
                SUB     CL, AH
        DO
                PUSH    CX
                MOV     AL, # 20
                CALL    CONNRM
                POP     CX
        LOOP
                RET
END-CODE

ORPHAN CONLF
                PUSH    DX
                MOV     DL, T' L/SCR []
                DEC     DL
                CMP     DL, DH
        0= IF
                MOV     BL, AL
                MOV     AL, # 1
                CALL    _SCRL
                MOV     AL, BL
                POP     DX
                RET
        THEN
        U> IF
                POP     DX
                INC     DH
                JMP     conn1
        THEN
                POP     DX
                RET
END-CODE

ORPHAN CONFF
                XOR     AL, AL
                CALL    _SCRL
                XOR     DX, DX
                JMP     MVC
END-CODE

ORPHAN CONCR
                XOR     DL, DL
                JMP     conn1
END-CODE

ORPHAN _SCRL
                TEST    T' TEXT? [], # FF BYTE
        0<> IF
                MOV     BH, T' ATTR []
        ELSE
                XOR     BH, BH
        THEN
                XOR     CX, CX
                MOV     DL, T' C/L []
                DEC     DL
                MOV     DH, T' L/SCR []
                DEC     DH
                ADD     DX, CX
                MOV     AH, # 6
                PUSH    SI
                PUSH    BP
                INT     10
                POP     BP
                POP     SI
                RET
END-CODE

EXTRA:

\G Type the character on the output device, default action of EMIT .
CODE (EMIT)             ( char -- )             \ EXTRA "paren-emit"
                PUSH    BX
                MOV     AL, BL
                CALL    ECHO-CHAR
                POP     BX
                TEST    T' LOGGING? # TRUE      \ log bit
        0<> IF
                MOV     AX, # PTR LOG-EMIT
                JMP     AX
        THEN
                POP     BX
                NEXT
END-CODE

FORTH:

\G flag is true if the user output device is ready to accept data
\G and the execution of EMIT in place of EMIT? would not have
\G suffered an indefinite delay. If the device status is
\G indeterminate, flag is true.
CODE EMIT?              ( -- flag )             \ FORTH "emit-question"
                PUSH    BX
                MOV     BX, # TRUE
                NEXT
END-CODE  ANS

EXTRA:

\G If u is greater than zero, display the character string at the
\G extended address x-addr for a total of u characters.
: TYPEX                 ( x-addr u -- )         \ EXTRA "type-x"
        0 MAX 0
        ?DO     COUNTX EMIT
        LOOP
        2DROP
        ;

\G While the character at the extended address x-addr is not zero,
\G display the character and increment x-addr.
: TYPEZ                 ( x-addr -- )           \ EXTRA "type-z"
        BEGIN   COUNTX DUP
        WHILE   EMIT
        REPEAT
        DROP 2DROP
        ;

FORTH:

\G Move to another page for output. Actual function depends on the
\G output device. On a terminal, PAGE clears the screen and resets
\G the cursor position to the upper left corner. On a printer, PAGE
\G performs a form feed.
: PAGE          ( -- )                          \ FORTH
        ^L EMIT
        ;  ANS

\G Cause subsequent output to appear at the beginning of the next
\G line.
: CR            ( -- )                          \ FORTH "c-r"
        ^M EMIT ^J EMIT CLEAR OUT
        ;  ANS

\G Display one space.
: SPACE         ( -- )                          \ FORTH
        BL EMIT
        ;  ANS

\G If n is greater than zero, display n spaces.
: SPACES        ( n -- )                        \ FORTH
        0 MAX 0
        ?DO     SPACE
        LOOP
        ;  ANS

\G If u is greater than zero, display the character string specified
\G by c-addr and u.
\G See also: EMIT
: TYPE          ( c-addr u -- )                 \ FORTH
        CSEG -ROT TYPEX
        ;  ANS

INTERNAL:

\ Return true if the statusline may be displayed.
: SHOWSTATUS?           ( -- flag )             \ EXTRA "showstatus-question"
        STATUS? BIOS? PRINTING? INVERT TEXT?
        AND AND AND
        ;

EXTRA:

\G Display the statusline at the top of the screen.
: .STATUS               ( -- )                  \ EXTRA "dot-status"
        SHOWSTATUS?
        IF      ?AT 2>R ATTR @ >R HOME STATUSATTR @ ATTR !
                STATUS
                R> ATTR ! 2R> AT-XY
        THEN
        ;

\G Enable the display of the statusline.
: STATON                ( -- )                  \ EXTRA
        TRUE TO STATUS?
        ;

\G Disable the display of the statusline.
: STATOFF               ( -- )                  \ EXTRA
        CLEAR STATUS?
        ;

\G If char is a printable ASCII character in the range {32 .. 127},
\G use EMIT to display char. Otherwise use EMIT to display a '.'
\G (full stop).
\G See also: EMIT 
CODE SEMIT              ( char -- )             \ EXTRA "s-emit"
                CMP     BL, # 20
        >= IF
                CMP     BL, # 7F
        > IF
        ENTRY
                MOV     BX, # '.'
        THEN
                MOV     AX, # PTR EMIT
                JMP     AX
END-CODE

\G If u is greater than zero, display the character string at the
\G extended address x-addr for a total of u characters. The
\G characters are displayed as with SEMIT .
: STYPEX                ( x-addr u -- )         \ EXTRA "s-type-x"
        0 MAX 0
        ?DO     COUNTX SEMIT
        LOOP
        2DROP
        ;

\G If u is greater than zero, display the character string specified
\G by c-addr and u. The characters are displayed as with SEMIT .
: STYPE         ( c-addr u -- )                 \ EXTRA "s-type"
        CSEG -ROT STYPEX
        ;

\G Set the output to the screen.
CODE VIDEO              ( -- )                  \ EXTRA
                MOV     T' CONSOLE? # TRUE      \ console on
                MOV     T' PRINTING? # FALSE    \ printer off
LABEL video1
                PUSH    BX                      \ save TOS
                XOR     BH, BH                  \ page zero
                MOV     AH, # 3                 \ get cursor position
                PUSH    SI
                PUSH    BP
                INT     10
                POP     BP
                POP     SI
                MOV     T' OUT [], DL           \ use same position
                MOV     vpos [], DH
                POP     BX                      \ restore TOS
                NEXT
END-CODE

\G Set the output to the printer.
CODE PRINTER            ( -- )                  \ EXTRA
                MOV     T' CONSOLE? # FALSE     \ console off
                MOV     T' PRINTING? # TRUE     \ printer on
                NEXT
END-CODE

\G The output will go to both the screen and the printer.
CODE VID+PRN            ( -- )                  \ EXTRA
                MOV     T' CONSOLE? # TRUE      \ console on
                MOV     T' PRINTING? # TRUE     \ printer on
                JMP     video1
END-CODE

\G Suppress output to screen or printer.
CODE SILENT             ( -- )                  \ EXTRA
                MOV     T' CONSOLE? # FALSE     \ console off
                MOV     T' PRINTING? # FALSE    \ printer off
                NEXT
END-CODE

\G When loading echo the lines read to the screen.
: ECHO          ( -- )                              \ EXTRA
        TRUE TO ECHO?
        ;

\G When loading do not echo lines read to the screen.
: NOECHO        ( -- )                              \ EXTRA
        CLEAR ECHO?
        ;

FORTH:

                            \ (* End of Source *) /
