\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : Meta compiler for CHForth version 1.1.0 
\ FILENAME    : SCREEN.FRT 
\ DESCRIPTION : Screen handling routines 
\ AUTHOR      : Coos Haak, Utrecht 
\ CREATED     : May 11, 1994
\ ----------------------------------------------------------------------



EXTRA:

ORPHAN MVC
                PUSH    BX
                XOR     BH, BH
                PUSH    DX
                MOV     AH, # 2
                PUSH    SI
                PUSH    BP
                INT     10
                POP     BP
                POP     SI
                POP     DX
                MOV     T' OUT [], DL
                MOV     vpos [], DH
                POP     BX
                RET
END-CODE

FORTH:

\G Perform steps so that the next character displayed will appear in
\G column u1, row u2 of the current output device, the upper left
\G corner of which is row zero, column zero. It is a no-op when the
\G operation cannot be performed on the current output device with
\G the specified parameters. Note that for other implementations the
\G result in that case is an ambiguous condition.
CODE AT-XY              ( u1 u2 -- )            \ FORTH "at-x-y"
                POP     DX
                MOV     DH, BL
                CALL    MVC
                POP     BX
                NEXT
END-CODE  ANS

EXTRA:

\G When returning from a system call, reset some screen parameters.
CODE RESTORE-METRICS    ( -- )                  \ EXTRA
                CALL    metrics
                PUSH    BX
                XOR     BH, BH
                MOV     AH, # 3
                PUSH    SI
                PUSH    BP
                INT     10
                POP     BP
                POP     SI
                TEST    DH, DH
        0< IF
                XOR     DH, DH
        THEN
                TEST    DL, DL
        0< IF
                XOR     DL, DL
        THEN
                CALL    MVC
                POP     BX
                NEXT
END-CODE

\G Return the column u1 and row u2 of the cursor on the screen.
CODE ?AT                ( -- u1 u2 )            \ EXTRA "question-at"
                PUSH    BX
                XOR     BH, BH                  \ screen 0
                MOV     AH, # 3
                PUSH    SI
                PUSH    BP
                INT     10
                POP     BP
                POP     SI
$IF386
                MOVZX   AX, DL
$ELSE
                MOV     AL, DL
                XOR     AH, AH
$THEN
                MOV     T' OUT AX
                PUSH    AX                      \ x
$IF386
                MOVZX   BX, DH
$ELSE
                MOV     BL, DH
                XOR     BH, BH
$THEN
                MOV     vpos BX                 \ y
                NEXT
END-CODE

\G If n is greater than zero, emit spaces until the cursor is at
\G column u of the current user output device.
: HTAB          ( u -- )                        \ EXTRA "h-tab"
        OUT - SPACES
        ;

\G Emit spaces to clear the line on the screen beyond the cursor.
: EOL           ( -- )                          \ EXTRA "e-o-l"
        BIOS?                                   \ bios allowed?
        IF      ?AT C/L 1- PLUCK - SPACES AT-XY
        THEN
        ;

ORPHAN metrics
                MOV     AH, # 0F
                PUSH    SI
                PUSH    BP
                INT     10
                POP     BP
                POP     SI
                MOV     mode [], AL
$IF386
                MOVZX   AX, AH
$ELSE
                MOV     AL, AH
                XOR     AH, AH
$THEN
                MOV     T' C/L AX
                PUSH    DS
$IF386
                PUSH    # 40
                POP     DS
                MOVZX   AX, 84
$ELSE
                MOV     AX, # 40
                MOV     DS, AX
                MOV     AL, 84 []
                XOR     AH, AH
$THEN
                POP     DS
                INC     AX
                CMP     AX, # #25
                JL      0 $
                CMP     AX, # #60
                JLE     1 $
        0 $:    MOV     AX, # #25
        1 $:    MOV     T' L/SCR AX
                XOR     AX, AX
                MOV     T' OUT AX
                MOV     vpos AX
                RET
END-CODE

\G n is the total count of characters plus attributes on the screen.
: SCREENSIZE            ( -- n )                \ EXTRA
        C/L L/SCR * 2*
        ;

\G Set the cursor on the top left of the screen.
CODE HOME               ( -- )                  \ EXTRA
                XOR     DX, DX
                PUSH    BX
                CALL    MVC
                POP     BX
                NEXT
END-CODE

\G Set the screen to the textmode that was current at program start.
CODE DFTMODE            ( -- )                  \ EXTRA "default-mode"
                MOV     AL, dftm []
        BEGIN
                MOV     AH, # 0
                PUSH    SI
                PUSH    BP
                INT     10
                POP     BP
                POP     SI
                CALL    metrics
                JMP     PTR HOME
END-CODE

\G Set the screen to mode n.
CODE SETMODE            ( n -- )                \ EXTRA
                MOV     AL, BL
                POP     BX
        AGAIN
END-CODE

\G n is the number of the current screen mode.
CODE GETMODE            ( -- n )                \ EXTRA
                PUSH    BX
                MOV     AH, # F
                PUSH    SI
                PUSH    BP
                INT     10
                POP     BP
                POP     SI
                MOV     mode [], AL
                CBW
                MOV     BX, AX
                NEXT
END-CODE

\G Set the attribute of the characters on the screen to the default
\G value.
CODE NORMAL             ( -- )                  \ EXTRA
                MOV     AX, T' ATT0
                MOV     T' ATTR AX
                NEXT
END-CODE

\G Exchange the character foreground and background colors.
CODE INVERS             ( -- )                  \ EXTRA
                MOV     AL, T' ATTR []          \ Get attribute
                MOV     AH, AL                  \ Copy the attributes
$IF386
                ROL     AL, # 4                 \ Flip fore- and background
$ELSE
                MOV     CL, # 4
                ROL     AL, CL
$THEN
                AND     AX, # 8877              \ AH=blink+bright,AL=colors
                OR      AL, AH                  \ Compose the byte
                MOV     T' ATTR [], AL          \ Set new attribute
                NEXT
END-CODE

\G Invert the blink character attribute.
CODE BLINK              ( -- )                  \ EXTRA
                XOR     T' ATTR [], # 80 BYTE   \ Flip blinking bit
                NEXT
END-CODE

\G Invert the bright character attribute.
CODE BRIGHT             ( -- )                  \ EXTRA
                XOR     T' ATTR [], # 8 BYTE    \ Flip brightness bit
                NEXT
END-CODE

FORTH:

                            \ (* End of Source *) /
