\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : Meta compiler for CHForth version 1.1.0 
\ FILENAME    : STACKS.FRT 
\ DESCRIPTION : Stack operators 
\ AUTHOR      : Coos Haak, Utrecht 
\ CREATED     : May 11, 1994
\ ----------------------------------------------------------------------



\ loopstack

EXTRA:

\G Add n1|u1 to n2|u2 giving n3|u3. Used for setting up DO LOOPs.
CODE BOUNDS             ( n1|u1 n2|u2 -- n3|u3 n1|u1 )          \ EXTRA
                POP     AX
                ADD     BX, AX
                PUSH    BX
                MOV     BX, AX
                NEXT
END-CODE

FORTH:

\G Interpretation: ( i*x -- )
\G This word is marked compile only. The default interpreter issues
\G exception -14 when an attempt is made to execute this word.
\G
\G ( -- n|u ) ( R: loop-sys -- loop-sys )
\G n|u is a copy of the current (innermost) loop index. An ambiguous
\G condition exists if the loop control parameters are unavailable.
CODE I                                          \ FORTH
                PUSH    BX
                MOV     BX, 0 [BP]
                ADD     BX, 2 [BP]
                NEXT
END-CODE  ANS  COMPILE-ONLY

\G Interpretation: ( i*x -- )
\G This word is marked compile only. The default interpreter issues
\G exception -14 when an attempt is made to execute this word.
\G
\G ( -- n|u ) ( R: loop-sys -- loop-sys )
\G n|u is a copy of the index of the next outer loop. An ambiguous
\G condition exists if the loop control parameters of the next outer
\G loop are unavailable.
CODE J                                          \ FORTH
                PUSH    BX
                MOV     BX, 6 [BP]
                ADD     BX, 8 [BP]
                NEXT
END-CODE  ANS  COMPILE-ONLY

EXTRA:

\G Interpretation: ( i*x -- )
\G This word is marked compile only. The default interpreter issues
\G exception -14 when an attempt is made to execute this word.
\G
\G ( -- n|u ) ( R: loop-sys -- loop-sys )
\G n|u is a copy of the index of the second next outer loop. An
\G ambiguous condition exists if the loop control parameters of the
\G second next outer loop are unavailable.
CODE K                                          \ EXTRA
                PUSH    BX
                MOV     BX, C [BP]
                ADD     BX, E [BP]
                NEXT
END-CODE  COMPILE-ONLY

\G Interpretation: ( i*x -- )
\G This word is marked compile only. The default interpreter issues
\G exception -14 when an attempt is made to execute this word.
\G
\G ( flag -- ) ( R: loop-sys -- | loop-sys )
\G If flag is true, discard the current loop control parameters. An
\G ambiguous condition exists if they are unavailable. Continue
\G execution immediately following the innermost syntactically
\G enclosing DO ... LOOP or DO ... +LOOP . Otherwise continue.
\G See also LEAVE LOOP
CODE ?LEAVE                                     \ EXTRA "question-leave"
                TEST    BX, BX
                POP     BX
        0<> IF
END-CODE  COMPILE-ONLY

FORTH:

\G Interpretation: ( i*x -- )
\G This word is marked compile only. The default interpreter issues
\G exception -14 when an attempt is made to execute this word.
\G
\G ( -- ) ( R: loop-sys -- )
\G Discard the current loop control parameters. An ambiguous
\G condition exists if they are unavailable. Continue execution
\G immediately following the innermost syntactically enclosing DO
\G ... LOOP or DO ... +LOOP .
\G See also: +LOOP LOOP 
CODE LEAVE                                      \ FORTH
                MOV     SI, 4 [BP]
                MOV     SI, ES: -2 [SI]
                ADD     BP, # 6
        THEN
                NEXT
END-CODE  COMPILE-ONLY  ANS

\ return stack

INTERNAL:

\ Store x in the return stack pointer.
CODE RP!                ( x -- )                \ EXTRA "r-p-store"
                MOV     BP, BX
                POP     BX
                NEXT
END-CODE  COMPILE-ONLY

\ Return the value of the return stack pointer.
CODE RP@                ( -- x )                \ EXTRA "r-p-fetch"
                PUSH    BX
                MOV     BX, BP
                NEXT
END-CODE

FORTH:

\G Interpretation: ( i*x -- )
\G This word is marked compile only. The default interpreter issues
\G exception -14 when an attempt is made to execute this word.
\G
\G ( x -- ) ( R: -- x )
\G Move x to the return stack.
\G See also: R> R@ 2>R 2R> 2R@
CODE >R                                         \ FORTH "to-r"
                XCHG    SP, BP
                PUSH    BX
                XCHG    SP, BP
                POP     BX
                NEXT
END-CODE  COMPILE-ONLY  ANS

\G Interpretation: ( i*x -- )
\G This word is marked compile only. The default interpreter issues
\G exception -14 when an attempt is made to execute this word.
\G
\G ( -- x ) ( R: x -- )
\G Move x from the return stack to the data stack.
\G See also: >R 2>R 2R> 2R@ R@
CODE R>                                         \ FORTH "r-from"
                PUSH    BX
                XCHG    SP, BP
                POP     BX
                XCHG    SP, BP
                NEXT
END-CODE  COMPILE-ONLY  ANS

\G ( -- x ) ( R: x -- x )
\G Copy x from the return stack to the data stack.
\G See also: >R 2>R 2R> 2R@ R>
CODE R@                                         \ FORTH "r-fetch"
                PUSH    BX
                MOV     BX, 0 [BP]
                NEXT
END-CODE  ANS

EXTRA:

\G ( -- x1 ) ( R: x1 x2 -- x1 x2 )
\G Copy x1 from the return stack to the data stack.
CODE R'                                         \ EXTRA "r-tick"
                PUSH    BX
                MOV     BX, 2 [BP]
                NEXT
END-CODE

\G ( -- x1 ) ( R: x1 x2 x3 -- x1 x2 x3 )
\G Copy x1 from the return stack to the data stack.
CODE R"                                         \ EXTRA "r-quote"
                PUSH    BX
                MOV     BX, 4 [BP]
                NEXT
END-CODE

\G Interpretation: ( i*x -- )
\G This word is marked compile only. The default interpreter issues
\G exception -14 when an attempt is made to execute this word.
\G
\G ( -- x )
\G Return the inline compiled number, system use only.
CODE INLINE#                                    \ EXTRA "inline-number"
                PUSH    BX
                MOV     DI, 0 [BP]
                MOV     BX, ES: 0 [DI]
                ADD     0 [BP], # 2
                NEXT
END-CODE  COMPILE-ONLY

\G Interpretation: ( i*x -- )
\G This word is marked compile only. The default interpreter issues
\G exception -14 when an attempt is made to execute this word.
\G
\G l-addr is the list address of an inline compiled string. System
\G use only.
CODE INLINE$            ( -- l-addr )           \ EXTRA "inline-string"
                PUSH    BX
                MOV     BX, 0 [BP]
$IF386
                MOVZX   AX, ES: 0 [BX]
$ELSE
                MOV     AL, ES: 0 [BX]
                XOR     AH, AH
$THEN
                INC     AX
                INC     AX
                AND     AX, # -2
                ADD     0 [BP], AX
                NEXT
END-CODE  COMPILE-ONLY

\G Interpretation: ( i*x -- )
\G This word is marked compile only. The default interpreter issues
\G exception -14 when an attempt is made to execute this word.
\G
\G ( x -- x ) ( R: -- x )
\G Copy x to the return stack.
CODE DUP>R                                      \ EXTRA "dupe-to-r"
                XCHG    SP, BP
                PUSH    BX
                XCHG    SP, BP
                NEXT
END-CODE  COMPILE-ONLY

\G Interpretation: ( i*x -- )
\G This word is marked compile only. The default interpreter issues
\G exception -14 when an attempt is made to execute this word.
\G
\G ( -- ) ( R: x -- )
\G Remove x from the return stack.
CODE R>DROP                                     \ EXTRA "r-from-drop"
END-CODE  COMPILE-ONLY

\G Interpretation: ( i*x -- )
\G This word is marked compile only. The default interpreter issues
\G exception -14 when an attempt is made to execute this word.
\G
\G ( -- ) ( R: x -- )
\G Remove x from the return stack.
CODE -R                                         \ EXTRA "minus-r"
                INC     BP
                INC     BP
                NEXT
END-CODE  COMPILE-ONLY

FORTH:

\G Interpretation: ( i*x -- )
\G This word is marked compile only. The default interpreter issues
\G exception -14 when an attempt is made to execute this word.
\G
\G ( x1 x2 -- ) ( R: -- x1 x2 )
\G Transfer cell pair x1 x2 to the return stack. Semantically
\G equivalent to SWAP >R >R .
\G See also: >R 2R> 2R@ R> R@
CODE 2>R                                        \ FORTH "two-to-r"
                POP     AX
                XCHG    SP, BP
                PUSH    AX
                PUSH    BX
                XCHG    SP, BP
                POP     BX
                NEXT
END-CODE  COMPILE-ONLY  ANS

\G Interpretation: ( i*x -- )
\G This word is marked compile only. The default interpreter issues
\G exception -14 when an attempt is made to execute this word.
\G
\G ( -- x1 x2 ) ( R: x1 x2 -- )
\G Transfer the cell pair x1 x2 from the return stack. Semantically
\G equivalent to R> R> SWAP .
\G See also: >R 2>R 2R@ R> R@
CODE 2R>                                        \ FORTH "two-r-from"
                PUSH    BX
                XCHG    SP, BP
                POP     BX
                POP     AX
                XCHG    SP, BP
                PUSH    AX
                NEXT
END-CODE  COMPILE-ONLY  ANS

\G ( -- x1 x2 ) ( R: x1 x2 -- x1 x2 )
\G Copy cell pair x1 x2 from the returnstack. Semantically
\G equivalent to R> R> 2DUP >R >R SWAP .
\G See also: >R 2>R 2R> R> R@
CODE 2R@                                        \ FORTH "two-r-fetch"
                PUSH    BX
                PUSH    2 [BP]
                MOV     BX, 0 [BP]
                NEXT
END-CODE  ANS

\ parameterstack

INTERNAL:

\ Store x in the stack pointer.
CODE SP!                ( x -- )                \ EXTRA "s-p-store"
                MOV     SP, BX
                NEXT
END-CODE  COMPILE-ONLY

\ Get the value of the stack pointer.
CODE SP@                ( -- x )                \ EXTRA "s-p-fetch"
                MOV     AX, SP
                PUSH    BX
                MOV     BX, AX
                NEXT
END-CODE

FORTH:

\G +n is the number of single-cell values on the data stack before
\G +n was placed on the stack.
CODE DEPTH              ( -- +n )               \ FORTH
                MOV     AX, T' SP0
                SUB     AX, SP
                SAR     AX, # 1
                PUSH    BX
                MOV     BX, AX
                NEXT
END-CODE  ANS

\G Remove x from the stack.
CODE DROP               ( x -- )                \ FORTH
                POP     BX
                NEXT
END-CODE  ANS

\G Duplicate x if it is non-zero.
CODE ?DUP               ( x -- 0 | x x )        \ FORTH "question-dupe"
                TEST    BX, BX
        0<> IF
END-CODE  ANS

\G Duplicate x.
CODE DUP                ( x -- x x )            \ FORTH  "dupe"
                PUSH    BX
        THEN
                NEXT
END-CODE  ANS

\G Drop the first item below the top of the stack.
CODE NIP                ( x1 x2 -- x2 )         \ FORTH
                INC     SP
                INC     SP
                NEXT
END-CODE  ANS

\G Place a copy of x1 on top of the stack.
CODE OVER               ( x1 x2 -- x1 x2 x1 )   \ FORTH
                POP     AX
                PUSH    AX
                PUSH    BX
                MOV     BX, AX
                NEXT
END-CODE  ANS

\G Copy the first (top) stack item below the second stack item.
CODE TUCK               ( x1 x2 -- x2 x1 x2 )   \ FORTH
                POP     AX
                PUSH    BX
                PUSH    AX
                NEXT
END-CODE  ANS

\G Exchange the top two stack items.
CODE SWAP               ( x1 x2 -- x2 x1 )      \ FORTH
                POP     AX
                PUSH    BX
                MOV     BX, AX
                NEXT
END-CODE  ANS

\G Rotate the top three stack items.
CODE ROT                ( x1 x2 x3 -- x2 x3 x1 )        \ FORTH "rote"
                POP     AX
                POP     DX
                PUSH    AX
                PUSH    BX
                MOV     BX, DX
                NEXT
END-CODE  ANS

EXTRA:

\G Rotate the top three stack items. Equivalent to ROT ROT .
CODE -ROT               ( x1 x2 x3 -- x3 x1 x2 )        \ EXTRA "minus-rote"
                MOV     DX, BX
                POP     BX
                POP     AX
                PUSH    DX
                PUSH    AX
                NEXT
END-CODE

\G Copy the third stack item to the top of the stack.
CODE PLUCK              ( x1 x2 x3 -- x1 x2 x3 x1 )     \ EXTRA
                PUSH    BX
                MOV     BX, SP
                MOV     BX, SS: 4 [BX]
                NEXT
END-CODE

FORTH:

\G Remove u. Copy the xu to the top of the stack. An ambiguous
\G condition exists if there are less than u+2 items on the stack
\G before PICK is executed.
CODE PICK       ( xu .. x0 u -- xu .. x0 xu )           \ FORTH
                SHL     BX, # 1
                ADD     BX, SP
                MOV     BX, SS: 0 [BX]
                NEXT
END-CODE  ANS

\G Remove u. Rotate u+1 items on the top of the stack. An ambiguous
\G condition exists if there are less than u+2 items on the stack
\G before ROLL is executed.
CODE ROLL       ( xu xu-1 .. x0 u -- xu-1 .. x0 xu )    \ FORTH
                MOV     DX, SI
                MOV     CX, BX
                SHL     BX, # 1
                ADD     BX, SP
                MOV     SI, BX
                MOV     DI, BX
                MOV     BX, SS: 0 [BX]
                DEC     SI
                DEC     SI
                STD
                PUSH    ES
                MOV     AX, SS
                MOV     ES, AX
                REP     MOVSW   SS:
                POP     ES
                CLD
                INC     SP
                INC     SP
                MOV     SI, DX
                NEXT
END-CODE  ANS

\G Drop cell pairs x1 x2 from the stack.
CODE 2DROP              ( x1 x2 -- )            \ FORTH "two-drop"
                INC     SP
                INC     SP
                POP     BX
                NEXT
END-CODE  ANS

\G Duplicate cell pair x1 x2.
CODE 2DUP       ( x1 x2 -- x1 x2 x1 x2 )        \ FORTH "two-dupe"
                POP     AX
                PUSH    AX
                PUSH    BX
                PUSH    AX
                NEXT
END-CODE  ANS

\G Copy cell pair x1 x2 to the top of the stack.
CODE 2OVER      ( x1 x2 x3 x4 -- x1 x2 x3 x4 x1 x2 )    \ FORTH "two-over"
                POP     CX
                POP     AX
                POP     DX
                PUSH    DX
                PUSH    AX
                PUSH    CX
                PUSH    BX
                PUSH    DX
                MOV     BX, AX
                NEXT
END-CODE  ANS

\G Exchange the two top cell pairs.
CODE 2SWAP      ( x1 x2 x3 x4 -- x3 x4 x1 x2 )  \ FORTH "two-swap"
                MOV     DX, BX
                POP     CX
                POP     BX
                POP     AX
                PUSH    CX
                PUSH    DX
                PUSH    AX
                NEXT
END-CODE  ANS

EXTRA:

\G Drop the first cell pair below the top cell pair of the stack.
CODE 2NIP       ( x1 x2 x3 x4 -- x3 x4 )        \ EXTRA "two-nip"
                POP     AX
                ADD     SP, # 4
                PUSH    AX
                NEXT
END-CODE

FORTH:

\G Rotate the top three cell pairs on the stack bringing cell pair
\G x1 x2 to the top of the stack.
CODE 2ROT  ( x1 x2 x3 x4 x5 x6 -- x3 x4 x5 x6 x1 x2 )      \ FORTH "two-rote"
$IF386
                PUSH    BX
                POP     EBX
                POP     EDX
                POP     EAX
                PUSH    EDX
                PUSH    EBX
                PUSH    EAX
                POP     BX
$ELSE
                DEC     BP
                DEC     BP
                MOV     0 [BP], SI
                POP     AX
                POP     CX
                POP     DX
                POP     SI
                POP     DI
                PUSH    DX
                PUSH    CX
                PUSH    AX
                PUSH    BX
                PUSH    DI
                MOV     BX, SI
                MOV     SI, 0 [BP]
                INC     BP
                INC     BP
$THEN
                NEXT
END-CODE  ANS

EXTRA:

\G Check the three stack pointers and when they are too low or
\G too high, exception -3, -4, -5, -6, -522 or -523 will occur.
CODE ?STACK             ( -- )          \ EXTRA "question-stack"
                CMP     BP, # 10
                JB      0 $
                MOV     AX, T' RP0
                CMP     BP, AX
                JA      1 $

                ADD     AX, # 20
                CMP     SP, AX
                JB      2 $
                MOV     AX, T' SP0
                CMP     SP, AX
                JA      3 $

                ADD     AX, # 20
                MOV     CX, lsp
                CMP     CX, AX
                JB      4 $
                MOV     AX, T' LSP0
                CMP     CX, AX
                JA      5 $

                NEXT
        0 $:    GOTO    _rpov
        1 $:    GOTO    _rpun
        2 $:    GOTO    _spov
        3 $:    GOTO    _spun
        4 $:    GOTO    _lsov
        5 $:    GOTO    _lsun
END-CODE

\ local stack

INTERNAL:

\ Store x in the local stack pointer.
CODE LSP!               ( x -- )                \ EXTRA "l-s-p-store"
                MOV     lsp BX
                POP     BX
                NEXT
END-CODE  COMPILE-ONLY

\ Return the value of the local stack pointer.
CODE LSP@               ( -- x )                \ EXTRA "l-s-p-fetch"
                PUSH    BX
                MOV     BX, lsp
                NEXT
END-CODE

\ control-flow stack

FORTH:

\G Interpretation: ( i*x -- )
\G This word is marked compile only. The default interpreter issues
\G exception -14 when an attempt is made to execute this word.
\G
\G ( C: destu ... orig0|dest0 -- destu ... orig0|dest0 destu )
\G ( S: u -- )
\G Remove u. Copy destu to the top of the control-flow stack. An
\G ambiguous condition exists if there are less than u+1 items, each
\G of which shall be an orig or dest, on the control-flow stack
\G before CS-PICK is executed.
\G The control-flow stack in CHForth is implemented on the data
\G stack, u is the topmost item on the data stack.
: CS-PICK                                                   \ FORTH "c-s-pick"
        2* 1+ DUP>R PICK R> PICK
        ;  COMPILE-ONLY  ANS

\G Interpretation: ( i*x -- )
\G This word is marked compile only. The default interpreter issues
\G exception -14 when an attempt is made to execute this word.
\G
\G ( C: origu|destu origu-1|destu-1 ... orig0|dest0 --
\G origu-1|destu-1 ... orig0|dest0 origu|destu ) 
\G ( S: u -- )
\G Remove u. Rotate u+1 elements on top of the control-flow stack so
\G that origu|destu is on top of the control-flow stack. An
\G ambiguous condition exists if there are less than u+1 items, each
\G of which shall be an orig or dest, on the control-flow stack
\G before CS-ROLL is executed.
\G The control-flow stack in CHForth is implemented on the data
\G stack, u is the topmost item on the data stack.
: CS-ROLL                                                   \ FORTH "c-s-roll"
        2* 1+ DUP>R ROLL R> ROLL
        ;  COMPILE-ONLY  ANS

                            \ (* End of Source *) /
