\ ----------------------------------------------------------------------
\ LANGUAGE    : ANS Forth 
\ PROJECT     : Meta compiler for CHForth version 1.1.0 
\ FILENAME    : STRINGS.FRT 
\ DESCRIPTION : String handling 
\ AUTHOR      : Coos Haak, Utrecht 
\ CREATED     : May 11, 1994
\ ----------------------------------------------------------------------



LABEL ^CHRS
        000 C, 001 C, 002 C, 003 C, 004 C, 005 C, 006 C, 007 C,
        008 C, 009 C, 00A C, 00B C, 00C C, 00D C, 00E C, 00F C,
        010 C, 011 C, 012 C, 013 C, 014 C, 015 C, 016 C, 017 C,
        018 C, 019 C, 01A C, 01B C, 01C C, 01D C, 01E C, 01F C,
        020 C, '!' C, '"' C, '#' C, '$' C, '%' C, '&' C, ''' C,
        '(' C, ')' C, '*' C, '+' C, ',' C, '-' C, '.' C, '/' C,
        '0' C, '1' C, '2' C, '3' C, '4' C, '5' C, '6' C, '7' C,
        '8' C, '9' C, ':' C, ';' C, '<' C, '=' C, '>' C, '?' C,
        '@' C, 'A' C, 'B' C, 'C' C, 'D' C, 'E' C, 'F' C, 'G' C,
        'H' C, 'I' C, 'J' C, 'K' C, 'L' C, 'M' C, 'N' C, 'O' C,
        'P' C, 'Q' C, 'R' C, 'S' C, 'T' C, 'U' C, 'V' C, 'W' C,
        'X' C, 'Y' C, 'Z' C, '[' C, '\' C, ']' C, '^' C, '_' C,
        '`' C, 'A' C, 'B' C, 'C' C, 'D' C, 'E' C, 'F' C, 'G' C,
        'H' C, 'I' C, 'J' C, 'K' C, 'L' C, 'M' C, 'N' C, 'O' C,
        'P' C, 'Q' C, 'R' C, 'S' C, 'T' C, 'U' C, 'V' C, 'W' C,
        'X' C, 'Y' C, 'Z' C, '{' C, '|' C, '}' C, '~' C, '' C,
        080 C, 081 C, 082 C, 083 C, 084 C, 085 C, 086 C, 087 C,
        088 C, 089 C, 08A C, 08B C, 08C C, 08D C, 08E C, 08F C,
        090 C, 091 C, 092 C, 093 C, 094 C, 095 C, 096 C, 097 C,
        098 C, 099 C, 09A C, 09B C, 09C C, 09D C, 09E C, 09F C,
        0A0 C, 0A1 C, 0A2 C, 0A3 C, 0A4 C, 0A5 C, 0A6 C, 0A7 C,
        0A8 C, 0A9 C, 0AA C, 0AB C, 0AC C, 0AD C, 0AE C, 0AF C,
        0B0 C, 0B1 C, 0B2 C, 0B3 C, 0B4 C, 0B5 C, 0B6 C, 0B7 C,
        0B8 C, 0B9 C, 0BA C, 0BB C, 0BC C, 0BD C, 0BE C, 0BF C,
        0C0 C, 0C1 C, 0C2 C, 0C3 C, 0C4 C, 0C5 C, 0C6 C, 0C7 C,
        0C8 C, 0C9 C, 0CA C, 0CB C, 0CC C, 0CD C, 0CE C, 0CF C,
        0D0 C, 0D1 C, 0D2 C, 0D3 C, 0D4 C, 0D5 C, 0D6 C, 0D7 C,
        0D8 C, 0D9 C, 0DA C, 0DB C, 0DC C, 0DD C, 0DE C, 0DF C,
        0E0 C, 0E1 C, 0E2 C, 0E3 C, 0E4 C, 0E5 C, 0E6 C, 0E7 C,
        0E8 C, 0E9 C, 0EA C, 0EB C, 0EC C, 0ED C, 0EE C, 0EF C,
        0F0 C, 0F1 C, 0F2 C, 0F3 C, 0F4 C, 0F5 C, 0F6 C, 0F7 C,
        0F8 C, 0F9 C, 0FA C, 0FB C, 0FC C, 0FD C, 0FE C, 0FF C,

EXTRA:

\G Convert char1 to uppercase.
CODE >UPC               ( char1 -- char2 )      \ EXTRA  "to-u-p-c"
                XOR     BH, BH
                MOV     BL, ^CHRS [BX]
                NEXT
END-CODE

\G Convert the lowercase characters in the string specified by
\G c-addr u to uppercase.
CODE UPPER              ( c-addr u -- )         \ EXTRA
                MOV     CX, BX
                POP     DI
        CNZ IF
                MOV     DX, ES
                MOV     ES, T' SRCSEG
                MOV     BX, # ^CHRS
        DO
                MOV     AL, ES: 0 [DI]
                XLAT
                STOSB
        LOOP
                MOV     ES, DX
        THEN
                POP     BX
                NEXT
END-CODE

FORTH:

\G Compare the string specified by c-addr1 u2 to the string
\G specified by c-addr2 u2. The strings are compared, beginning at
\G the given addresses, character by character, up to the length of
\G the shorter string or until a difference is found. If the two
\G strings are identical up to the length of the shorter string, n
\G is zero if both strings are of equal length, minus-one of u1 is
\G less than u2, and one otherwise. If the two strings are not
\G identical up to the length of the shorter string, n is minus-one
\G if the first non-matching character in the string specified by
\G c-addr1 u1 has a lesser numerical value than the corresponding
\G character in the string specified by c-addr2 u2 and one
\G otherwise.
\G See also: COMPARE-UPPERCASE
CODE COMPARE            ( c-addr1 u1 c-addr2 u2 -- flag )       \ FORTH
                XCHG    SP, BP
                PUSH    ES
                PUSH    SI
                XCHG    SP, BP
                POP     DI
                POP     CX
                POP     SI
                MOV     ES, T' SRCSEG
        0 $:    TEST    BX, BX
                JZ      2 $
                JCXZ    3 $
                DEC     CX
                DEC     BX
                LODSB
                SCASB
                JZ      0 $
                MOV     BX, # 1
                JGE     1 $
                NEG     BX
        1 $:    XCHG    SP, BP
                POP     SI
                POP     ES
                XCHG    SP, BP
                NEXT
        2 $:    MOV     BX, CX
                NEG     BX
        3 $:    TEST    BX, BX
                JZ      1 $
                MOV     BX, # 1
                JS      1 $
                NEG     BX
                JMP     1 $
END-CODE  ANS

EXTRA:

\G Compare the string specified by c-addr1 u2 to the string
\G specified by c-addr2 u2. The strings are compared, beginning at
\G the given addresses, character by character, up to the length of
\G the shorter string or until a difference is found. If the two
\G strings are identical, where lower case characters are considered
\G equal to upper case characters, up to the length of the shorter
\G string, n is zero if both strings are of equal length, minus-one
\G of u1 is less than u2, and one otherwise. If the two strings are
\G not identical up to the length of the shorter string, n is
\G minus-one if the first non-matching character in the string
\G specified by c-addr1 u1 has a lesser numerical value, where the
\G value of lower case characters are converted to their upper case
\G equivalent values without affecting the strings themselves, than
\G the corresponding character in the string specified by c-addr2 u2
\G and one otherwise.
\G See also: COMPARE
CODE COMPARE-UPPERCASE  ( c-addr1 u1 c-addr2 u2 -- flag )       \ EXTRA
                XCHG    SP, BP
                PUSH    ES
                PUSH    SI
                XCHG    SP, BP
                POP     DI
                POP     CX
                POP     SI
                MOV     ES, T' SRCSEG
                MOV     DX, BX
                MOV     BX, # ^CHRS
        0 $:    TEST    DX, DX
                JZ      2 $
                JCXZ    3 $
                DEC     CX
                DEC     DX
                LODSB
                XLAT
                MOV     AH, AL
                MOV     AL, ES: 0 [DI]
                INC     DI
                XLAT
                CMP     AH, AL
                JZ      0 $
                MOV     DX, # 1
                JGE     1 $
                NEG     DX
        1 $:    MOV     BX, DX
                XCHG    SP, BP
                POP     SI
                POP     ES
                XCHG    SP, BP
                NEXT
        2 $:    MOV     DX, CX
                NEG     DX
        3 $:    TEST    DX, DX
                JZ      1 $
                MOV     DX, # 1
                JS      1 $
                NEG     DX
                JMP     1 $
END-CODE

FORTH:

\G Search the string specified by c-addr1 u1 for the string
\G specified by c-addr2 u2. If flag is true, a match was found at
\G c-addr3 with u3 characters remaining. If flag is false there was
\G no match and c-addr3 is c-addr1 and u3 is u1. 
: SEARCH        ( c-addr1 u1 c-addr2 u2 -- c-addr3 u3 flag )    \ FORTH
        LOCAL Len2 LOCAL Adr2 LOCAL Len1 LOCAL Adr1
        Len2
        IF      Len1 Len2 - 1+ 0 MAX 0
                ?DO     Adr2 Len2 Adr1 I + Len2 COMPARE 0=
                        IF      Adr1 Len1 I /STRING TRUE UNLOOP EXIT
                        THEN
                LOOP
        THEN
        Adr1 Len1 FALSE
        ;  ANS

\G If u1 is greater than zero, u2 is equal to u1 less the number of
\G spaces at the end of the character string specified by c-addr u1.
\G If u1 is zero or the entire string consists of spaces, u2 is
\G zero.
CODE -TRAILING  ( c-addr u1 -- c-addr u2 )      \ FORTH "dash-trailing"
                MOV     CX, BX
        CNZ IF
                MOV     DX, ES
                MOV     AX, CS
                MOV     ES, AX
                POP     DI
                PUSH    DI
                DEC     DI
                ADD     DI, CX
                MOV     AL, # 20
                STD
                REPZ    SCASB
        0<> IF
                INC     CX
        THEN
                MOV     BX, CX
                CLD
                MOV     ES, DX
        THEN
                NEXT
END-CODE  ANS

EXTRA:

\G Place the string specified by c-addr1 u as a counted string at
\G c-addr2.
CODE PACK       ( c-addr1 u c-addr2 -- c-addr2 )            \ EXTRA
                XCHG    SP, BP
                PUSH    ES
                PUSH    SI
                XCHG    SP, BP
                PUSH    DS
                POP     ES
                MOV     DI, BX
                POP     CX
                POP     SI
                MOV     0 [DI], CL
                INC     DI
                REP     MOVSB
                XCHG    SP, BP
                POP     SI
                POP     ES
                XCHG    SP, BP
                NEXT
END-CODE

\G Place the string specified by c-addr1 u as a counted string at
\G c-addr2.
: PLACE         ( c-addr1 u c-addr2 -- )       \ EXTRA
        PACK DROP
        ;

\G Increment the numerical value of the character at c-addr by one.
\G Store char at the character address given by the sum of the
\G incremented numerical value of the character at c-addr and
\G c-addr.
CODE APPEND-CHAR        ( char c-addr -- )              \ EXTRA
                INC     0 [BX] BYTE
$IF386
                MOVZX   AX, 0 [BX]
$ELSE
                MOV     AL, 0 [BX]
                XOR     AH, AH
$THEN
                ADD     BX, AX
                POP     AX
                MOV     0 [BX], AL
                POP     BX
                NEXT
END-CODE

\G Add u to the numerical value of the character at c-addr2. Store
\G the string specified by c-addr1 u at the character address given
\G by the sum of c-addr2 and the incremented numerical value of the
\G character at c-addr2.
CODE APPEND             ( c-addr1 u c-addr2 -- )        \ EXTRA
                XCHG    SP, BP
                PUSH    ES
                PUSH    SI
                XCHG    SP, BP
                PUSH    DS
                POP     ES
                MOV     DI, BX
                MOV     SI, 0 [DI]
                AND     SI, # FF
                POP     CX
                ADD     0 [DI], CL
                INC     DI
                ADD     DI, SI
                POP     SI
                REP     MOVSB
                XCHG    SP, BP
                POP     SI
                POP     ES
                XCHG    SP, BP
                POP     BX
                NEXT
END-CODE

ORPHAN _SKIP
-- in:  DI = addr, CX = len, BL = char
-- out: DI = addr, CX = len, BL = char
        CNZ IF                              \ Do nothing with a null string
                CMP     BL, # 20
        0= IF
                PUSH    DS                  \ Space is any control character
                MOV     DS, T' SRCSEG
        BEGIN
                CMP     0 [DI], BL
        U<= WHILE
                INC     DI                  \ Reject all graphics characters
                DEC     CX                  \ Accept control and space
        0= UNTIL
        THEN
                POP     DS
                RET                         \ Leave out else branch
        THEN
                PUSH    ES
                MOV     ES, T' SRCSEG
                MOV     AL, BL
                REPZ    SCASB               \ Skip exact character
        0<> IF
                DEC     DI                  \ Overshoot
                INC     CX
        THEN
                POP     ES
        THEN
                RET
END-CODE

\G Skip leading occurences of char in the string specified by
\G c-addr1 u1 and return the remaining string specified by c-addr2
\G u2. If the string specified by c-addr1 u1 contains only
\G occurences of char, u2 is zero.
\G
\G If char is the character for space, control characters are
\G considered equal to char.
CODE SKIP               ( c-addr1 u1 char -- c-addr2 u2 )       \ EXTRA
                POP     CX
                POP     DI
                CALL    _SKIP
                PUSH    DI
                MOV     BX, CX
                NEXT
END-CODE

ORPHAN _SCAN
-- in:  DI = addr, CX = len, BL = char
-- out: DI = addr, CX = len, BL = char
        CNZ IF                              \ Do nothing with a null string
                CMP     BL, # 20
        0= IF
                PUSH    DS                  \ Space is any control character
                MOV     DS, T' SRCSEG
        BEGIN
                CMP     0 [DI], BL
        U> WHILE
                INC     DI                  \ Accept all graphics characters
                DEC     CX                  \ Reject control and space
        0= UNTIL
        THEN
                POP     DS
                RET                         \ Leave out else branch
        THEN
                PUSH    ES
                MOV     ES, T' SRCSEG
                MOV     AL, BL
                REPNZ   SCASB               \ Scan exact character
        0= IF
                DEC     DI                  \ Overshoot
                INC     CX
        THEN
                POP     ES
        THEN
                RET
END-CODE

\G Scan the string specified by c-addr1 u1 for an occurence of char
\G and return the part of the string starting with the found char as
\G a string specified by c-addr2 u2. If the string specified by
\G c-addr1 u1 does not contain char, u2 is zero.
\G
\G If char is the character for space, control characters are
\G considered equal to char.
CODE SCAN               ( c-addr1 u1 char -- c-addr2 u2 )       \ EXTRA
                POP     CX
                POP     DI
                CALL    _SCAN
                PUSH    DI
                MOV     BX, CX
                NEXT
END-CODE

FORTH:

\G Adjust the character string at c-addr1 by n characters. The
\G resulting character string, specified by c-addr2 u2, begins at
\G c-addr1 plus n characters and is u1 minus n characters long.
CODE /STRING            ( c-addr1 u1 n -- c-addr2 u2 )  \ FORTH "slash-string"
                POP     AX
                POP     DX
                SUB     AX, BX
                ADD     DX, BX
                PUSH    DX
                MOV     BX, AX
                NEXT
END-CODE  ANS

\G c-addr is the address of a caracter string and u is the string's
\G character count. u may have a value in the range up to 255. The
\G character string should contain a keyword from Environmental
\G Queries or the optinonal word sets to be checked for
\G correspondence with an attribute of the present environment. If
\G the system treats the attribute as unknown, the returned flag is
\G false; otherwise, the flag is true and i*x returned is of the
\G type specified in the table for the attribute queried.
CODE ENVIRONMENT? ( c-addr u -- false | i*x true ) \ FORTH "environment-query"
                POP     AX
                XOR     BX, BX
                NEXT
END-CODE  ANS

\G Parse ccc delimited by the delimiter char.
\G
\G c-addr is the address (within the input buffer) and u is the
\G length of the parsed string. If the parse area was empty, the
\G resulting string has zero length.
\G
\G If char is the character for space, control characters are
\G considered equal to char.
CODE PARSE              ( char "ccc<char>" -- c-addr u )    \ FORTH
                MOV     DI, T' #TIB CELL+
                MOV     CX, T' #TIB
                MOV     AX, T' >IN
                CMP     CX, AX
        U<= IF
                MOV     AX, CX
        THEN
                SUB     CX, AX
                ADD     DI, AX
                PUSH    DI
                MOV     DX, DI
                CALL    _SCAN
                MOV     BX, DI
                SUB     BX, DX
        CNZ IF
                INC     T' >IN
        THEN
                ADD     T' >IN BX
                NEXT
END-CODE  ANS

EXTRA:

\G Skip leading char delimiters. Parse ccc delimited by the
\G delimiter char.
\G
\G c-addr is the address (within the input buffer) and u is the
\G length of the parsed string. If the parse area was empty, the
\G resulting string has zero length.
\G
\G If char is the character for space, control characters are
\G considered equal to char.
CODE PARSE-WORD     ( char "<chars>ccc<char>" -- c-addr u )     \ EXTRA
                MOV     DI, T' #TIB CELL+
                MOV     CX, T' #TIB
                MOV     AX, T' >IN
                CMP     CX, AX
        U<= IF
                MOV     AX, CX
        THEN
                SUB     CX, AX
                ADD     DI, AX
                MOV     DX, CX
                CALL    _SKIP
                SUB     DX, CX
                ADD     T' >IN DX
                PUSH    DI
                MOV     parsed DI
                CALL    _SCAN
                MOV     BX, DI
                SUB     BX, parsed
                MOV     prslen BX
        CNZ IF
                INC     T' >IN
        THEN
                ADD     T' >IN BX
                NEXT
END-CODE

\G c-addr u specifies the character string that was the last string
\G parsed by PARSE-WORD or WORD . A program may not change the
\G contents of the string.
CODE PARSED-WORD        ( -- c-addr u )         \ EXTRA
                PUSH    BX
                PUSH    parsed
                MOV     BX, prslen
                NEXT
END-CODE

FORTH:

\G Skip leading delimiters. Parse characters ccc delimited by char.
\G An ambiguous condition exists if the length of the parsed string
\G is greater then the implementation defined length of a counted
\G string.
\G
\G c-addr is the address of a transient region containing the parsed
\G word as a counted string. If the parse area was empty or
\G contained no characters other than the delimiter, the resulting
\G string has zero length. A space, not included in the length,
\G follows the string. A Standard Program may replace characters
\G within the string.
\G
\G If char is the character for space, control characters are
\G considered equal to char.
\G
\G Note: the requirement to follow the string with a space is
\G obsolescent and is included as a concession to existing programs
\G that use CONVERT . A Standard Program shall not depend on the
\G existance of the space.
: WORD          ( char "<chars>ccc<char>" -- c-addr )       \ FORTH
        PARSE-WORD HERE PACK BL OVER COUNT + C!
        ;  ANS

EXTRA:

\G Skip leading space delimiters. Parse name delimited by a space.
\G Find name. If found return the execution token xt of that word.
\G Otherwise refill the input buffer with REFILL and repeat.
\G Exception -58 will occur if refilling the input buffer fails.
: SCAN-ANY      ( -- xt )               \ EXTRA
        BEGIN   BL WORD FIND 0=
        WHILE   DROP >IN @ #TIB @ =
                IF      REFILL INVERT #-58 ?ERROR
                THEN
        REPEAT
        ;

FORTH:

\G Parse and display ccc delimited by a right parenthesis ")". .( is
\G immediate.
\G See also: ."
: .(            ( "ccc<paren>" -- )         \ FORTH "dot-paren"
        ')' PARSE TYPE
        ;  IMMEDIATE  ANS

\G Parse ccc delimited by a right parenthesis ")". ( is immediate.
\G
\G The number of characters in ccc may be zero to the number of
\G characters in the parse area.
\G
\G When parsing from a text file, if the end of the parse area is
\G reached before a right parenthesis is found, refill the input
\G buffer from the next line of the file, set >IN to zero, and
\G resume parsing, repeating this process until either a right
\G parenthesis is found or the end of the file is reached.
: (             ( "ccc<paren>" -- )         \ FORTH "paren"
        BEGIN   ')' PARSE + SOURCE + 1- MIN C@ ')' <>
        WHILE   REFILL INVERT
        UNTIL   THEN
        ;  IMMEDIATE  ANS

\G If the flag is true, do nothing. Otherwise repeatedly skip
\G leading spaces, parse and discard space-delimited words from the
\G parse area, including nested occurences of [IF] ... [THEN] and
\G [IF] ... [ELSE] ... [THEN] , until either the word [ELSE] or the
\G word [THEN] has been parsed and discarded. If the parse area
\G becomes exhausted, it is refilled as with REFILL . [IF] is
\G immediate.
\G
\G An ambiguous condition exists if [IF] is POSTPONEd. If the end of
\G the input stream is reached and cannot be refilled before the
\G terminating [ELSE] or [THEN] is parsed exception -58 occurs.
: [IF]          ( flag -- )             \ FORTH "bracket-if"
        IF      EXIT                                    \ stop when true
        THEN
        BEGIN   SCAN-ANY DUP ['] [THEN] <>              \ stop after [THEN]
        WHILE   DUP ['] [ELSE] <>                       \ stop after [ELSE]
        WHILE   ['] [IF] =
                IF      [ELSE]                          \ recurse
                THEN
        REPEAT
        THEN
        DROP
        ;  IMMEDIATE  ANS

\G Repeatedly skip leading spaces, parse and discard space-delimited
\G words from the parse area, including nested occurences of [IF]
\G ... [THEN] and [IF] ... [ELSE] ... [THEN] , until the word [THEN]
\G has been parsed and discarded. If the parse area becomes
\G exhausted, it is refilled as with REFILL . If the refilling of
\G the input buffer fails, exception -58 occurs. [ELSE] is
\G immediate.
: [ELSE]        ( -- )                  \ FORTH "bracket-else"
        BEGIN   SCAN-ANY DUP ['] [THEN] <>              \ stop after [THEN]
        WHILE   ['] [IF] =
                IF      [ELSE]                          \ recurse
                THEN
        REPEAT
        DROP
        ;  IMMEDIATE  ANS

\G Does nothing. [THEN] is immediate.
: [THEN]        ( -- )                  \ FORTH "bracket-then"
        ;  IMMEDIATE  ANS

EXTRA:

\G Repeatedly skip leading spaces, parse and discard space-delimited
\G words from the parse area, until the word ENDDOC has been parsed
\G and discarded. If the parse area becomes exhausted, it is
\G refilled as with REFILL . DOC is immediate.
\G
\G An ambiguous condition exists if DOC is POSTPONEd. If the end of
\G the input stream is reached and cannot be refilled before the
\G terminating ENDDOC is parsed, exception -532 occurs.
: DOC           ( -- )                              \ EXTRA
        BEGIN   BL PARSE-WORD
                CASESENSITIVE @ INVERT
                IF      TEMPORARY PACK
                        COUNT 2DUP UPPER
                THEN
                S" ENDDOC" COMPARE
        WHILE   >IN @ #TIB @ =
                IF      REFILL INVERT #-532 ?ERROR
                THEN
        REPEAT
        ;  IMMEDIATE

\G Repeatedly skip leading spaces, parse and discard space-delimited
\G words from the parse area, until the word *) has been parsed and
\G discarded. If the parse area becomes exhausted, it is refilled as
\G with REFILL . (* is immediate.
\G
\G An ambiguous condition exists if (* is POSTPONEd. If the end of
\G the input stream is reached and cannot be refilled before the
\G terminating *) is parsed, exception -533 occurs.
: (*            ( -- )                              \ EXTRA
        BEGIN   BL PARSE-WORD S" *)" COMPARE
        WHILE   >IN @ #TIB @ =
                IF      REFILL INVERT #-533 ?ERROR
                THEN
        REPEAT
        ;  IMMEDIATE


FORTH:

\G If BLK contains zero, parse and discard the remainder of the
\G parse area; otherwise parse and discard the portion of the parse
\G area corresponding to the remainder of the current line. \ is an
\G immediate word.
: \             ( "ccc<eol>" -- )                       \ FORTH "backslash"
        BLK @
        IF      #64 >IN @ OVER MOD - >IN +! EXIT        \ to next line
        THEN
        #TIB @ >IN !                                    \ skip rest of line
        ;  IMMEDIATE  ANS

EXTRA:

\G Parse ccc delimited by '"' (double quote) and compile it as a
\G counted string in the dictionary. Execution of HERE just before
\G the execution of ", will give the address of the string.
: ",            ( "ccc<">" -- )                 \ EXTRA "quote-comma"
        '"' PARSE HERE PACK C@ 1+ ALLOT ALIGN
        ;

INTERNAL:

\ Parse a ccc delimited by '"' (double quote) and compile it in
\ the list segment.
: L",           ( "ccc<">" -- )                 \ EXTRA "s-quote-comma"
        '"' PARSE DUP LC, 0                     \ Parse and store length
        ?DO     COUNT LC,                       \ Store characters
        LOOP
        DROP LHERE 1 AND
        IF      0 LC,                           \ Align list segment
        THEN
        ;

\ Type a string at l-addr in the list segment.
: TYPESTRING    ( l-addr -- )                   \ EXTRA
        LSEG SWAP COUNTX TYPEX                  \ type line from LSEG
        ;

EXTRA:

\G Copy any non-tab characters in the string specified by c-addr u1
\G to a string specified by c-addr2 u2. Tab characters are expanded
\G to spaces with a tab distance of 8 positions.
CODE EXPAND     ( c-addr1 u1 c-addr2 -- c-addr2 u2 )    \ EXTRA
                XCHG    SP, BP                          \ save registers
                PUSH    ES
                PUSH    SI
                XCHG    SP, BP
                PUSH    CS                              \ copy segment
                POP     ES
                MOV     DI, BX                          \ destiny
                XOR     AL, AL                          \ erase
                MOV     CX, T' /LINE                    \ size
                REP     STOSB
                MOV     DI, BX                          \ destiny
                POP     CX                              \ length of old line
                POP     SI                              \ source
                PUSH    DI                              \ destiny
                XOR     BX, BX                          \ count of new line
                TEST    CX, CX                          \ length positive?
                JLE     5 $
        1 $:    LODSB                                   \ get character
                CMP     AL, # ^I                        \ is it a tab
                JZ      2 $
                STOSB                                   \ put character
                INC     BL                              \ increment count
                JMP     4 $                             \ again
        2 $:    MOV     AX, # 0807                      \ maximum 8
                AND     AL, BL                          \ keep 0..7
                SUB     AH, AL                          \ subtract
                MOV     AL, # 20                        \ fill with spaces
        3 $:    STOSB                                   \ store space
                INC     BL                              \ increment count
                DEC     AH                              \ decrement count
                JNZ     3 $
        4 $:    CMP     BX, T' /LINE                    \ not exceding maximum
                JAE     5 $
                LOOP    1 $                             \ again
        5 $:    XCHG    SP, BP                          \ restore registers
                POP     SI
                POP     ES
                XCHG    SP, BP
                NEXT
END-CODE

FORTH:

                            \ (* End of Source *) /
